/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.datalake.store.FirewallRules;
import com.microsoft.azure.management.datalake.store.implementation.DataLakeStoreAccountManagementClientImpl;
import com.microsoft.azure.management.datalake.store.models.CreateOrUpdateFirewallRuleParameters;
import com.microsoft.azure.management.datalake.store.models.FirewallRule;
import com.microsoft.azure.management.datalake.store.models.PageImpl;
import com.microsoft.azure.management.datalake.store.models.UpdateFirewallRuleParameters;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class FirewallRulesImpl
implements FirewallRules {
    private FirewallRulesService service;
    private DataLakeStoreAccountManagementClientImpl client;

    public FirewallRulesImpl(Retrofit retrofit, DataLakeStoreAccountManagementClientImpl client) {
        this.service = (FirewallRulesService)retrofit.create(FirewallRulesService.class);
        this.client = client;
    }

    @Override
    public PagedList<FirewallRule> listByAccount(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listByAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<FirewallRule>((Page)response.body()){

            public Page<FirewallRule> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FirewallRulesImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<FirewallRule>> listByAccountAsync(String resourceGroupName, String accountName, ListOperationCallback<FirewallRule> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<FirewallRule>>>>(){

            public Observable<ServiceResponse<Page<FirewallRule>>> call(String nextPageLink) {
                return FirewallRulesImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<FirewallRule>> listByAccountAsync(String resourceGroupName, String accountName) {
        return this.listByAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<FirewallRule>>, Page<FirewallRule>>(){

            public Page<FirewallRule> call(ServiceResponse<Page<FirewallRule>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<FirewallRule>>> listByAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listByAccountSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<FirewallRule>>, Observable<ServiceResponse<Page<FirewallRule>>>>(){

            public Observable<ServiceResponse<Page<FirewallRule>>> call(ServiceResponse<Page<FirewallRule>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FirewallRulesImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallRule>>> listByAccountSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FirewallRule>>>>(){

            public Observable<ServiceResponse<Page<FirewallRule>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallRulesImpl.this.listByAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FirewallRule>> listByAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FirewallRule>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public FirewallRule createOrUpdate(String resourceGroupName, String accountName, String firewallRuleName, String startIpAddress, String endIpAddress) {
        return (FirewallRule)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName, startIpAddress, endIpAddress).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<FirewallRule> createOrUpdateAsync(String resourceGroupName, String accountName, String firewallRuleName, String startIpAddress, String endIpAddress, ServiceCallback<FirewallRule> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName, startIpAddress, endIpAddress), serviceCallback);
    }

    @Override
    public Observable<FirewallRule> createOrUpdateAsync(String resourceGroupName, String accountName, String firewallRuleName, String startIpAddress, String endIpAddress) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName, startIpAddress, endIpAddress).map((Func1)new Func1<ServiceResponse<FirewallRule>, FirewallRule>(){

            public FirewallRule call(ServiceResponse<FirewallRule> response) {
                return (FirewallRule)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<FirewallRule>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, String firewallRuleName, String startIpAddress, String endIpAddress) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (firewallRuleName == null) {
            throw new IllegalArgumentException("Parameter firewallRuleName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (startIpAddress == null) {
            throw new IllegalArgumentException("Parameter startIpAddress is required and cannot be null.");
        }
        if (endIpAddress == null) {
            throw new IllegalArgumentException("Parameter endIpAddress is required and cannot be null.");
        }
        CreateOrUpdateFirewallRuleParameters parameters = new CreateOrUpdateFirewallRuleParameters();
        parameters.withStartIpAddress(startIpAddress);
        parameters.withEndIpAddress(endIpAddress);
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, firewallRuleName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallRule>>>(){

            public Observable<ServiceResponse<FirewallRule>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesImpl.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FirewallRule> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FirewallRule>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public FirewallRule get(String resourceGroupName, String accountName, String firewallRuleName) {
        return (FirewallRule)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<FirewallRule> getAsync(String resourceGroupName, String accountName, String firewallRuleName, ServiceCallback<FirewallRule> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName), serviceCallback);
    }

    @Override
    public Observable<FirewallRule> getAsync(String resourceGroupName, String accountName, String firewallRuleName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName).map((Func1)new Func1<ServiceResponse<FirewallRule>, FirewallRule>(){

            public FirewallRule call(ServiceResponse<FirewallRule> response) {
                return (FirewallRule)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<FirewallRule>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String firewallRuleName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (firewallRuleName == null) {
            throw new IllegalArgumentException("Parameter firewallRuleName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), resourceGroupName, accountName, firewallRuleName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallRule>>>(){

            public Observable<ServiceResponse<FirewallRule>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FirewallRule> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FirewallRule>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public FirewallRule update(String resourceGroupName, String accountName, String firewallRuleName) {
        return (FirewallRule)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<FirewallRule> updateAsync(String resourceGroupName, String accountName, String firewallRuleName, ServiceCallback<FirewallRule> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName), serviceCallback);
    }

    @Override
    public Observable<FirewallRule> updateAsync(String resourceGroupName, String accountName, String firewallRuleName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName).map((Func1)new Func1<ServiceResponse<FirewallRule>, FirewallRule>(){

            public FirewallRule call(ServiceResponse<FirewallRule> response) {
                return (FirewallRule)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<FirewallRule>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String firewallRuleName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (firewallRuleName == null) {
            throw new IllegalArgumentException("Parameter firewallRuleName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object startIpAddress = null;
        Object endIpAddress = null;
        UpdateFirewallRuleParameters parameters = new UpdateFirewallRuleParameters();
        parameters.withStartIpAddress(null);
        parameters.withEndIpAddress(null);
        return this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, firewallRuleName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallRule>>>(){

            public Observable<ServiceResponse<FirewallRule>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public FirewallRule update(String resourceGroupName, String accountName, String firewallRuleName, String startIpAddress, String endIpAddress) {
        return (FirewallRule)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName, startIpAddress, endIpAddress).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<FirewallRule> updateAsync(String resourceGroupName, String accountName, String firewallRuleName, String startIpAddress, String endIpAddress, ServiceCallback<FirewallRule> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName, startIpAddress, endIpAddress), serviceCallback);
    }

    @Override
    public Observable<FirewallRule> updateAsync(String resourceGroupName, String accountName, String firewallRuleName, String startIpAddress, String endIpAddress) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName, startIpAddress, endIpAddress).map((Func1)new Func1<ServiceResponse<FirewallRule>, FirewallRule>(){

            public FirewallRule call(ServiceResponse<FirewallRule> response) {
                return (FirewallRule)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<FirewallRule>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String firewallRuleName, String startIpAddress, String endIpAddress) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (firewallRuleName == null) {
            throw new IllegalArgumentException("Parameter firewallRuleName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UpdateFirewallRuleParameters parameters = null;
        if (startIpAddress != null || endIpAddress != null) {
            parameters = new UpdateFirewallRuleParameters();
            parameters.withStartIpAddress(startIpAddress);
            parameters.withEndIpAddress(endIpAddress);
        }
        return this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, firewallRuleName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallRule>>>(){

            public Observable<ServiceResponse<FirewallRule>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FirewallRule> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FirewallRule>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String firewallRuleName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String firewallRuleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String firewallRuleName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, firewallRuleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String firewallRuleName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (firewallRuleName == null) {
            throw new IllegalArgumentException("Parameter firewallRuleName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, accountName, firewallRuleName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<FirewallRule> listByAccountNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FirewallRule>((Page)response.body()){

            public Page<FirewallRule> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FirewallRulesImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<FirewallRule>> listByAccountNextAsync(String nextPageLink, ServiceFuture<List<FirewallRule>> serviceFuture, ListOperationCallback<FirewallRule> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FirewallRule>>>>(){

            public Observable<ServiceResponse<Page<FirewallRule>>> call(String nextPageLink) {
                return FirewallRulesImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<FirewallRule>> listByAccountNextAsync(String nextPageLink) {
        return this.listByAccountNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FirewallRule>>, Page<FirewallRule>>(){

            public Page<FirewallRule> call(ServiceResponse<Page<FirewallRule>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<FirewallRule>>> listByAccountNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByAccountNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FirewallRule>>, Observable<ServiceResponse<Page<FirewallRule>>>>(){

            public Observable<ServiceResponse<Page<FirewallRule>>> call(ServiceResponse<Page<FirewallRule>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FirewallRulesImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallRule>>> listByAccountNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FirewallRule>>>>(){

            public Observable<ServiceResponse<Page<FirewallRule>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallRulesImpl.this.listByAccountNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FirewallRule>> listByAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FirewallRule>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FirewallRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.FirewallRules listByAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules")
        public Observable<Response<ResponseBody>> listByAccount(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.FirewallRules createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="firewallRuleName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body CreateOrUpdateFirewallRuleParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.FirewallRules get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="firewallRuleName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.FirewallRules update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="firewallRuleName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body UpdateFirewallRuleParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.FirewallRules delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="firewallRuleName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.FirewallRules listByAccountNext"})
        @GET
        public Observable<Response<ResponseBody>> listByAccountNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

