/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.datalake.store.Locations;
import com.microsoft.azure.management.datalake.store.implementation.DataLakeStoreAccountManagementClientImpl;
import com.microsoft.azure.management.datalake.store.models.CapabilityInformation;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class LocationsImpl
implements Locations {
    private LocationsService service;
    private DataLakeStoreAccountManagementClientImpl client;

    public LocationsImpl(Retrofit retrofit, DataLakeStoreAccountManagementClientImpl client) {
        this.service = (LocationsService)retrofit.create(LocationsService.class);
        this.client = client;
    }

    @Override
    public CapabilityInformation getCapability(String location) {
        return (CapabilityInformation)((ServiceResponse)this.getCapabilityWithServiceResponseAsync(location).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CapabilityInformation> getCapabilityAsync(String location, ServiceCallback<CapabilityInformation> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCapabilityWithServiceResponseAsync(location), serviceCallback);
    }

    @Override
    public Observable<CapabilityInformation> getCapabilityAsync(String location) {
        return this.getCapabilityWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<CapabilityInformation>, CapabilityInformation>(){

            public CapabilityInformation call(ServiceResponse<CapabilityInformation> response) {
                return (CapabilityInformation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CapabilityInformation>> getCapabilityWithServiceResponseAsync(String location) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getCapability(this.client.subscriptionId(), location, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CapabilityInformation>>>(){

            public Observable<ServiceResponse<CapabilityInformation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LocationsImpl.this.getCapabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CapabilityInformation> getCapabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CapabilityInformation>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LocationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.Locations getCapability"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.DataLakeStore/locations/{location}/capability")
        public Observable<Response<ResponseBody>> getCapability(@Path(value="subscriptionId") String var1, @Path(value="location") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

