/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.datalake.store.Operations;
import com.microsoft.azure.management.datalake.store.implementation.DataLakeStoreAccountManagementClientImpl;
import com.microsoft.azure.management.datalake.store.models.OperationListResult;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class OperationsImpl
implements Operations {
    private OperationsService service;
    private DataLakeStoreAccountManagementClientImpl client;

    public OperationsImpl(Retrofit retrofit, DataLakeStoreAccountManagementClientImpl client) {
        this.service = (OperationsService)retrofit.create(OperationsService.class);
        this.client = client;
    }

    @Override
    public OperationListResult list() {
        return (OperationListResult)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<OperationListResult> listAsync(ServiceCallback<OperationListResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    @Override
    public Observable<OperationListResult> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<OperationListResult>, OperationListResult>(){

            public OperationListResult call(ServiceResponse<OperationListResult> response) {
                return (OperationListResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<OperationListResult>> listWithServiceResponseAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationListResult>>>(){

            public Observable<ServiceResponse<OperationListResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OperationsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationListResult> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationListResult>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface OperationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.Operations list"})
        @GET(value="providers/Microsoft.DataLakeStore/operations")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

