/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.datalake.store.TrustedIdProviders;
import com.microsoft.azure.management.datalake.store.implementation.DataLakeStoreAccountManagementClientImpl;
import com.microsoft.azure.management.datalake.store.models.CreateOrUpdateTrustedIdProviderParameters;
import com.microsoft.azure.management.datalake.store.models.PageImpl;
import com.microsoft.azure.management.datalake.store.models.TrustedIdProvider;
import com.microsoft.azure.management.datalake.store.models.UpdateTrustedIdProviderParameters;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class TrustedIdProvidersImpl
implements TrustedIdProviders {
    private TrustedIdProvidersService service;
    private DataLakeStoreAccountManagementClientImpl client;

    public TrustedIdProvidersImpl(Retrofit retrofit, DataLakeStoreAccountManagementClientImpl client) {
        this.service = (TrustedIdProvidersService)retrofit.create(TrustedIdProvidersService.class);
        this.client = client;
    }

    @Override
    public PagedList<TrustedIdProvider> listByAccount(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listByAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<TrustedIdProvider>((Page)response.body()){

            public Page<TrustedIdProvider> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TrustedIdProvidersImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<TrustedIdProvider>> listByAccountAsync(String resourceGroupName, String accountName, ListOperationCallback<TrustedIdProvider> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<TrustedIdProvider>>>>(){

            public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(String nextPageLink) {
                return TrustedIdProvidersImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<TrustedIdProvider>> listByAccountAsync(String resourceGroupName, String accountName) {
        return this.listByAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<TrustedIdProvider>>, Page<TrustedIdProvider>>(){

            public Page<TrustedIdProvider> call(ServiceResponse<Page<TrustedIdProvider>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<TrustedIdProvider>>> listByAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listByAccountSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<TrustedIdProvider>>, Observable<ServiceResponse<Page<TrustedIdProvider>>>>(){

            public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(ServiceResponse<Page<TrustedIdProvider>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TrustedIdProvidersImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TrustedIdProvider>>> listByAccountSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TrustedIdProvider>>>>(){

            public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TrustedIdProvidersImpl.this.listByAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TrustedIdProvider>> listByAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TrustedIdProvider>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public TrustedIdProvider createOrUpdate(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        return (TrustedIdProvider)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<TrustedIdProvider> createOrUpdateAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider, ServiceCallback<TrustedIdProvider> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider), serviceCallback);
    }

    @Override
    public Observable<TrustedIdProvider> createOrUpdateAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider).map((Func1)new Func1<ServiceResponse<TrustedIdProvider>, TrustedIdProvider>(){

            public TrustedIdProvider call(ServiceResponse<TrustedIdProvider> response) {
                return (TrustedIdProvider)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<TrustedIdProvider>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (trustedIdProviderName == null) {
            throw new IllegalArgumentException("Parameter trustedIdProviderName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (idProvider == null) {
            throw new IllegalArgumentException("Parameter idProvider is required and cannot be null.");
        }
        CreateOrUpdateTrustedIdProviderParameters parameters = new CreateOrUpdateTrustedIdProviderParameters();
        parameters.withIdProvider(idProvider);
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, trustedIdProviderName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TrustedIdProvider>>>(){

            public Observable<ServiceResponse<TrustedIdProvider>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrustedIdProvidersImpl.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TrustedIdProvider> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TrustedIdProvider>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public TrustedIdProvider get(String resourceGroupName, String accountName, String trustedIdProviderName) {
        return (TrustedIdProvider)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<TrustedIdProvider> getAsync(String resourceGroupName, String accountName, String trustedIdProviderName, ServiceCallback<TrustedIdProvider> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName), serviceCallback);
    }

    @Override
    public Observable<TrustedIdProvider> getAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).map((Func1)new Func1<ServiceResponse<TrustedIdProvider>, TrustedIdProvider>(){

            public TrustedIdProvider call(ServiceResponse<TrustedIdProvider> response) {
                return (TrustedIdProvider)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<TrustedIdProvider>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (trustedIdProviderName == null) {
            throw new IllegalArgumentException("Parameter trustedIdProviderName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), resourceGroupName, accountName, trustedIdProviderName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TrustedIdProvider>>>(){

            public Observable<ServiceResponse<TrustedIdProvider>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrustedIdProvidersImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TrustedIdProvider> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TrustedIdProvider>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public TrustedIdProvider update(String resourceGroupName, String accountName, String trustedIdProviderName) {
        return (TrustedIdProvider)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<TrustedIdProvider> updateAsync(String resourceGroupName, String accountName, String trustedIdProviderName, ServiceCallback<TrustedIdProvider> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName), serviceCallback);
    }

    @Override
    public Observable<TrustedIdProvider> updateAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).map((Func1)new Func1<ServiceResponse<TrustedIdProvider>, TrustedIdProvider>(){

            public TrustedIdProvider call(ServiceResponse<TrustedIdProvider> response) {
                return (TrustedIdProvider)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<TrustedIdProvider>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (trustedIdProviderName == null) {
            throw new IllegalArgumentException("Parameter trustedIdProviderName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object idProvider = null;
        UpdateTrustedIdProviderParameters parameters = new UpdateTrustedIdProviderParameters();
        parameters.withIdProvider(null);
        return this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, trustedIdProviderName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TrustedIdProvider>>>(){

            public Observable<ServiceResponse<TrustedIdProvider>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrustedIdProvidersImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public TrustedIdProvider update(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        return (TrustedIdProvider)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<TrustedIdProvider> updateAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider, ServiceCallback<TrustedIdProvider> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider), serviceCallback);
    }

    @Override
    public Observable<TrustedIdProvider> updateAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName, idProvider).map((Func1)new Func1<ServiceResponse<TrustedIdProvider>, TrustedIdProvider>(){

            public TrustedIdProvider call(ServiceResponse<TrustedIdProvider> response) {
                return (TrustedIdProvider)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<TrustedIdProvider>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String trustedIdProviderName, String idProvider) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (trustedIdProviderName == null) {
            throw new IllegalArgumentException("Parameter trustedIdProviderName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UpdateTrustedIdProviderParameters parameters = null;
        if (idProvider != null) {
            parameters = new UpdateTrustedIdProviderParameters();
            parameters.withIdProvider(idProvider);
        }
        return this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, trustedIdProviderName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TrustedIdProvider>>>(){

            public Observable<ServiceResponse<TrustedIdProvider>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrustedIdProvidersImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TrustedIdProvider> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TrustedIdProvider>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String trustedIdProviderName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String trustedIdProviderName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, trustedIdProviderName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String trustedIdProviderName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (trustedIdProviderName == null) {
            throw new IllegalArgumentException("Parameter trustedIdProviderName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, accountName, trustedIdProviderName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrustedIdProvidersImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<TrustedIdProvider> listByAccountNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<TrustedIdProvider>((Page)response.body()){

            public Page<TrustedIdProvider> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TrustedIdProvidersImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<TrustedIdProvider>> listByAccountNextAsync(String nextPageLink, ServiceFuture<List<TrustedIdProvider>> serviceFuture, ListOperationCallback<TrustedIdProvider> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<TrustedIdProvider>>>>(){

            public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(String nextPageLink) {
                return TrustedIdProvidersImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<TrustedIdProvider>> listByAccountNextAsync(String nextPageLink) {
        return this.listByAccountNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<TrustedIdProvider>>, Page<TrustedIdProvider>>(){

            public Page<TrustedIdProvider> call(ServiceResponse<Page<TrustedIdProvider>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<TrustedIdProvider>>> listByAccountNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByAccountNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<TrustedIdProvider>>, Observable<ServiceResponse<Page<TrustedIdProvider>>>>(){

            public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(ServiceResponse<Page<TrustedIdProvider>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TrustedIdProvidersImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TrustedIdProvider>>> listByAccountNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TrustedIdProvider>>>>(){

            public Observable<ServiceResponse<Page<TrustedIdProvider>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TrustedIdProvidersImpl.this.listByAccountNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TrustedIdProvider>> listByAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TrustedIdProvider>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface TrustedIdProvidersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders listByAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders")
        public Observable<Response<ResponseBody>> listByAccount(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="trustedIdProviderName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body CreateOrUpdateTrustedIdProviderParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="trustedIdProviderName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="trustedIdProviderName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body UpdateTrustedIdProviderParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="trustedIdProviderName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.store.TrustedIdProviders listByAccountNext"})
        @GET
        public Observable<Response<ResponseBody>> listByAccountNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

