/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.dns;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ZoneType.
 */
public enum ZoneType {
    /** Enum value Public. */
    PUBLIC("Public"),

    /** Enum value Private. */
    PRIVATE("Private");

    /** The actual serialized value for a ZoneType instance. */
    private String value;

    ZoneType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ZoneType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ZoneType object, or null if unable to parse.
     */
    @JsonCreator
    public static ZoneType fromString(String value) {
        ZoneType[] items = ZoneType.values();
        for (ZoneType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
