/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.dns.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in RecordSets.
 */
public class RecordSetsInner {
    /** The Retrofit service to perform REST calls. */
    private RecordSetsService service;
    /** The service client containing this operation class. */
    private DnsManagementClientImpl client;

    /**
     * Initializes an instance of RecordSetsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RecordSetsInner(Retrofit retrofit, DnsManagementClientImpl client) {
        this.service = retrofit.create(RecordSetsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for RecordSets to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RecordSetsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path(value = "relativeRecordSetName", encoded = true) String relativeRecordSetName, @Path("recordType") RecordType recordType, @Path("subscriptionId") String subscriptionId, @Body RecordSetInner parameters, @Header("If-Match") String ifMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path(value = "relativeRecordSetName", encoded = true) String relativeRecordSetName, @Path("recordType") RecordType recordType, @Path("subscriptionId") String subscriptionId, @Body RecordSetInner parameters, @Header("If-Match") String ifMatch, @Header("If-None-Match") String ifNoneMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path(value = "relativeRecordSetName", encoded = true) String relativeRecordSetName, @Path("recordType") RecordType recordType, @Path("subscriptionId") String subscriptionId, @Header("If-Match") String ifMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path(value = "relativeRecordSetName", encoded = true) String relativeRecordSetName, @Path("recordType") RecordType recordType, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets listByType" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}")
        Observable<Response<ResponseBody>> listByType(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path("recordType") RecordType recordType, @Path("subscriptionId") String subscriptionId, @Query("$top") Integer top, @Query("$recordsetnamesuffix") String recordsetnamesuffix, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets listByDnsZone" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/recordsets")
        Observable<Response<ResponseBody>> listByDnsZone(@Path("resourceGroupName") String resourceGroupName, @Path("zoneName") String zoneName, @Path("subscriptionId") String subscriptionId, @Query("$top") Integer top, @Query("$recordsetnamesuffix") String recordsetnamesuffix, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets listByTypeNext" })
        @GET
        Observable<Response<ResponseBody>> listByTypeNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets listByDnsZoneNext" })
        @GET
        Observable<Response<ResponseBody>> listByDnsZoneNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RecordSetInner object if successful.
     */
    public RecordSetInner update(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters).toBlocking().single().body();
    }

    /**
     * Updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the Update operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, final ServiceCallback<RecordSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters), serviceCallback);
    }

    /**
     * Updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecordSetInner object
     */
    public Observable<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters).map(new Func1<ServiceResponse<RecordSetInner>, RecordSetInner>() {
            @Override
            public RecordSetInner call(ServiceResponse<RecordSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the Update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecordSetInner object
     */
    public Observable<ServiceResponse<RecordSetInner>> updateWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String ifMatch = null;
        return service.update(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecordSetInner>>>() {
                @Override
                public Observable<ServiceResponse<RecordSetInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RecordSetInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value to prevent accidentally overwritting concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RecordSetInner object if successful.
     */
    public RecordSetInner update(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch) {
        return updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch).toBlocking().single().body();
    }

    /**
     * Updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value to prevent accidentally overwritting concurrent changes.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, final ServiceCallback<RecordSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch), serviceCallback);
    }

    /**
     * Updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value to prevent accidentally overwritting concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecordSetInner object
     */
    public Observable<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch) {
        return updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch).map(new Func1<ServiceResponse<RecordSetInner>, RecordSetInner>() {
            @Override
            public RecordSetInner call(ServiceResponse<RecordSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the Update operation.
     * @param ifMatch The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value to prevent accidentally overwritting concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecordSetInner object
     */
    public Observable<ServiceResponse<RecordSetInner>> updateWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.update(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecordSetInner>>>() {
                @Override
                public Observable<ServiceResponse<RecordSetInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RecordSetInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RecordSetInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RecordSetInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RecordSetInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RecordSetInner object if successful.
     */
    public RecordSetInner createOrUpdate(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, final ServiceCallback<RecordSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters), serviceCallback);
    }

    /**
     * Creates or updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecordSetInner object
     */
    public Observable<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters).map(new Func1<ServiceResponse<RecordSetInner>, RecordSetInner>() {
            @Override
            public RecordSetInner call(ServiceResponse<RecordSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecordSetInner object
     */
    public Observable<ServiceResponse<RecordSetInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String ifMatch = null;
        final String ifNoneMatch = null;
        return service.createOrUpdate(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecordSetInner>>>() {
                @Override
                public Observable<ServiceResponse<RecordSetInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RecordSetInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates or updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record set. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RecordSetInner object if successful.
     */
    public RecordSetInner createOrUpdate(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch).toBlocking().single().body();
    }

    /**
     * Creates or updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record set. Other values will be ignored.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch, final ServiceCallback<RecordSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch), serviceCallback);
    }

    /**
     * Creates or updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record set. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecordSetInner object
     */
    public Observable<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch).map(new Func1<ServiceResponse<RecordSetInner>, RecordSetInner>() {
            @Override
            public RecordSetInner call(ServiceResponse<RecordSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a record set within a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA can be updated but not created (they are created when the DNS zone is created). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param parameters Parameters supplied to the CreateOrUpdate operation.
     * @param ifMatch The etag of the record set. Omit this value to always overwrite the current record set. Specify the last-seen etag value to prevent accidentally overwritting any concurrent changes.
     * @param ifNoneMatch Set to '*' to allow a new record set to be created, but to prevent updating an existing record set. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecordSetInner object
     */
    public Observable<ServiceResponse<RecordSetInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.createOrUpdate(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecordSetInner>>>() {
                @Override
                public Observable<ServiceResponse<RecordSetInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RecordSetInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RecordSetInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RecordSetInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<RecordSetInner>() { }.getType())
                .register(200, new TypeToken<RecordSetInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a record set from a DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are deleted when the DNS zone is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).toBlocking().single().body();
    }

    /**
     * Deletes a record set from a DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are deleted when the DNS zone is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType), serviceCallback);
    }

    /**
     * Deletes a record set from a DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are deleted when the DNS zone is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        return deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a record set from a DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are deleted when the DNS zone is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String ifMatch = null;
        return service.delete(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Deletes a record set from a DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are deleted when the DNS zone is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param ifMatch The etag of the record set. Omit this value to always delete the current record set. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch) {
        deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch).toBlocking().single().body();
    }

    /**
     * Deletes a record set from a DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are deleted when the DNS zone is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param ifMatch The etag of the record set. Omit this value to always delete the current record set. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch), serviceCallback);
    }

    /**
     * Deletes a record set from a DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are deleted when the DNS zone is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param ifMatch The etag of the record set. Omit this value to always delete the current record set. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch) {
        return deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a record set from a DNS zone. This operation cannot be undone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Record sets of type SOA cannot be deleted (they are deleted when the DNS zone is deleted). Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param ifMatch The etag of the record set. Omit this value to always delete the current record set. Specify the last-seen etag value to prevent accidentally deleting any concurrent changes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RecordSetInner object if successful.
     */
    public RecordSetInner get(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        return getWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).toBlocking().single().body();
    }

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RecordSetInner> getAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, final ServiceCallback<RecordSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType), serviceCallback);
    }

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecordSetInner object
     */
    public Observable<RecordSetInner> getAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        return getWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).map(new Func1<ServiceResponse<RecordSetInner>, RecordSetInner>() {
            @Override
            public RecordSetInner call(ServiceResponse<RecordSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a record set.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param relativeRecordSetName The name of the record set, relative to the name of the zone.
     * @param recordType The type of DNS record in this record set. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RecordSetInner object
     */
    public Observable<ServiceResponse<RecordSetInner>> getWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecordSetInner>>>() {
                @Override
                public Observable<ServiceResponse<RecordSetInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RecordSetInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RecordSetInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RecordSetInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RecordSetInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RecordSetInner&gt; object if successful.
     */
    public PagedList<RecordSetInner> listByType(final String resourceGroupName, final String zoneName, final RecordType recordType) {
        ServiceResponse<Page<RecordSetInner>> response = listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType).toBlocking().single();
        return new PagedList<RecordSetInner>(response.body()) {
            @Override
            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return listByTypeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RecordSetInner>> listByTypeAsync(final String resourceGroupName, final String zoneName, final RecordType recordType, final ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType),
            new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                    return listByTypeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<Page<RecordSetInner>> listByTypeAsync(final String resourceGroupName, final String zoneName, final RecordType recordType) {
        return listByTypeWithServiceResponseAsync(resourceGroupName, zoneName, recordType)
            .map(new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>() {
                @Override
                public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeWithServiceResponseAsync(final String resourceGroupName, final String zoneName, final RecordType recordType) {
        return listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType)
            .concatMap(new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByTypeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RecordSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeSinglePageAsync(final String resourceGroupName, final String zoneName, final RecordType recordType) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer top = null;
        final String recordsetnamesuffix = null;
        return service.listByType(resourceGroupName, zoneName, recordType, this.client.subscriptionId(), top, recordsetnamesuffix, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RecordSetInner>> result = listByTypeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RecordSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is specified, Enumeration will return only records that end with .&lt;recordSetNameSuffix&gt;
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RecordSetInner&gt; object if successful.
     */
    public PagedList<RecordSetInner> listByType(final String resourceGroupName, final String zoneName, final RecordType recordType, final Integer top, final String recordsetnamesuffix) {
        ServiceResponse<Page<RecordSetInner>> response = listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix).toBlocking().single();
        return new PagedList<RecordSetInner>(response.body()) {
            @Override
            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return listByTypeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is specified, Enumeration will return only records that end with .&lt;recordSetNameSuffix&gt;
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RecordSetInner>> listByTypeAsync(final String resourceGroupName, final String zoneName, final RecordType recordType, final Integer top, final String recordsetnamesuffix, final ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix),
            new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                    return listByTypeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is specified, Enumeration will return only records that end with .&lt;recordSetNameSuffix&gt;
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<Page<RecordSetInner>> listByTypeAsync(final String resourceGroupName, final String zoneName, final RecordType recordType, final Integer top, final String recordsetnamesuffix) {
        return listByTypeWithServiceResponseAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix)
            .map(new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>() {
                @Override
                public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param recordType The type of record sets to enumerate. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is specified, Enumeration will return only records that end with .&lt;recordSetNameSuffix&gt;
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeWithServiceResponseAsync(final String resourceGroupName, final String zoneName, final RecordType recordType, final Integer top, final String recordsetnamesuffix) {
        return listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix)
            .concatMap(new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByTypeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
    ServiceResponse<PageImpl<RecordSetInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<RecordSetInner>> * @param zoneName The name of the DNS zone (without a terminating dot).
    ServiceResponse<PageImpl<RecordSetInner>> * @param recordType The type of record sets to enumerate. Possible values include: 'A', 'AAAA', 'CNAME', 'MX', 'NS', 'PTR', 'SOA', 'SRV', 'TXT'
    ServiceResponse<PageImpl<RecordSetInner>> * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
    ServiceResponse<PageImpl<RecordSetInner>> * @param recordsetnamesuffix The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is specified, Enumeration will return only records that end with .&lt;recordSetNameSuffix&gt;
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RecordSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeSinglePageAsync(final String resourceGroupName, final String zoneName, final RecordType recordType, final Integer top, final String recordsetnamesuffix) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByType(resourceGroupName, zoneName, recordType, this.client.subscriptionId(), top, recordsetnamesuffix, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RecordSetInner>> result = listByTypeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RecordSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RecordSetInner>> listByTypeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RecordSetInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RecordSetInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RecordSetInner&gt; object if successful.
     */
    public PagedList<RecordSetInner> listByDnsZone(final String resourceGroupName, final String zoneName) {
        ServiceResponse<Page<RecordSetInner>> response = listByDnsZoneSinglePageAsync(resourceGroupName, zoneName).toBlocking().single();
        return new PagedList<RecordSetInner>(response.body()) {
            @Override
            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return listByDnsZoneNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RecordSetInner>> listByDnsZoneAsync(final String resourceGroupName, final String zoneName, final ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByDnsZoneSinglePageAsync(resourceGroupName, zoneName),
            new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                    return listByDnsZoneNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<Page<RecordSetInner>> listByDnsZoneAsync(final String resourceGroupName, final String zoneName) {
        return listByDnsZoneWithServiceResponseAsync(resourceGroupName, zoneName)
            .map(new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>() {
                @Override
                public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneWithServiceResponseAsync(final String resourceGroupName, final String zoneName) {
        return listByDnsZoneSinglePageAsync(resourceGroupName, zoneName)
            .concatMap(new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByDnsZoneNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RecordSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneSinglePageAsync(final String resourceGroupName, final String zoneName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer top = null;
        final String recordsetnamesuffix = null;
        return service.listByDnsZone(resourceGroupName, zoneName, this.client.subscriptionId(), top, recordsetnamesuffix, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RecordSetInner>> result = listByDnsZoneDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RecordSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is specified, Enumeration will return only records that end with .&lt;recordSetNameSuffix&gt;
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RecordSetInner&gt; object if successful.
     */
    public PagedList<RecordSetInner> listByDnsZone(final String resourceGroupName, final String zoneName, final Integer top, final String recordsetnamesuffix) {
        ServiceResponse<Page<RecordSetInner>> response = listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix).toBlocking().single();
        return new PagedList<RecordSetInner>(response.body()) {
            @Override
            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return listByDnsZoneNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is specified, Enumeration will return only records that end with .&lt;recordSetNameSuffix&gt;
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RecordSetInner>> listByDnsZoneAsync(final String resourceGroupName, final String zoneName, final Integer top, final String recordsetnamesuffix, final ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix),
            new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                    return listByDnsZoneNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is specified, Enumeration will return only records that end with .&lt;recordSetNameSuffix&gt;
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<Page<RecordSetInner>> listByDnsZoneAsync(final String resourceGroupName, final String zoneName, final Integer top, final String recordsetnamesuffix) {
        return listByDnsZoneWithServiceResponseAsync(resourceGroupName, zoneName, top, recordsetnamesuffix)
            .map(new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>() {
                @Override
                public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param resourceGroupName The name of the resource group.
     * @param zoneName The name of the DNS zone (without a terminating dot).
     * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
     * @param recordsetnamesuffix The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is specified, Enumeration will return only records that end with .&lt;recordSetNameSuffix&gt;
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneWithServiceResponseAsync(final String resourceGroupName, final String zoneName, final Integer top, final String recordsetnamesuffix) {
        return listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix)
            .concatMap(new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByDnsZoneNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all record sets in a DNS zone.
     *
    ServiceResponse<PageImpl<RecordSetInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<RecordSetInner>> * @param zoneName The name of the DNS zone (without a terminating dot).
    ServiceResponse<PageImpl<RecordSetInner>> * @param top The maximum number of record sets to return. If not specified, returns up to 100 record sets.
    ServiceResponse<PageImpl<RecordSetInner>> * @param recordsetnamesuffix The suffix label of the record set name that has to be used to filter the record set enumerations. If this parameter is specified, Enumeration will return only records that end with .&lt;recordSetNameSuffix&gt;
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RecordSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneSinglePageAsync(final String resourceGroupName, final String zoneName, final Integer top, final String recordsetnamesuffix) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByDnsZone(resourceGroupName, zoneName, this.client.subscriptionId(), top, recordsetnamesuffix, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RecordSetInner>> result = listByDnsZoneDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RecordSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RecordSetInner>> listByDnsZoneDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RecordSetInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RecordSetInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RecordSetInner&gt; object if successful.
     */
    public PagedList<RecordSetInner> listByTypeNext(final String nextPageLink) {
        ServiceResponse<Page<RecordSetInner>> response = listByTypeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecordSetInner>(response.body()) {
            @Override
            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return listByTypeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RecordSetInner>> listByTypeNextAsync(final String nextPageLink, final ServiceFuture<List<RecordSetInner>> serviceFuture, final ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByTypeNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                    return listByTypeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<Page<RecordSetInner>> listByTypeNextAsync(final String nextPageLink) {
        return listByTypeNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>() {
                @Override
                public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeNextWithServiceResponseAsync(final String nextPageLink) {
        return listByTypeNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByTypeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the record sets of a specified type in a DNS zone.
     *
    ServiceResponse<PageImpl<RecordSetInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RecordSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByTypeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RecordSetInner>> result = listByTypeNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RecordSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RecordSetInner>> listByTypeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RecordSetInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RecordSetInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RecordSetInner&gt; object if successful.
     */
    public PagedList<RecordSetInner> listByDnsZoneNext(final String nextPageLink) {
        ServiceResponse<Page<RecordSetInner>> response = listByDnsZoneNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecordSetInner>(response.body()) {
            @Override
            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return listByDnsZoneNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RecordSetInner>> listByDnsZoneNextAsync(final String nextPageLink, final ServiceFuture<List<RecordSetInner>> serviceFuture, final ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByDnsZoneNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                    return listByDnsZoneNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<Page<RecordSetInner>> listByDnsZoneNextAsync(final String nextPageLink) {
        return listByDnsZoneNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>() {
                @Override
                public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all record sets in a DNS zone.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RecordSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneNextWithServiceResponseAsync(final String nextPageLink) {
        return listByDnsZoneNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByDnsZoneNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all record sets in a DNS zone.
     *
    ServiceResponse<PageImpl<RecordSetInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RecordSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByDnsZoneNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RecordSetInner>> result = listByDnsZoneNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RecordSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RecordSetInner>> listByDnsZoneNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RecordSetInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RecordSetInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
