/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.DnsRecordSet;
import com.microsoft.azure.management.dns.DnsZone;
import com.microsoft.azure.management.dns.implementation.ARecordSetImpl;
import com.microsoft.azure.management.dns.implementation.AaaaRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.CNameRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.MXRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.NSRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.PtrRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import com.microsoft.azure.management.dns.implementation.SoaRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.SrvRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.TxtRecordSetImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesNonCachedImpl;

@LangDefinition
class DnsRecordSetsImpl
extends ExternalChildResourcesNonCachedImpl<DnsRecordSetImpl, DnsRecordSet, RecordSetInner, DnsZoneImpl, DnsZone> {
    private final long defaultTtlInSeconds = 3600L;

    DnsRecordSetsImpl(DnsZoneImpl parent) {
        super((Object)parent, "RecordSet");
    }

    DnsRecordSetImpl defineARecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareDefine(ARecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineAaaaRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareDefine(AaaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    void withCNameRecordSet(String name, String alias) {
        CNameRecordSetImpl recordSet = CNameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent());
        ((RecordSetInner)recordSet.inner()).cnameRecord().withCname(alias);
        this.setDefaults((DnsRecordSetImpl)this.prepareDefine(recordSet.withTimeToLive(3600L)));
    }

    DnsRecordSetImpl defineCNameRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareDefine(CNameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineMXRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareDefine(MXRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineNSRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareDefine(NSRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl definePtrRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareDefine(PtrRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineSrvRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareDefine(SrvRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl defineTxtRecordSet(String name) {
        return this.setDefaults((DnsRecordSetImpl)this.prepareDefine(TxtRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent())));
    }

    DnsRecordSetImpl updateARecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareUpdate(ARecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateAaaaRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareUpdate(AaaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateMXRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareUpdate(MXRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateCNameRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareUpdate(CNameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateNSRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareUpdate(NSRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updatePtrRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareUpdate(PtrRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateSrvRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareUpdate(SrvRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateTxtRecordSet(String name) {
        return (DnsRecordSetImpl)this.prepareUpdate(TxtRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()));
    }

    DnsRecordSetImpl updateSoaRecordSet() {
        return (DnsRecordSetImpl)this.prepareUpdate(SoaRecordSetImpl.newRecordSet((DnsZoneImpl)this.parent()));
    }

    void withoutARecordSet(String name, String eTagValue) {
        this.prepareRemove(ARecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutAaaaRecordSet(String name, String eTagValue) {
        this.prepareRemove(AaaaRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutCNameRecordSet(String name, String eTagValue) {
        this.prepareRemove(CNameRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutMXRecordSet(String name, String eTagValue) {
        this.prepareRemove(MXRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutNSRecordSet(String name, String eTagValue) {
        this.prepareRemove(NSRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutPtrRecordSet(String name, String eTagValue) {
        this.prepareRemove(PtrRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutSrvRecordSet(String name, String eTagValue) {
        this.prepareRemove(SrvRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    void withoutTxtRecordSet(String name, String eTagValue) {
        this.prepareRemove(TxtRecordSetImpl.newRecordSet(name, (DnsZoneImpl)this.parent()).withETagOnDelete(eTagValue));
    }

    final void clearPendingOperations() {
        this.childCollection.clear();
    }

    private DnsRecordSetImpl setDefaults(DnsRecordSetImpl recordSet) {
        return recordSet.withTimeToLive(3600L);
    }
}

