/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.DnsZone;
import com.microsoft.azure.management.dns.DnsZones;
import com.microsoft.azure.management.dns.implementation.DnsManagementClientImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneManager;
import com.microsoft.azure.management.dns.implementation.ZoneInner;
import com.microsoft.azure.management.dns.implementation.ZonesInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import rx.Completable;

@LangDefinition
class DnsZonesImpl
extends TopLevelModifiableResourcesImpl<DnsZone, DnsZoneImpl, ZoneInner, ZonesInner, DnsZoneManager>
implements DnsZones {
    DnsZonesImpl(DnsZoneManager dnsZoneManager) {
        super((InnerSupportsListing)((DnsManagementClientImpl)((Object)dnsZoneManager.inner())).zones(), (ManagerBase)dnsZoneManager);
    }

    public DnsZoneImpl define(String name) {
        return this.setDefaults(this.wrapModel(name));
    }

    protected DnsZoneImpl wrapModel(String name) {
        return new DnsZoneImpl(name, new ZoneInner(), (DnsZoneManager)this.manager());
    }

    protected DnsZoneImpl wrapModel(ZoneInner inner) {
        return new DnsZoneImpl(inner.name(), inner, (DnsZoneManager)this.manager());
    }

    private DnsZoneImpl setDefaults(DnsZoneImpl dnsZone) {
        ((ZoneInner)((Object)dnsZone.inner())).withLocation("global");
        return dnsZone;
    }

    @Override
    public Completable deleteByResourceGroupNameAsync(String resourceGroupName, String zoneName, String eTagValue) {
        return ((DnsManagementClientImpl)((Object)((DnsZoneManager)this.manager()).inner())).zones().deleteAsync(resourceGroupName, zoneName, eTagValue).toCompletable();
    }

    @Override
    public Completable deleteByIdAsync(String id, String eTagValue) {
        return this.deleteByResourceGroupNameAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id), eTagValue);
    }

    @Override
    public void deleteByResourceGroupName(String resourceGroupName, String zoneName, String eTagValue) {
        this.deleteByResourceGroupNameAsync(resourceGroupName, zoneName, eTagValue).await();
    }

    @Override
    public void deleteById(String id, String eTagValue) {
        this.deleteByIdAsync(id, eTagValue).await();
    }
}

