/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.ARecord;
import com.microsoft.azure.management.dns.ARecordSet;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@LangDefinition
class ARecordSetImpl
extends DnsRecordSetImpl
implements ARecordSet {
    ARecordSetImpl(DnsZoneImpl parent, RecordSetInner innerModel) {
        super(parent, innerModel);
    }

    static ARecordSetImpl newRecordSet(String name, DnsZoneImpl parent) {
        return new ARecordSetImpl(parent, new RecordSetInner().withName(name).withType(RecordType.A.toString()).withARecords(new ArrayList<ARecord>()));
    }

    @Override
    public List<String> ipv4Addresses() {
        ArrayList<String> ipv4Addresses = new ArrayList<String>();
        if (((RecordSetInner)this.inner()).aRecords() != null) {
            for (ARecord aRecord : ((RecordSetInner)this.inner()).aRecords()) {
                ipv4Addresses.add(aRecord.ipv4Address());
            }
        }
        return Collections.unmodifiableList(ipv4Addresses);
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)this.inner()).aRecords() != null && ((RecordSetInner)this.inner()).aRecords().size() > 0) {
            if (resource.aRecords() == null) {
                resource.withARecords(new ArrayList<ARecord>());
            }
            resource.aRecords().addAll(((RecordSetInner)this.inner()).aRecords());
            ((RecordSetInner)this.inner()).aRecords().clear();
        }
        if (this.recordSetRemoveInfo.aRecords().size() > 0) {
            if (resource.aRecords() != null) {
                block0: for (ARecord recordToRemove : this.recordSetRemoveInfo.aRecords()) {
                    for (ARecord record : resource.aRecords()) {
                        if (!record.ipv4Address().equalsIgnoreCase(recordToRemove.ipv4Address())) continue;
                        resource.aRecords().remove(record);
                        continue block0;
                    }
                }
            }
            this.recordSetRemoveInfo.aRecords().clear();
        }
        return resource;
    }
}

