/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.google.common.base.Splitter;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.ARecord;
import com.microsoft.azure.management.dns.AaaaRecord;
import com.microsoft.azure.management.dns.CnameRecord;
import com.microsoft.azure.management.dns.DnsRecordSet;
import com.microsoft.azure.management.dns.DnsZone;
import com.microsoft.azure.management.dns.MxRecord;
import com.microsoft.azure.management.dns.NsRecord;
import com.microsoft.azure.management.dns.PtrRecord;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.SrvRecord;
import com.microsoft.azure.management.dns.TxtRecord;
import com.microsoft.azure.management.dns.implementation.DnsManagementClientImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneManager;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class DnsRecordSetImpl
extends ExternalChildResourceImpl<DnsRecordSet, RecordSetInner, DnsZoneImpl, DnsZone>
implements DnsRecordSet,
DnsRecordSet.Definition<DnsZone.DefinitionStages.WithCreate>,
DnsRecordSet.UpdateDefinition<DnsZone.Update>,
DnsRecordSet.UpdateCombined {
    protected final RecordSetInner recordSetRemoveInfo;
    private final ETagState eTagState = new ETagState();

    protected DnsRecordSetImpl(DnsZoneImpl parent, RecordSetInner innerModel) {
        super(innerModel.name(), (Object)parent, (Object)innerModel);
        this.recordSetRemoveInfo = new RecordSetInner().withName(innerModel.name()).withType(innerModel.type()).withARecords(new ArrayList<ARecord>()).withAaaaRecords(new ArrayList<AaaaRecord>()).withCnameRecord(new CnameRecord()).withMxRecords(new ArrayList<MxRecord>()).withNsRecords(new ArrayList<NsRecord>()).withPtrRecords(new ArrayList<PtrRecord>()).withSrvRecords(new ArrayList<SrvRecord>()).withTxtRecords(new ArrayList<TxtRecord>()).withMetadata(new LinkedHashMap<String, String>());
    }

    public String id() {
        return ((RecordSetInner)this.inner()).id();
    }

    @Override
    public RecordType recordType() {
        String fullyQualifiedType = ((RecordSetInner)this.inner()).type();
        String[] parts = fullyQualifiedType.split("/");
        return RecordType.fromString(parts[parts.length - 1]);
    }

    @Override
    public long timeToLive() {
        return ((RecordSetInner)this.inner()).tTL();
    }

    @Override
    public Map<String, String> metadata() {
        if (((RecordSetInner)this.inner()).metadata() == null) {
            return Collections.unmodifiableMap(new LinkedHashMap());
        }
        return Collections.unmodifiableMap(((RecordSetInner)this.inner()).metadata());
    }

    @Override
    public String eTag() {
        return ((RecordSetInner)this.inner()).etag();
    }

    @Override
    public DnsRecordSetImpl withIPv4Address(String ipv4Address) {
        ((RecordSetInner)this.inner()).aRecords().add(new ARecord().withIpv4Address(ipv4Address));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutIPv4Address(String ipv4Address) {
        this.recordSetRemoveInfo.aRecords().add(new ARecord().withIpv4Address(ipv4Address));
        return this;
    }

    @Override
    public DnsRecordSetImpl withIPv6Address(String ipv6Address) {
        ((RecordSetInner)this.inner()).aaaaRecords().add(new AaaaRecord().withIpv6Address(ipv6Address));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutIPv6Address(String ipv6Address) {
        this.recordSetRemoveInfo.aaaaRecords().add(new AaaaRecord().withIpv6Address(ipv6Address));
        return this;
    }

    @Override
    public DnsRecordSetImpl withAlias(String alias) {
        ((RecordSetInner)this.inner()).cnameRecord().withCname(alias);
        return this;
    }

    @Override
    public DnsRecordSetImpl withMailExchange(String mailExchangeHostName, int priority) {
        ((RecordSetInner)this.inner()).mxRecords().add(new MxRecord().withExchange(mailExchangeHostName).withPreference(priority));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutMailExchange(String mailExchangeHostName, int priority) {
        this.recordSetRemoveInfo.mxRecords().add(new MxRecord().withExchange(mailExchangeHostName).withPreference(priority));
        return this;
    }

    @Override
    public DnsRecordSetImpl withNameServer(String nameServerHostName) {
        ((RecordSetInner)this.inner()).nsRecords().add(new NsRecord().withNsdname(nameServerHostName));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutNameServer(String nameServerHostName) {
        this.recordSetRemoveInfo.nsRecords().add(new NsRecord().withNsdname(nameServerHostName));
        return this;
    }

    @Override
    public DnsRecordSetImpl withTargetDomainName(String targetDomainName) {
        ((RecordSetInner)this.inner()).ptrRecords().add(new PtrRecord().withPtrdname(targetDomainName));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutTargetDomainName(String targetDomainName) {
        this.recordSetRemoveInfo.ptrRecords().add(new PtrRecord().withPtrdname(targetDomainName));
        return this;
    }

    @Override
    public DnsRecordSetImpl withRecord(String target, int port, int priority, int weight) {
        ((RecordSetInner)this.inner()).srvRecords().add(new SrvRecord().withTarget(target).withPort(port).withPriority(priority).withWeight(weight));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutRecord(String target, int port, int priority, int weight) {
        this.recordSetRemoveInfo.srvRecords().add(new SrvRecord().withTarget(target).withPort(port).withPriority(priority).withWeight(weight));
        return this;
    }

    @Override
    public DnsRecordSetImpl withText(String text) {
        if (text == null) {
            return this;
        }
        ArrayList<String> chunks = new ArrayList<String>();
        for (String chunk : Splitter.fixedLength((int)255).split((CharSequence)text)) {
            chunks.add(chunk);
        }
        ((RecordSetInner)this.inner()).txtRecords().add(new TxtRecord().withValue(chunks));
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutText(String text) {
        if (text == null) {
            return this;
        }
        ArrayList<String> chunks = new ArrayList<String>();
        chunks.add(text);
        return this.withoutText(chunks);
    }

    @Override
    public DnsRecordSetImpl withoutText(List<String> textChunks) {
        this.recordSetRemoveInfo.txtRecords().add(new TxtRecord().withValue(textChunks));
        return this;
    }

    @Override
    public DnsRecordSetImpl withEmailServer(String emailServerHostName) {
        ((RecordSetInner)this.inner()).soaRecord().withEmail(emailServerHostName);
        return this;
    }

    @Override
    public DnsRecordSetImpl withRefreshTimeInSeconds(long refreshTimeInSeconds) {
        ((RecordSetInner)this.inner()).soaRecord().withRefreshTime(refreshTimeInSeconds);
        return this;
    }

    @Override
    public DnsRecordSetImpl withRetryTimeInSeconds(long retryTimeInSeconds) {
        ((RecordSetInner)this.inner()).soaRecord().withRetryTime(retryTimeInSeconds);
        return this;
    }

    @Override
    public DnsRecordSetImpl withExpireTimeInSeconds(long expireTimeInSeconds) {
        ((RecordSetInner)this.inner()).soaRecord().withExpireTime(expireTimeInSeconds);
        return this;
    }

    @Override
    public DnsRecordSetImpl withNegativeResponseCachingTimeToLiveInSeconds(long negativeCachingTimeToLive) {
        ((RecordSetInner)this.inner()).soaRecord().withMinimumTtl(negativeCachingTimeToLive);
        return this;
    }

    @Override
    public DnsRecordSetImpl withSerialNumber(long serialNumber) {
        ((RecordSetInner)this.inner()).soaRecord().withSerialNumber(serialNumber);
        return this;
    }

    @Override
    public DnsRecordSetImpl withTimeToLive(long ttlInSeconds) {
        ((RecordSetInner)this.inner()).withTTL(ttlInSeconds);
        return this;
    }

    @Override
    public DnsRecordSetImpl withMetadata(String key, String value) {
        if (((RecordSetInner)this.inner()).metadata() == null) {
            ((RecordSetInner)this.inner()).withMetadata(new LinkedHashMap<String, String>());
        }
        ((RecordSetInner)this.inner()).metadata().put(key, value);
        return this;
    }

    @Override
    public DnsRecordSetImpl withoutMetadata(String key) {
        this.recordSetRemoveInfo.metadata().put(key, null);
        return this;
    }

    @Override
    public DnsRecordSetImpl withETagCheck() {
        this.eTagState.withImplicitETagCheckOnCreate();
        this.eTagState.withImplicitETagCheckOnUpdate();
        return this;
    }

    @Override
    public DnsRecordSetImpl withETagCheck(String eTagValue) {
        this.eTagState.withExplicitETagCheckOnUpdate(eTagValue);
        return this;
    }

    public Observable<DnsRecordSet> createResourceAsync() {
        return this.createOrUpdateAsync((RecordSetInner)this.inner());
    }

    public Observable<DnsRecordSet> updateResourceAsync() {
        return ((DnsManagementClientImpl)((Object)((DnsZoneManager)((DnsZoneImpl)this.parent()).manager()).inner())).recordSets().getAsync(((DnsZoneImpl)this.parent()).resourceGroupName(), ((DnsZoneImpl)this.parent()).name(), this.name(), this.recordType()).map((Func1)new Func1<RecordSetInner, RecordSetInner>(){

            public RecordSetInner call(RecordSetInner resource) {
                return DnsRecordSetImpl.this.prepare(resource);
            }
        }).flatMap((Func1)new Func1<RecordSetInner, Observable<DnsRecordSet>>(){

            public Observable<DnsRecordSet> call(RecordSetInner resource) {
                return DnsRecordSetImpl.this.createOrUpdateAsync(resource);
            }
        });
    }

    public Observable<Void> deleteResourceAsync() {
        return ((DnsManagementClientImpl)((Object)((DnsZoneManager)((DnsZoneImpl)this.parent()).manager()).inner())).recordSets().deleteAsync(((DnsZoneImpl)this.parent()).resourceGroupName(), ((DnsZoneImpl)this.parent()).name(), this.name(), this.recordType(), this.eTagState.ifMatchValueOnDelete());
    }

    public DnsZoneImpl attach() {
        return (DnsZoneImpl)this.parent();
    }

    public String childResourceKey() {
        return this.name() + "_" + this.recordType().toString();
    }

    protected Observable<RecordSetInner> getInnerAsync() {
        return ((DnsManagementClientImpl)((Object)((DnsZoneManager)((DnsZoneImpl)this.parent()).manager()).inner())).recordSets().getAsync(((DnsZoneImpl)this.parent()).resourceGroupName(), ((DnsZoneImpl)this.parent()).name(), this.name(), this.recordType());
    }

    private Observable<DnsRecordSet> createOrUpdateAsync(RecordSetInner resource) {
        final DnsRecordSetImpl self = this;
        return ((DnsManagementClientImpl)((Object)((DnsZoneManager)((DnsZoneImpl)this.parent()).manager()).inner())).recordSets().createOrUpdateAsync(((DnsZoneImpl)this.parent()).resourceGroupName(), ((DnsZoneImpl)this.parent()).name(), this.name(), this.recordType(), resource, this.eTagState.ifMatchValueOnUpdate(resource.etag()), this.eTagState.ifNonMatchValueOnCreate()).map((Func1)new Func1<RecordSetInner, DnsRecordSet>(){

            public DnsRecordSet call(RecordSetInner inner) {
                DnsRecordSetImpl.this.setInner(inner);
                self.eTagState.clear();
                return self;
            }
        });
    }

    private RecordSetInner prepare(RecordSetInner resource) {
        if (this.recordSetRemoveInfo.metadata().size() > 0) {
            if (resource.metadata() != null) {
                for (String string : this.recordSetRemoveInfo.metadata().keySet()) {
                    resource.metadata().remove(string);
                }
            }
            this.recordSetRemoveInfo.metadata().clear();
        }
        if (((RecordSetInner)this.inner()).metadata() != null && ((RecordSetInner)this.inner()).metadata().size() > 0) {
            if (resource.metadata() == null) {
                resource.withMetadata(new LinkedHashMap<String, String>());
            }
            for (Map.Entry entry : ((RecordSetInner)this.inner()).metadata().entrySet()) {
                resource.metadata().put((String)entry.getKey(), (String)entry.getValue());
            }
            ((RecordSetInner)this.inner()).metadata().clear();
        }
        if (((RecordSetInner)this.inner()).tTL() != null) {
            resource.withTTL(((RecordSetInner)this.inner()).tTL());
            ((RecordSetInner)this.inner()).withTTL(null);
        }
        return this.prepareForUpdate(resource);
    }

    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        return resource;
    }

    DnsRecordSetImpl withETagOnDelete(String eTagValue) {
        this.eTagState.withExplicitETagCheckOnDelete(eTagValue);
        return this;
    }

    @LangDefinition
    private class ETagState {
        private boolean doImplicitETagCheckOnCreate;
        private boolean doImplicitETagCheckOnUpdate;
        private String eTagOnUpdate;
        private String eTagOnDelete;

        private ETagState() {
        }

        public ETagState withImplicitETagCheckOnCreate() {
            this.doImplicitETagCheckOnCreate = true;
            return this;
        }

        public ETagState withImplicitETagCheckOnUpdate() {
            this.doImplicitETagCheckOnUpdate = true;
            return this;
        }

        public ETagState withExplicitETagCheckOnUpdate(String eTagValue) {
            this.eTagOnUpdate = eTagValue;
            return this;
        }

        public ETagState withExplicitETagCheckOnDelete(String eTagValue) {
            this.eTagOnDelete = eTagValue;
            return this;
        }

        public ETagState clear() {
            this.doImplicitETagCheckOnCreate = false;
            this.doImplicitETagCheckOnUpdate = false;
            this.eTagOnUpdate = null;
            this.eTagOnDelete = null;
            return this;
        }

        public String ifMatchValueOnUpdate(String currentETagValue) {
            String eTagValue = null;
            if (this.doImplicitETagCheckOnUpdate) {
                eTagValue = currentETagValue;
            }
            if (this.eTagOnUpdate != null) {
                eTagValue = this.eTagOnUpdate;
            }
            return eTagValue;
        }

        public String ifMatchValueOnDelete() {
            return this.eTagOnDelete;
        }

        public String ifNonMatchValueOnCreate() {
            if (this.doImplicitETagCheckOnCreate) {
                return "*";
            }
            return null;
        }
    }
}

