/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.NSRecordSet;
import com.microsoft.azure.management.dns.NsRecord;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@LangDefinition
class NSRecordSetImpl
extends DnsRecordSetImpl
implements NSRecordSet {
    NSRecordSetImpl(DnsZoneImpl parent, RecordSetInner innerModel) {
        super(parent, innerModel);
    }

    static NSRecordSetImpl newRecordSet(String name, DnsZoneImpl parent) {
        return new NSRecordSetImpl(parent, new RecordSetInner().withName(name).withType(RecordType.NS.toString()).withNsRecords(new ArrayList<NsRecord>()));
    }

    @Override
    public List<String> nameServers() {
        ArrayList<String> nameServers = new ArrayList<String>();
        if (((RecordSetInner)this.inner()).nsRecords() != null) {
            for (NsRecord nsRecord : ((RecordSetInner)this.inner()).nsRecords()) {
                nameServers.add(nsRecord.nsdname());
            }
        }
        return Collections.unmodifiableList(nameServers);
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)this.inner()).nsRecords() != null && ((RecordSetInner)this.inner()).nsRecords().size() > 0) {
            if (resource.nsRecords() == null) {
                resource.withNsRecords(new ArrayList<NsRecord>());
            }
            for (NsRecord record : ((RecordSetInner)this.inner()).nsRecords()) {
                resource.nsRecords().add(record);
            }
            ((RecordSetInner)this.inner()).nsRecords().clear();
        }
        if (this.recordSetRemoveInfo.nsRecords().size() > 0) {
            if (resource.nsRecords() != null) {
                block1: for (NsRecord recordToRemove : this.recordSetRemoveInfo.nsRecords()) {
                    for (NsRecord record : resource.nsRecords()) {
                        if (!record.nsdname().equalsIgnoreCase(recordToRemove.nsdname())) continue;
                        resource.nsRecords().remove(record);
                        continue block1;
                    }
                }
            }
            this.recordSetRemoveInfo.nsRecords().clear();
        }
        return resource;
    }
}

