/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.PtrRecord;
import com.microsoft.azure.management.dns.PtrRecordSet;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@LangDefinition
class PtrRecordSetImpl
extends DnsRecordSetImpl
implements PtrRecordSet {
    PtrRecordSetImpl(DnsZoneImpl parent, RecordSetInner innerModel) {
        super(parent, innerModel);
    }

    static PtrRecordSetImpl newRecordSet(String name, DnsZoneImpl parent) {
        return new PtrRecordSetImpl(parent, new RecordSetInner().withName(name).withType(RecordType.PTR.toString()).withPtrRecords(new ArrayList<PtrRecord>()));
    }

    @Override
    public List<String> targetDomainNames() {
        ArrayList<String> targetDomainNames = new ArrayList<String>();
        if (((RecordSetInner)this.inner()).ptrRecords() != null) {
            for (PtrRecord ptrRecord : ((RecordSetInner)this.inner()).ptrRecords()) {
                targetDomainNames.add(ptrRecord.ptrdname());
            }
        }
        return Collections.unmodifiableList(targetDomainNames);
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)this.inner()).ptrRecords() != null && ((RecordSetInner)this.inner()).ptrRecords().size() > 0) {
            if (resource.ptrRecords() == null) {
                resource.withPtrRecords(new ArrayList<PtrRecord>());
            }
            resource.ptrRecords().addAll(((RecordSetInner)this.inner()).ptrRecords());
            ((RecordSetInner)this.inner()).ptrRecords().clear();
        }
        if (this.recordSetRemoveInfo.ptrRecords().size() > 0) {
            if (resource.ptrRecords() != null) {
                block0: for (PtrRecord recordToRemove : this.recordSetRemoveInfo.ptrRecords()) {
                    for (PtrRecord record : resource.ptrRecords()) {
                        if (!record.ptrdname().equalsIgnoreCase(recordToRemove.ptrdname())) continue;
                        resource.ptrRecords().remove(record);
                        continue block0;
                    }
                }
            }
            this.recordSetRemoveInfo.ptrRecords().clear();
        }
        return resource;
    }
}

