/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.eventhub.implementation.ConsumerGroupsInner;
import com.microsoft.azure.management.eventhub.implementation.DisasterRecoveryConfigsInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubsInner;
import com.microsoft.azure.management.eventhub.implementation.NamespacesInner;
import com.microsoft.azure.management.eventhub.implementation.OperationsInner;
import com.microsoft.azure.management.eventhub.implementation.RegionsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class EventHubManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private OperationsInner operations;
    private NamespacesInner namespaces;
    private DisasterRecoveryConfigsInner disasterRecoveryConfigs;
    private EventHubsInner eventHubs;
    private ConsumerGroupsInner consumerGroups;
    private RegionsInner regions;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public EventHubManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public EventHubManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public EventHubManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public EventHubManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public NamespacesInner namespaces() {
        return this.namespaces;
    }

    public DisasterRecoveryConfigsInner disasterRecoveryConfigs() {
        return this.disasterRecoveryConfigs;
    }

    public EventHubsInner eventHubs() {
        return this.eventHubs;
    }

    public ConsumerGroupsInner consumerGroups() {
        return this.consumerGroups;
    }

    public RegionsInner regions() {
        return this.regions;
    }

    public EventHubManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public EventHubManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public EventHubManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2017-04-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.namespaces = new NamespacesInner(this.restClient().retrofit(), this);
        this.disasterRecoveryConfigs = new DisasterRecoveryConfigsInner(this.restClient().retrofit(), this);
        this.eventHubs = new EventHubsInner(this.restClient().retrofit(), this);
        this.consumerGroups = new ConsumerGroupsInner(this.restClient().retrofit(), this);
        this.regions = new RegionsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "EventHubManagementClient", "2017-04-01");
    }
}

