/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.eventhub.implementation;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * Messaging Plan for the namespace.
 */
@JsonFlatten
@SkipParentValidation
public class MessagingPlanInner extends Resource {
    /**
     * Sku type.
     */
    @JsonProperty(value = "properties.sku", access = JsonProperty.Access.WRITE_ONLY)
    private Integer sku;

    /**
     * Selected event hub unit.
     */
    @JsonProperty(value = "properties.selectedEventHubUnit", access = JsonProperty.Access.WRITE_ONLY)
    private Integer selectedEventHubUnit;

    /**
     * The exact time the messaging plan was updated.
     */
    @JsonProperty(value = "properties.updatedAt", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime updatedAt;

    /**
     * revision number.
     */
    @JsonProperty(value = "properties.revision", access = JsonProperty.Access.WRITE_ONLY)
    private Long revision;

    /**
     * Get sku type.
     *
     * @return the sku value
     */
    public Integer sku() {
        return this.sku;
    }

    /**
     * Get selected event hub unit.
     *
     * @return the selectedEventHubUnit value
     */
    public Integer selectedEventHubUnit() {
        return this.selectedEventHubUnit;
    }

    /**
     * Get the exact time the messaging plan was updated.
     *
     * @return the updatedAt value
     */
    public DateTime updatedAt() {
        return this.updatedAt;
    }

    /**
     * Get revision number.
     *
     * @return the revision value
     */
    public Long revision() {
        return this.revision;
    }

}
