/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.eventhub.AccessRights;
import com.microsoft.azure.management.eventhub.CheckNameAvailabilityParameter;
import com.microsoft.azure.management.eventhub.ErrorResponseException;
import com.microsoft.azure.management.eventhub.RegenerateAccessKeyParameters;
import com.microsoft.azure.management.eventhub.implementation.AccessKeysInner;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRuleInner;
import com.microsoft.azure.management.eventhub.implementation.CheckNameAvailabilityResultInner;
import com.microsoft.azure.management.eventhub.implementation.EHNamespaceInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.MessagingPlanInner;
import com.microsoft.azure.management.eventhub.implementation.NetworkRuleSetInner;
import com.microsoft.azure.management.eventhub.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class NamespacesInner
implements InnerSupportsGet<EHNamespaceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<EHNamespaceInner> {
    private NamespacesService service;
    private EventHubManagementClientImpl client;

    public NamespacesInner(Retrofit retrofit, EventHubManagementClientImpl client) {
        this.service = (NamespacesService)retrofit.create(NamespacesService.class);
        this.client = client;
    }

    public CheckNameAvailabilityResultInner checkNameAvailability(String name) {
        return (CheckNameAvailabilityResultInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name, ServiceCallback<CheckNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityResultInner>, CheckNameAvailabilityResultInner>(){

            public CheckNameAvailabilityResultInner call(ServiceResponse<CheckNameAvailabilityResultInner> response) {
                return (CheckNameAvailabilityResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        CheckNameAvailabilityParameter parameters = new CheckNameAvailabilityParameter();
        parameters.withName(name);
        return this.service.checkNameAvailability(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityResultInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckNameAvailabilityResultInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CheckNameAvailabilityResultInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<EHNamespaceInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<EHNamespaceInner>((Page)response.body()){

            public Page<EHNamespaceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NamespacesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EHNamespaceInner>> listAsync(ListOperationCallback<EHNamespaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(String nextPageLink) {
                return NamespacesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EHNamespaceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<EHNamespaceInner>>, Page<EHNamespaceInner>>(){

            public Page<EHNamespaceInner> call(ServiceResponse<Page<EHNamespaceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EHNamespaceInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<EHNamespaceInner>>, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(ServiceResponse<Page<EHNamespaceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NamespacesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EHNamespaceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NamespacesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EHNamespaceInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EHNamespaceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<EHNamespaceInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<EHNamespaceInner>((Page)response.body()){

            public Page<EHNamespaceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NamespacesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EHNamespaceInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<EHNamespaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(String nextPageLink) {
                return NamespacesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EHNamespaceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<EHNamespaceInner>>, Page<EHNamespaceInner>>(){

            public Page<EHNamespaceInner> call(ServiceResponse<Page<EHNamespaceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EHNamespaceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<EHNamespaceInner>>, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(ServiceResponse<Page<EHNamespaceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NamespacesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EHNamespaceInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NamespacesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EHNamespaceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EHNamespaceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EHNamespaceInner createOrUpdate(String resourceGroupName, String namespaceName, EHNamespaceInner parameters) {
        return (EHNamespaceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<EHNamespaceInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, EHNamespaceInner parameters, ServiceCallback<EHNamespaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters), serviceCallback);
    }

    public Observable<EHNamespaceInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, EHNamespaceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).map((Func1)new Func1<ServiceResponse<EHNamespaceInner>, EHNamespaceInner>(){

            public EHNamespaceInner call(ServiceResponse<EHNamespaceInner> response) {
                return (EHNamespaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EHNamespaceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, EHNamespaceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, namespaceName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<EHNamespaceInner>(){}.getType());
    }

    public EHNamespaceInner beginCreateOrUpdate(String resourceGroupName, String namespaceName, EHNamespaceInner parameters) {
        return (EHNamespaceInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<EHNamespaceInner> beginCreateOrUpdateAsync(String resourceGroupName, String namespaceName, EHNamespaceInner parameters, ServiceCallback<EHNamespaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters), serviceCallback);
    }

    public Observable<EHNamespaceInner> beginCreateOrUpdateAsync(String resourceGroupName, String namespaceName, EHNamespaceInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).map((Func1)new Func1<ServiceResponse<EHNamespaceInner>, EHNamespaceInner>(){

            public EHNamespaceInner call(ServiceResponse<EHNamespaceInner> response) {
                return (EHNamespaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EHNamespaceInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, EHNamespaceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.beginCreateOrUpdate(resourceGroupName, namespaceName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EHNamespaceInner>>>(){

            public Observable<ServiceResponse<EHNamespaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EHNamespaceInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EHNamespaceInner>(){}.getType()).register(201, new TypeToken<EHNamespaceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String namespaceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String namespaceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String namespaceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String namespaceName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, namespaceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String namespaceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, namespaceName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String namespaceName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, namespaceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EHNamespaceInner getByResourceGroup(String resourceGroupName, String namespaceName) {
        return (EHNamespaceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, namespaceName).toBlocking().single()).body());
    }

    public ServiceFuture<EHNamespaceInner> getByResourceGroupAsync(String resourceGroupName, String namespaceName, ServiceCallback<EHNamespaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, namespaceName), serviceCallback);
    }

    public Observable<EHNamespaceInner> getByResourceGroupAsync(String resourceGroupName, String namespaceName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, namespaceName).map((Func1)new Func1<ServiceResponse<EHNamespaceInner>, EHNamespaceInner>(){

            public EHNamespaceInner call(ServiceResponse<EHNamespaceInner> response) {
                return (EHNamespaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EHNamespaceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EHNamespaceInner>>>(){

            public Observable<ServiceResponse<EHNamespaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EHNamespaceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EHNamespaceInner>(){}.getType()).register(201, new TypeToken<EHNamespaceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EHNamespaceInner update(String resourceGroupName, String namespaceName, EHNamespaceInner parameters) {
        return (EHNamespaceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<EHNamespaceInner> updateAsync(String resourceGroupName, String namespaceName, EHNamespaceInner parameters, ServiceCallback<EHNamespaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters), serviceCallback);
    }

    public Observable<EHNamespaceInner> updateAsync(String resourceGroupName, String namespaceName, EHNamespaceInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).map((Func1)new Func1<ServiceResponse<EHNamespaceInner>, EHNamespaceInner>(){

            public EHNamespaceInner call(ServiceResponse<EHNamespaceInner> response) {
                return (EHNamespaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EHNamespaceInner>> updateWithServiceResponseAsync(String resourceGroupName, String namespaceName, EHNamespaceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.update(resourceGroupName, namespaceName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EHNamespaceInner>>>(){

            public Observable<ServiceResponse<EHNamespaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EHNamespaceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EHNamespaceInner>(){}.getType()).register(201, new TypeToken<EHNamespaceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public MessagingPlanInner getMessagingPlan(String resourceGroupName, String namespaceName) {
        return (MessagingPlanInner)((Object)((ServiceResponse)this.getMessagingPlanWithServiceResponseAsync(resourceGroupName, namespaceName).toBlocking().single()).body());
    }

    public ServiceFuture<MessagingPlanInner> getMessagingPlanAsync(String resourceGroupName, String namespaceName, ServiceCallback<MessagingPlanInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMessagingPlanWithServiceResponseAsync(resourceGroupName, namespaceName), serviceCallback);
    }

    public Observable<MessagingPlanInner> getMessagingPlanAsync(String resourceGroupName, String namespaceName) {
        return this.getMessagingPlanWithServiceResponseAsync(resourceGroupName, namespaceName).map((Func1)new Func1<ServiceResponse<MessagingPlanInner>, MessagingPlanInner>(){

            public MessagingPlanInner call(ServiceResponse<MessagingPlanInner> response) {
                return (MessagingPlanInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<MessagingPlanInner>> getMessagingPlanWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getMessagingPlan(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MessagingPlanInner>>>(){

            public Observable<ServiceResponse<MessagingPlanInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.getMessagingPlanDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MessagingPlanInner> getMessagingPlanDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MessagingPlanInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<AuthorizationRuleInner> listAuthorizationRules(String resourceGroupName, String namespaceName) {
        ServiceResponse response = (ServiceResponse)this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName).toBlocking().single();
        return new PagedList<AuthorizationRuleInner>((Page)response.body()){

            public Page<AuthorizationRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NamespacesInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AuthorizationRuleInner>> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, ListOperationCallback<AuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(String nextPageLink) {
                return NamespacesInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AuthorizationRuleInner>> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName) {
        return this.listAuthorizationRulesWithServiceResponseAsync(resourceGroupName, namespaceName).map((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Page<AuthorizationRuleInner>>(){

            public Page<AuthorizationRuleInner> call(ServiceResponse<Page<AuthorizationRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        return this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName).concatMap((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(ServiceResponse<Page<AuthorizationRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NamespacesInner.this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesSinglePageAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAuthorizationRules(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NamespacesInner.this.listAuthorizationRulesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AuthorizationRuleInner>> listAuthorizationRulesDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AuthorizationRuleInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AuthorizationRuleInner createOrUpdateAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName, List<AccessRights> rights) {
        return (AuthorizationRuleInner)((Object)((ServiceResponse)this.createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, rights).toBlocking().single()).body());
    }

    public ServiceFuture<AuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, List<AccessRights> rights, ServiceCallback<AuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, rights), serviceCallback);
    }

    public Observable<AuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, List<AccessRights> rights) {
        return this.createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, rights).map((Func1)new Func1<ServiceResponse<AuthorizationRuleInner>, AuthorizationRuleInner>(){

            public AuthorizationRuleInner call(ServiceResponse<AuthorizationRuleInner> response) {
                return (AuthorizationRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AuthorizationRuleInner>> createOrUpdateAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, List<AccessRights> rights) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (rights == null) {
            throw new IllegalArgumentException("Parameter rights is required and cannot be null.");
        }
        Validator.validate(rights);
        AuthorizationRuleInner parameters = new AuthorizationRuleInner();
        parameters.withRights(rights);
        return this.service.createOrUpdateAuthorizationRule(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AuthorizationRuleInner>>>(){

            public Observable<ServiceResponse<AuthorizationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.createOrUpdateAuthorizationRuleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AuthorizationRuleInner> createOrUpdateAuthorizationRuleDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AuthorizationRuleInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void deleteAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        ((ServiceResponse)this.deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName), serviceCallback);
    }

    public Observable<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return this.deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteAuthorizationRule(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.deleteAuthorizationRuleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteAuthorizationRuleDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AuthorizationRuleInner getAuthorizationRule(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return (AuthorizationRuleInner)((Object)((ServiceResponse)this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).toBlocking().single()).body());
    }

    public ServiceFuture<AuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, ServiceCallback<AuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName), serviceCallback);
    }

    public Observable<AuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).map((Func1)new Func1<ServiceResponse<AuthorizationRuleInner>, AuthorizationRuleInner>(){

            public AuthorizationRuleInner call(ServiceResponse<AuthorizationRuleInner> response) {
                return (AuthorizationRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AuthorizationRuleInner>> getAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAuthorizationRule(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AuthorizationRuleInner>>>(){

            public Observable<ServiceResponse<AuthorizationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.getAuthorizationRuleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AuthorizationRuleInner> getAuthorizationRuleDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AuthorizationRuleInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AccessKeysInner listKeys(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return (AccessKeysInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<AccessKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, ServiceCallback<AccessKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName), serviceCallback);
    }

    public Observable<AccessKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName).map((Func1)new Func1<ServiceResponse<AccessKeysInner>, AccessKeysInner>(){

            public AccessKeysInner call(ServiceResponse<AccessKeysInner> response) {
                return (AccessKeysInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AccessKeysInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeys(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AccessKeysInner>>>(){

            public Observable<ServiceResponse<AccessKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AccessKeysInner> listKeysDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AccessKeysInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AccessKeysInner regenerateKeys(String resourceGroupName, String namespaceName, String authorizationRuleName, RegenerateAccessKeyParameters parameters) {
        return (AccessKeysInner)((ServiceResponse)this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<AccessKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, RegenerateAccessKeyParameters parameters, ServiceCallback<AccessKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, parameters), serviceCallback);
    }

    public Observable<AccessKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, RegenerateAccessKeyParameters parameters) {
        return this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, authorizationRuleName, parameters).map((Func1)new Func1<ServiceResponse<AccessKeysInner>, AccessKeysInner>(){

            public AccessKeysInner call(ServiceResponse<AccessKeysInner> response) {
                return (AccessKeysInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AccessKeysInner>> regenerateKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String authorizationRuleName, RegenerateAccessKeyParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.regenerateKeys(resourceGroupName, namespaceName, authorizationRuleName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AccessKeysInner>>>(){

            public Observable<ServiceResponse<AccessKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.regenerateKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AccessKeysInner> regenerateKeysDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AccessKeysInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public NetworkRuleSetInner createOrUpdateNetworkRuleSet(String resourceGroupName, String namespaceName, NetworkRuleSetInner parameters) {
        return (NetworkRuleSetInner)((Object)((ServiceResponse)this.createOrUpdateNetworkRuleSetWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkRuleSetInner> createOrUpdateNetworkRuleSetAsync(String resourceGroupName, String namespaceName, NetworkRuleSetInner parameters, ServiceCallback<NetworkRuleSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateNetworkRuleSetWithServiceResponseAsync(resourceGroupName, namespaceName, parameters), serviceCallback);
    }

    public Observable<NetworkRuleSetInner> createOrUpdateNetworkRuleSetAsync(String resourceGroupName, String namespaceName, NetworkRuleSetInner parameters) {
        return this.createOrUpdateNetworkRuleSetWithServiceResponseAsync(resourceGroupName, namespaceName, parameters).map((Func1)new Func1<ServiceResponse<NetworkRuleSetInner>, NetworkRuleSetInner>(){

            public NetworkRuleSetInner call(ServiceResponse<NetworkRuleSetInner> response) {
                return (NetworkRuleSetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkRuleSetInner>> createOrUpdateNetworkRuleSetWithServiceResponseAsync(String resourceGroupName, String namespaceName, NetworkRuleSetInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.createOrUpdateNetworkRuleSet(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkRuleSetInner>>>(){

            public Observable<ServiceResponse<NetworkRuleSetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.createOrUpdateNetworkRuleSetDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NetworkRuleSetInner> createOrUpdateNetworkRuleSetDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NetworkRuleSetInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public NetworkRuleSetInner getNetworkRuleSet(String resourceGroupName, String namespaceName) {
        return (NetworkRuleSetInner)((Object)((ServiceResponse)this.getNetworkRuleSetWithServiceResponseAsync(resourceGroupName, namespaceName).toBlocking().single()).body());
    }

    public ServiceFuture<NetworkRuleSetInner> getNetworkRuleSetAsync(String resourceGroupName, String namespaceName, ServiceCallback<NetworkRuleSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getNetworkRuleSetWithServiceResponseAsync(resourceGroupName, namespaceName), serviceCallback);
    }

    public Observable<NetworkRuleSetInner> getNetworkRuleSetAsync(String resourceGroupName, String namespaceName) {
        return this.getNetworkRuleSetWithServiceResponseAsync(resourceGroupName, namespaceName).map((Func1)new Func1<ServiceResponse<NetworkRuleSetInner>, NetworkRuleSetInner>(){

            public NetworkRuleSetInner call(ServiceResponse<NetworkRuleSetInner> response) {
                return (NetworkRuleSetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NetworkRuleSetInner>> getNetworkRuleSetWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getNetworkRuleSet(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NetworkRuleSetInner>>>(){

            public Observable<ServiceResponse<NetworkRuleSetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NamespacesInner.this.getNetworkRuleSetDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NetworkRuleSetInner> getNetworkRuleSetDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NetworkRuleSetInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<EHNamespaceInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EHNamespaceInner>((Page)response.body()){

            public Page<EHNamespaceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NamespacesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EHNamespaceInner>> listNextAsync(String nextPageLink, ServiceFuture<List<EHNamespaceInner>> serviceFuture, ListOperationCallback<EHNamespaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(String nextPageLink) {
                return NamespacesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EHNamespaceInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<EHNamespaceInner>>, Page<EHNamespaceInner>>(){

            public Page<EHNamespaceInner> call(ServiceResponse<Page<EHNamespaceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EHNamespaceInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<EHNamespaceInner>>, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(ServiceResponse<Page<EHNamespaceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NamespacesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EHNamespaceInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NamespacesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EHNamespaceInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EHNamespaceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<EHNamespaceInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EHNamespaceInner>((Page)response.body()){

            public Page<EHNamespaceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NamespacesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EHNamespaceInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<EHNamespaceInner>> serviceFuture, ListOperationCallback<EHNamespaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(String nextPageLink) {
                return NamespacesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EHNamespaceInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<EHNamespaceInner>>, Page<EHNamespaceInner>>(){

            public Page<EHNamespaceInner> call(ServiceResponse<Page<EHNamespaceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EHNamespaceInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<EHNamespaceInner>>, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(ServiceResponse<Page<EHNamespaceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NamespacesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EHNamespaceInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EHNamespaceInner>>>>(){

            public Observable<ServiceResponse<Page<EHNamespaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NamespacesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EHNamespaceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EHNamespaceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<AuthorizationRuleInner> listAuthorizationRulesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AuthorizationRuleInner>((Page)response.body()){

            public Page<AuthorizationRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NamespacesInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AuthorizationRuleInner>> listAuthorizationRulesNextAsync(String nextPageLink, ServiceFuture<List<AuthorizationRuleInner>> serviceFuture, ListOperationCallback<AuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAuthorizationRulesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(String nextPageLink) {
                return NamespacesInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AuthorizationRuleInner>> listAuthorizationRulesNextAsync(String nextPageLink) {
        return this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Page<AuthorizationRuleInner>>(){

            public Page<AuthorizationRuleInner> call(ServiceResponse<Page<AuthorizationRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(ServiceResponse<Page<AuthorizationRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NamespacesInner.this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAuthorizationRulesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NamespacesInner.this.listAuthorizationRulesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AuthorizationRuleInner>> listAuthorizationRulesNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AuthorizationRuleInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface NamespacesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.EventHub/CheckNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CheckNameAvailabilityParameter var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.EventHub/namespaces")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Body EHNamespaceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Body EHNamespaceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Body EHNamespaceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces getMessagingPlan"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/messagingplan")
        public Observable<Response<ResponseBody>> getMessagingPlan(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces listAuthorizationRules"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules")
        public Observable<Response<ResponseBody>> listAuthorizationRules(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces createOrUpdateAuthorizationRule"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}")
        public Observable<Response<ResponseBody>> createOrUpdateAuthorizationRule(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="authorizationRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body AuthorizationRuleInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces deleteAuthorizationRule"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAuthorizationRule(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="authorizationRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces getAuthorizationRule"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}")
        public Observable<Response<ResponseBody>> getAuthorizationRule(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="authorizationRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/listKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="authorizationRuleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces regenerateKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/regenerateKeys")
        public Observable<Response<ResponseBody>> regenerateKeys(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="authorizationRuleName") String var3, @Path(value="subscriptionId") String var4, @Body RegenerateAccessKeyParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces createOrUpdateNetworkRuleSet"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/networkRuleSets/default")
        public Observable<Response<ResponseBody>> createOrUpdateNetworkRuleSet(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Body NetworkRuleSetInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces getNetworkRuleSet"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/networkRuleSets/default")
        public Observable<Response<ResponseBody>> getNetworkRuleSet(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Namespaces listAuthorizationRulesNext"})
        @GET
        public Observable<Response<ResponseBody>> listAuthorizationRulesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

