/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.eventhub.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.eventhub.ErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ConsumerGroups.
 */
public class ConsumerGroupsInner {
    /** The Retrofit service to perform REST calls. */
    private ConsumerGroupsService service;
    /** The service client containing this operation class. */
    private EventHubManagementClientImpl client;

    /**
     * Initializes an instance of ConsumerGroupsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ConsumerGroupsInner(Retrofit retrofit, EventHubManagementClientImpl client) {
        this.service = retrofit.create(ConsumerGroupsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ConsumerGroups to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ConsumerGroupsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.ConsumerGroups createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("eventHubName") String eventHubName, @Path("consumerGroupName") String consumerGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ConsumerGroupInner parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.ConsumerGroups delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("eventHubName") String eventHubName, @Path("consumerGroupName") String consumerGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.ConsumerGroups get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("eventHubName") String eventHubName, @Path("consumerGroupName") String consumerGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.ConsumerGroups listByEventHub" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups")
        Observable<Response<ResponseBody>> listByEventHub(@Path("resourceGroupName") String resourceGroupName, @Path("namespaceName") String namespaceName, @Path("eventHubName") String eventHubName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Query("$skip") Integer skip, @Query("$top") Integer top, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.ConsumerGroups listByEventHubNext" })
        @GET
        Observable<Response<ResponseBody>> listByEventHubNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates or updates an Event Hubs consumer group as a nested resource within a Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ConsumerGroupInner object if successful.
     */
    public ConsumerGroupInner createOrUpdate(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).toBlocking().single().body();
    }

    /**
     * Creates or updates an Event Hubs consumer group as a nested resource within a Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ConsumerGroupInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, final ServiceCallback<ConsumerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName), serviceCallback);
    }

    /**
     * Creates or updates an Event Hubs consumer group as a nested resource within a Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ConsumerGroupInner object
     */
    public Observable<ConsumerGroupInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).map(new Func1<ServiceResponse<ConsumerGroupInner>, ConsumerGroupInner>() {
            @Override
            public ConsumerGroupInner call(ServiceResponse<ConsumerGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an Event Hubs consumer group as a nested resource within a Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ConsumerGroupInner object
     */
    public Observable<ServiceResponse<ConsumerGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (consumerGroupName == null) {
            throw new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String userMetadata = null;
        ConsumerGroupInner parameters = new ConsumerGroupInner();
        parameters.withUserMetadata(null);
        return service.createOrUpdate(resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConsumerGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<ConsumerGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ConsumerGroupInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates or updates an Event Hubs consumer group as a nested resource within a Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @param userMetadata User Metadata is a placeholder to store user-defined string data with maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information also user-defined configuration settings can be stored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ConsumerGroupInner object if successful.
     */
    public ConsumerGroupInner createOrUpdate(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, userMetadata).toBlocking().single().body();
    }

    /**
     * Creates or updates an Event Hubs consumer group as a nested resource within a Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @param userMetadata User Metadata is a placeholder to store user-defined string data with maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information also user-defined configuration settings can be stored.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ConsumerGroupInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata, final ServiceCallback<ConsumerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, userMetadata), serviceCallback);
    }

    /**
     * Creates or updates an Event Hubs consumer group as a nested resource within a Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @param userMetadata User Metadata is a placeholder to store user-defined string data with maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information also user-defined configuration settings can be stored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ConsumerGroupInner object
     */
    public Observable<ConsumerGroupInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, userMetadata).map(new Func1<ServiceResponse<ConsumerGroupInner>, ConsumerGroupInner>() {
            @Override
            public ConsumerGroupInner call(ServiceResponse<ConsumerGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an Event Hubs consumer group as a nested resource within a Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @param userMetadata User Metadata is a placeholder to store user-defined string data with maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information also user-defined configuration settings can be stored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ConsumerGroupInner object
     */
    public Observable<ServiceResponse<ConsumerGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (consumerGroupName == null) {
            throw new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        ConsumerGroupInner parameters = new ConsumerGroupInner();
        parameters.withUserMetadata(userMetadata);
        return service.createOrUpdate(resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConsumerGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<ConsumerGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ConsumerGroupInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ConsumerGroupInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ConsumerGroupInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ConsumerGroupInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes a consumer group from the specified Event Hub and resource group.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        deleteWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).toBlocking().single().body();
    }

    /**
     * Deletes a consumer group from the specified Event Hub and resource group.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName), serviceCallback);
    }

    /**
     * Deletes a consumer group from the specified Event Hub and resource group.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return deleteWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a consumer group from the specified Event Hub and resource group.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (consumerGroupName == null) {
            throw new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets a description for the specified consumer group.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ConsumerGroupInner object if successful.
     */
    public ConsumerGroupInner get(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return getWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).toBlocking().single().body();
    }

    /**
     * Gets a description for the specified consumer group.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ConsumerGroupInner> getAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, final ServiceCallback<ConsumerGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName), serviceCallback);
    }

    /**
     * Gets a description for the specified consumer group.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ConsumerGroupInner object
     */
    public Observable<ConsumerGroupInner> getAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return getWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).map(new Func1<ServiceResponse<ConsumerGroupInner>, ConsumerGroupInner>() {
            @Override
            public ConsumerGroupInner call(ServiceResponse<ConsumerGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a description for the specified consumer group.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param consumerGroupName The consumer group name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ConsumerGroupInner object
     */
    public Observable<ServiceResponse<ConsumerGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (consumerGroupName == null) {
            throw new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConsumerGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<ConsumerGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ConsumerGroupInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ConsumerGroupInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ConsumerGroupInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ConsumerGroupInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ConsumerGroupInner&gt; object if successful.
     */
    public PagedList<ConsumerGroupInner> listByEventHub(final String resourceGroupName, final String namespaceName, final String eventHubName) {
        ServiceResponse<Page<ConsumerGroupInner>> response = listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName).toBlocking().single();
        return new PagedList<ConsumerGroupInner>(response.body()) {
            @Override
            public Page<ConsumerGroupInner> nextPage(String nextPageLink) {
                return listByEventHubNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ConsumerGroupInner>> listByEventHubAsync(final String resourceGroupName, final String namespaceName, final String eventHubName, final ListOperationCallback<ConsumerGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName),
            new Func1<String, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(String nextPageLink) {
                    return listByEventHubNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ConsumerGroupInner&gt; object
     */
    public Observable<Page<ConsumerGroupInner>> listByEventHubAsync(final String resourceGroupName, final String namespaceName, final String eventHubName) {
        return listByEventHubWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName)
            .map(new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Page<ConsumerGroupInner>>() {
                @Override
                public Page<ConsumerGroupInner> call(ServiceResponse<Page<ConsumerGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ConsumerGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubWithServiceResponseAsync(final String resourceGroupName, final String namespaceName, final String eventHubName) {
        return listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName)
            .concatMap(new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(ServiceResponse<Page<ConsumerGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByEventHubNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ConsumerGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubSinglePageAsync(final String resourceGroupName, final String namespaceName, final String eventHubName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer skip = null;
        final Integer top = null;
        return service.listByEventHub(resourceGroupName, namespaceName, eventHubName, this.client.subscriptionId(), this.client.apiVersion(), skip, top, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ConsumerGroupInner>> result = listByEventHubDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ConsumerGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param skip Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skip parameter that specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N usageDetails.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ConsumerGroupInner&gt; object if successful.
     */
    public PagedList<ConsumerGroupInner> listByEventHub(final String resourceGroupName, final String namespaceName, final String eventHubName, final Integer skip, final Integer top) {
        ServiceResponse<Page<ConsumerGroupInner>> response = listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName, skip, top).toBlocking().single();
        return new PagedList<ConsumerGroupInner>(response.body()) {
            @Override
            public Page<ConsumerGroupInner> nextPage(String nextPageLink) {
                return listByEventHubNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param skip Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skip parameter that specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N usageDetails.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ConsumerGroupInner>> listByEventHubAsync(final String resourceGroupName, final String namespaceName, final String eventHubName, final Integer skip, final Integer top, final ListOperationCallback<ConsumerGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName, skip, top),
            new Func1<String, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(String nextPageLink) {
                    return listByEventHubNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param skip Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skip parameter that specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N usageDetails.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ConsumerGroupInner&gt; object
     */
    public Observable<Page<ConsumerGroupInner>> listByEventHubAsync(final String resourceGroupName, final String namespaceName, final String eventHubName, final Integer skip, final Integer top) {
        return listByEventHubWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, skip, top)
            .map(new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Page<ConsumerGroupInner>>() {
                @Override
                public Page<ConsumerGroupInner> call(ServiceResponse<Page<ConsumerGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param namespaceName The Namespace name
     * @param eventHubName The Event Hub name
     * @param skip Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skip parameter that specifies a starting point to use for subsequent calls.
     * @param top May be used to limit the number of results to the most recent N usageDetails.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ConsumerGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubWithServiceResponseAsync(final String resourceGroupName, final String namespaceName, final String eventHubName, final Integer skip, final Integer top) {
        return listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName, skip, top)
            .concatMap(new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(ServiceResponse<Page<ConsumerGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByEventHubNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
    ServiceResponse<PageImpl<ConsumerGroupInner>> * @param resourceGroupName Name of the resource group within the azure subscription.
    ServiceResponse<PageImpl<ConsumerGroupInner>> * @param namespaceName The Namespace name
    ServiceResponse<PageImpl<ConsumerGroupInner>> * @param eventHubName The Event Hub name
    ServiceResponse<PageImpl<ConsumerGroupInner>> * @param skip Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skip parameter that specifies a starting point to use for subsequent calls.
    ServiceResponse<PageImpl<ConsumerGroupInner>> * @param top May be used to limit the number of results to the most recent N usageDetails.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ConsumerGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubSinglePageAsync(final String resourceGroupName, final String namespaceName, final String eventHubName, final Integer skip, final Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByEventHub(resourceGroupName, namespaceName, eventHubName, this.client.subscriptionId(), this.client.apiVersion(), skip, top, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ConsumerGroupInner>> result = listByEventHubDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ConsumerGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ConsumerGroupInner>> listByEventHubDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ConsumerGroupInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ConsumerGroupInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ConsumerGroupInner&gt; object if successful.
     */
    public PagedList<ConsumerGroupInner> listByEventHubNext(final String nextPageLink) {
        ServiceResponse<Page<ConsumerGroupInner>> response = listByEventHubNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ConsumerGroupInner>(response.body()) {
            @Override
            public Page<ConsumerGroupInner> nextPage(String nextPageLink) {
                return listByEventHubNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ConsumerGroupInner>> listByEventHubNextAsync(final String nextPageLink, final ServiceFuture<List<ConsumerGroupInner>> serviceFuture, final ListOperationCallback<ConsumerGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByEventHubNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(String nextPageLink) {
                    return listByEventHubNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ConsumerGroupInner&gt; object
     */
    public Observable<Page<ConsumerGroupInner>> listByEventHubNextAsync(final String nextPageLink) {
        return listByEventHubNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Page<ConsumerGroupInner>>() {
                @Override
                public Page<ConsumerGroupInner> call(ServiceResponse<Page<ConsumerGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ConsumerGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubNextWithServiceResponseAsync(final String nextPageLink) {
        return listByEventHubNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ConsumerGroupInner>>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(ServiceResponse<Page<ConsumerGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByEventHubNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all the consumer groups in a Namespace. An empty feed is returned if no consumer group exists in the Namespace.
     *
    ServiceResponse<PageImpl<ConsumerGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ConsumerGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ConsumerGroupInner>>> listByEventHubNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByEventHubNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ConsumerGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ConsumerGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ConsumerGroupInner>> result = listByEventHubNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ConsumerGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ConsumerGroupInner>> listByEventHubNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ConsumerGroupInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ConsumerGroupInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
