/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 */

package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.DisasterRecoveryPairingAuthorizationKey;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.WrapperImpl;

/**
 * Implementation for {@link DisasterRecoveryPairingAuthorizationKey}.
 */
@LangDefinition
class DisasterRecoveryPairingAuthorizationKeyImpl
        extends WrapperImpl<AccessKeysInner>
        implements DisasterRecoveryPairingAuthorizationKey {

    DisasterRecoveryPairingAuthorizationKeyImpl(AccessKeysInner inner) {
        super(inner);
    }

    @Override
    public String primaryKey() {
        return this.inner().primaryKey();
    }

    @Override
    public String secondaryKey() {
        return this.inner().secondaryKey();
    }

    @Override
    public String primaryConnectionString() {
        return this.inner().primaryConnectionString();
    }

    @Override
    public String secondaryConnectionString() {
        return this.inner().secondaryConnectionString();
    }

    @Override
    public String aliasPrimaryConnectionString() {
        return this.inner().aliasPrimaryConnectionString();
    }

    @Override
    public String aliasSecondaryConnectionString() {
        return this.inner().aliasSecondaryConnectionString();
    }
}
