/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.eventhub.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.eventhub.ErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Regions.
 */
public class RegionsInner {
    /** The Retrofit service to perform REST calls. */
    private RegionsService service;
    /** The service client containing this operation class. */
    private EventHubManagementClientImpl client;

    /**
     * Initializes an instance of RegionsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RegionsInner(Retrofit retrofit, EventHubManagementClientImpl client) {
        this.service = retrofit.create(RegionsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Regions to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RegionsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Regions listBySku" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.EventHub/sku/{sku}/regions")
        Observable<Response<ResponseBody>> listBySku(@Path("subscriptionId") String subscriptionId, @Path("sku") String sku, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.Regions listBySkuNext" })
        @GET
        Observable<Response<ResponseBody>> listBySkuNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets the available Regions for a given sku.
     *
     * @param sku The sku type.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;MessagingRegionsInner&gt; object if successful.
     */
    public PagedList<MessagingRegionsInner> listBySku(final String sku) {
        ServiceResponse<Page<MessagingRegionsInner>> response = listBySkuSinglePageAsync(sku).toBlocking().single();
        return new PagedList<MessagingRegionsInner>(response.body()) {
            @Override
            public Page<MessagingRegionsInner> nextPage(String nextPageLink) {
                return listBySkuNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the available Regions for a given sku.
     *
     * @param sku The sku type.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<MessagingRegionsInner>> listBySkuAsync(final String sku, final ListOperationCallback<MessagingRegionsInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySkuSinglePageAsync(sku),
            new Func1<String, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(String nextPageLink) {
                    return listBySkuNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the available Regions for a given sku.
     *
     * @param sku The sku type.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;MessagingRegionsInner&gt; object
     */
    public Observable<Page<MessagingRegionsInner>> listBySkuAsync(final String sku) {
        return listBySkuWithServiceResponseAsync(sku)
            .map(new Func1<ServiceResponse<Page<MessagingRegionsInner>>, Page<MessagingRegionsInner>>() {
                @Override
                public Page<MessagingRegionsInner> call(ServiceResponse<Page<MessagingRegionsInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the available Regions for a given sku.
     *
     * @param sku The sku type.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;MessagingRegionsInner&gt; object
     */
    public Observable<ServiceResponse<Page<MessagingRegionsInner>>> listBySkuWithServiceResponseAsync(final String sku) {
        return listBySkuSinglePageAsync(sku)
            .concatMap(new Func1<ServiceResponse<Page<MessagingRegionsInner>>, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(ServiceResponse<Page<MessagingRegionsInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySkuNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the available Regions for a given sku.
     *
    ServiceResponse<PageImpl<MessagingRegionsInner>> * @param sku The sku type.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;MessagingRegionsInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<MessagingRegionsInner>>> listBySkuSinglePageAsync(final String sku) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (sku == null) {
            throw new IllegalArgumentException("Parameter sku is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listBySku(this.client.subscriptionId(), sku, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<MessagingRegionsInner>> result = listBySkuDelegate(response);
                        return Observable.just(new ServiceResponse<Page<MessagingRegionsInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<MessagingRegionsInner>> listBySkuDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<MessagingRegionsInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<MessagingRegionsInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the available Regions for a given sku.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;MessagingRegionsInner&gt; object if successful.
     */
    public PagedList<MessagingRegionsInner> listBySkuNext(final String nextPageLink) {
        ServiceResponse<Page<MessagingRegionsInner>> response = listBySkuNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<MessagingRegionsInner>(response.body()) {
            @Override
            public Page<MessagingRegionsInner> nextPage(String nextPageLink) {
                return listBySkuNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the available Regions for a given sku.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<MessagingRegionsInner>> listBySkuNextAsync(final String nextPageLink, final ServiceFuture<List<MessagingRegionsInner>> serviceFuture, final ListOperationCallback<MessagingRegionsInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySkuNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(String nextPageLink) {
                    return listBySkuNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the available Regions for a given sku.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;MessagingRegionsInner&gt; object
     */
    public Observable<Page<MessagingRegionsInner>> listBySkuNextAsync(final String nextPageLink) {
        return listBySkuNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<MessagingRegionsInner>>, Page<MessagingRegionsInner>>() {
                @Override
                public Page<MessagingRegionsInner> call(ServiceResponse<Page<MessagingRegionsInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the available Regions for a given sku.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;MessagingRegionsInner&gt; object
     */
    public Observable<ServiceResponse<Page<MessagingRegionsInner>>> listBySkuNextWithServiceResponseAsync(final String nextPageLink) {
        return listBySkuNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<MessagingRegionsInner>>, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(ServiceResponse<Page<MessagingRegionsInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySkuNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the available Regions for a given sku.
     *
    ServiceResponse<PageImpl<MessagingRegionsInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;MessagingRegionsInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<MessagingRegionsInner>>> listBySkuNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listBySkuNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<MessagingRegionsInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<MessagingRegionsInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<MessagingRegionsInner>> result = listBySkuNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<MessagingRegionsInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<MessagingRegionsInner>> listBySkuNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<MessagingRegionsInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<MessagingRegionsInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
