/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.eventhub.DisasterRecoveryPairingAuthorizationRules;
import com.microsoft.azure.management.eventhub.EventHubAuthorizationRules;
import com.microsoft.azure.management.eventhub.EventHubConsumerGroups;
import com.microsoft.azure.management.eventhub.EventHubDisasterRecoveryPairings;
import com.microsoft.azure.management.eventhub.EventHubNamespaceAuthorizationRules;
import com.microsoft.azure.management.eventhub.EventHubNamespaces;
import com.microsoft.azure.management.eventhub.EventHubs;
import com.microsoft.azure.management.eventhub.implementation.DisasterRecoveryPairingAuthorizationRulesImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubAuthorizationRulesImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubConsumerGroupsImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubDisasterRecoveryPairingsImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubNamespaceAuthorizationRulesImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubNamespacesImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubsImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

@Beta(value=Beta.SinceVersion.V1_2_0)
public final class EventHubManager
extends Manager<EventHubManager, EventHubManagementClientImpl> {
    private EventHubNamespaces namespaces;
    private EventHubs eventHubs;
    private EventHubConsumerGroups consumerGroups;
    private EventHubAuthorizationRules eventHubAuthorizationRules;
    private EventHubNamespaceAuthorizationRules namespaceAuthorizationRules;
    private EventHubDisasterRecoveryPairings eventHubDisasterRecoveryPairings;
    private DisasterRecoveryPairingAuthorizationRules disasterRecoveryPairingAuthorizationRules;
    private StorageManager storageManager;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static EventHubManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new EventHubManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), subscriptionId);
    }

    public static EventHubManager authenticate(RestClient restClient, String subscriptionId) {
        return new EventHubManager(restClient, subscriptionId);
    }

    private EventHubManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new EventHubManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
        this.storageManager = StorageManager.authenticate((RestClient)restClient, (String)subscriptionId);
    }

    @Beta(value=Beta.SinceVersion.V2_0_0)
    public EventHubNamespaces namespaces() {
        if (this.namespaces == null) {
            this.namespaces = new EventHubNamespacesImpl(this);
        }
        return this.namespaces;
    }

    @Beta(value=Beta.SinceVersion.V2_0_0)
    public EventHubs eventHubs() {
        if (this.eventHubs == null) {
            this.eventHubs = new EventHubsImpl(this, this.storageManager);
        }
        return this.eventHubs;
    }

    @Beta(value=Beta.SinceVersion.V2_0_0)
    public EventHubConsumerGroups consumerGroups() {
        if (this.consumerGroups == null) {
            this.consumerGroups = new EventHubConsumerGroupsImpl(this);
        }
        return this.consumerGroups;
    }

    @Beta(value=Beta.SinceVersion.V2_0_0)
    public EventHubDisasterRecoveryPairings eventHubDisasterRecoveryPairings() {
        if (this.eventHubDisasterRecoveryPairings == null) {
            this.eventHubDisasterRecoveryPairings = new EventHubDisasterRecoveryPairingsImpl(this);
        }
        return this.eventHubDisasterRecoveryPairings;
    }

    @Beta(value=Beta.SinceVersion.V2_0_0)
    public EventHubAuthorizationRules eventHubAuthorizationRules() {
        if (this.eventHubAuthorizationRules == null) {
            this.eventHubAuthorizationRules = new EventHubAuthorizationRulesImpl(this);
        }
        return this.eventHubAuthorizationRules;
    }

    @Beta(value=Beta.SinceVersion.V2_0_0)
    public EventHubNamespaceAuthorizationRules namespaceAuthorizationRules() {
        if (this.namespaceAuthorizationRules == null) {
            this.namespaceAuthorizationRules = new EventHubNamespaceAuthorizationRulesImpl(this);
        }
        return this.namespaceAuthorizationRules;
    }

    @Beta(value=Beta.SinceVersion.V2_0_0)
    public DisasterRecoveryPairingAuthorizationRules disasterRecoveryPairingAuthorizationRules() {
        if (this.disasterRecoveryPairingAuthorizationRules == null) {
            this.disasterRecoveryPairingAuthorizationRules = new DisasterRecoveryPairingAuthorizationRulesImpl(this);
        }
        return this.disasterRecoveryPairingAuthorizationRules;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public EventHubManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return EventHubManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public EventHubManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

