/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.management.graphrbac.PasswordProfile;

/**
 * Request parameters for updating an existing work or school account user.
 */
public class UserUpdateParametersInner {
    /**
     * Enable the account. If it is enabled then true else false.
     */
    private Boolean accountEnabled;

    /**
     * User display name.
     */
    private String displayName;

    /**
     * Password Profile.
     */
    private PasswordProfile passwordProfile;

    /**
     * The mail alias for the user.
     */
    private String mailNickname;

    /**
     * Get the accountEnabled value.
     *
     * @return the accountEnabled value
     */
    public Boolean accountEnabled() {
        return this.accountEnabled;
    }

    /**
     * Set the accountEnabled value.
     *
     * @param accountEnabled the accountEnabled value to set
     * @return the UserUpdateParametersInner object itself.
     */
    public UserUpdateParametersInner withAccountEnabled(Boolean accountEnabled) {
        this.accountEnabled = accountEnabled;
        return this;
    }

    /**
     * Get the displayName value.
     *
     * @return the displayName value
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName value.
     *
     * @param displayName the displayName value to set
     * @return the UserUpdateParametersInner object itself.
     */
    public UserUpdateParametersInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the passwordProfile value.
     *
     * @return the passwordProfile value
     */
    public PasswordProfile passwordProfile() {
        return this.passwordProfile;
    }

    /**
     * Set the passwordProfile value.
     *
     * @param passwordProfile the passwordProfile value to set
     * @return the UserUpdateParametersInner object itself.
     */
    public UserUpdateParametersInner withPasswordProfile(PasswordProfile passwordProfile) {
        this.passwordProfile = passwordProfile;
        return this;
    }

    /**
     * Get the mailNickname value.
     *
     * @return the mailNickname value
     */
    public String mailNickname() {
        return this.mailNickname;
    }

    /**
     * Set the mailNickname value.
     *
     * @param mailNickname the mailNickname value to set
     * @return the UserUpdateParametersInner object itself.
     */
    public UserUpdateParametersInner withMailNickname(String mailNickname) {
        this.mailNickname = mailNickname;
        return this;
    }

}
