/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.ServicePrincipals;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalImpl;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Fluent.Graph.RBAC")
class ServicePrincipalsImpl
extends CreatableWrappersImpl<ServicePrincipal, ServicePrincipalImpl, ServicePrincipalInner>
implements ServicePrincipals {
    private ServicePrincipalsInner innerCollection;
    private GraphRbacManager manager;

    ServicePrincipalsImpl(ServicePrincipalsInner client, GraphRbacManager graphRbacManager) {
        this.innerCollection = client;
        this.manager = graphRbacManager;
    }

    public PagedList<ServicePrincipal> list() {
        return this.wrapList(this.innerCollection.list());
    }

    public ServicePrincipalImpl define(String appId) {
        return this.wrapModel(appId);
    }

    protected ServicePrincipalImpl wrapModel(String appId) {
        return new ServicePrincipalImpl(appId, this.innerCollection);
    }

    protected ServicePrincipalImpl wrapModel(ServicePrincipalInner servicePrincipalInner) {
        return new ServicePrincipalImpl(servicePrincipalInner, this.innerCollection);
    }

    @Override
    public ServicePrincipalImpl getByObjectId(String objectId) {
        return new ServicePrincipalImpl(this.innerCollection.get(objectId), this.innerCollection);
    }

    @Override
    public ServicePrincipal getByAppId(String appId) {
        return null;
    }

    @Override
    public ServicePrincipal getByServicePrincipalName(String spn) {
        PagedList<ServicePrincipalInner> spList = this.innerCollection.list(String.format("servicePrincipalNames/any(c:c eq '%s')", spn));
        if (spList == null || spList.isEmpty()) {
            return null;
        }
        return new ServicePrincipalImpl((ServicePrincipalInner)spList.get(0), this.innerCollection);
    }

    @Override
    public ServiceCall<ServicePrincipal> getByServicePrincipalNameAsync(String spn, ServiceCallback<ServicePrincipal> callback) {
        return ServiceCall.create((Observable)this.getByServicePrincipalNameAsync(spn).map((Func1)new Func1<ServicePrincipal, ServiceResponse<ServicePrincipal>>(){

            public ServiceResponse<ServicePrincipal> call(ServicePrincipal fluentModelT) {
                return new ServiceResponse((Object)fluentModelT, null);
            }
        }), callback);
    }

    @Override
    public Observable<ServicePrincipal> getByServicePrincipalNameAsync(final String spn) {
        return this.innerCollection.listAsync(String.format("servicePrincipalNames/any(c:c eq '%s')", spn)).map((Func1)new Func1<Page<ServicePrincipalInner>, ServicePrincipal>(){

            public ServicePrincipal call(Page<ServicePrincipalInner> result) {
                if (result == null || result.getItems() == null || result.getItems().isEmpty()) {
                    throw new GraphErrorException("Service principal not found for SPN: " + spn);
                }
                return new ServicePrincipalImpl((ServicePrincipalInner)result.getItems().get(0), ServicePrincipalsImpl.this.innerCollection);
            }
        });
    }
}

