/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.RestClient;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationsInner;
import com.microsoft.azure.management.graphrbac.implementation.GroupsInner;
import com.microsoft.azure.management.graphrbac.implementation.ObjectsInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalsInner;
import com.microsoft.azure.management.graphrbac.implementation.UsersInner;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public final class GraphRbacManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String apiVersion;
    private String tenantID;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private ObjectsInner objects;
    private ApplicationsInner applications;
    private GroupsInner groups;
    private ServicePrincipalsInner servicePrincipals;
    private UsersInner users;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String tenantID() {
        return this.tenantID;
    }

    public GraphRbacManagementClientImpl withTenantID(String tenantID) {
        this.tenantID = tenantID;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public GraphRbacManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public GraphRbacManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public GraphRbacManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public ObjectsInner objects() {
        return this.objects;
    }

    public ApplicationsInner applications() {
        return this.applications;
    }

    public GroupsInner groups() {
        return this.groups;
    }

    public ServicePrincipalsInner servicePrincipals() {
        return this.servicePrincipals;
    }

    public UsersInner users() {
        return this.users;
    }

    public GraphRbacManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://graph.windows.net", credentials);
    }

    public GraphRbacManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        this(new RestClient.Builder().withBaseUrl(baseUrl).withCredentials(credentials).build());
    }

    public GraphRbacManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "1.6";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.objects = new ObjectsInner(this.restClient().retrofit(), this);
        this.applications = new ApplicationsInner(this.restClient().retrofit(), this);
        this.groups = new GroupsInner(this.restClient().retrofit(), this);
        this.servicePrincipals = new ServicePrincipalsInner(this.restClient().retrofit(), this);
        this.users = new UsersInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("Azure-SDK-For-Java/%s (%s)", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion(), "GraphRbacManagementClient, 1.6");
    }
}

