/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.RequestIdHeaderInterceptor;
import com.microsoft.azure.RestClient;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.graphrbac.ServicePrincipals;
import com.microsoft.azure.management.graphrbac.Users;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalsImpl;
import com.microsoft.azure.management.graphrbac.implementation.UsersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import okhttp3.Interceptor;

public final class GraphRbacManager {
    private String tenantId;
    private final GraphRbacManagementClientImpl graphRbacManagementClient;
    private Users users;
    private ServicePrincipals servicePrincipals;

    public static GraphRbacManager authenticate(AzureTokenCredentials credentials) {
        return new GraphRbacManager(new RestClient.Builder().withBaseUrl(credentials.getEnvironment().getGraphEndpoint()).withInterceptor((Interceptor)new RequestIdHeaderInterceptor()).withCredentials((ServiceClientCredentials)credentials).build(), credentials.getDomain());
    }

    public static GraphRbacManager authenticate(RestClient restClient, String tenantId) {
        return new GraphRbacManager(restClient, tenantId);
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    private GraphRbacManager(RestClient restClient, String tenantId) {
        this.graphRbacManagementClient = new GraphRbacManagementClientImpl(restClient).withTenantID(tenantId);
        this.tenantId = tenantId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public Users users() {
        if (this.users == null) {
            this.users = new UsersImpl(this.graphRbacManagementClient.users(), this);
        }
        return this.users;
    }

    public ServicePrincipals servicePrincipals() {
        if (this.servicePrincipals == null) {
            this.servicePrincipals = new ServicePrincipalsImpl(this.graphRbacManagementClient.servicePrincipals(), this);
        }
        return this.servicePrincipals;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public GraphRbacManager authenticate(AzureTokenCredentials credentials) {
            return GraphRbacManager.authenticate(this.buildRestClient(credentials, AzureEnvironment.Endpoint.GRAPH), credentials.getDomain());
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public GraphRbacManager authenticate(AzureTokenCredentials var1);
    }
}

