/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.KeyCredentialsUpdateParameters;
import com.microsoft.azure.management.graphrbac.PasswordCredentialsUpdateParameters;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Applications.
 */
public final class ApplicationsInner {
    /** The Retrofit service to perform REST calls. */
    private ApplicationsService service;
    /** The service client containing this operation class. */
    private GraphRbacManagementClientImpl client;

    /**
     * Initializes an instance of ApplicationsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ApplicationsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = retrofit.create(ApplicationsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Applications to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ApplicationsService {
        @Headers("Content-Type: application/json; charset=utf-8")
        @POST("{tenantID}/applications")
        Observable<Response<ResponseBody>> create(@Path("tenantID") String tenantID, @Body ApplicationCreateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{tenantID}/applications")
        Observable<Response<ResponseBody>> list(@Path("tenantID") String tenantID, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @HTTP(path = "{tenantID}/applications/{applicationObjectId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{tenantID}/applications/{applicationObjectId}")
        Observable<Response<ResponseBody>> get(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @PATCH("{tenantID}/applications/{applicationObjectId}")
        Observable<Response<ResponseBody>> patch(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Body ApplicationUpdateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{tenantID}/applications/{applicationObjectId}/keyCredentials")
        Observable<Response<ResponseBody>> listKeyCredentials(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @PATCH("{tenantID}/applications/{applicationObjectId}/keyCredentials")
        Observable<Response<ResponseBody>> updateKeyCredentials(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body KeyCredentialsUpdateParameters parameters, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{tenantID}/applications/{applicationObjectId}/passwordCredentials")
        Observable<Response<ResponseBody>> listPasswordCredentials(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @PATCH("{tenantID}/applications/{applicationObjectId}/passwordCredentials")
        Observable<Response<ResponseBody>> updatePasswordCredentials(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body PasswordCredentialsUpdateParameters parameters, @Header("User-Agent") String userAgent);

    }

    /**
     * Create a new application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param parameters Parameters to create an application.
     * @return the ApplicationInner object if successful.
     */
    public ApplicationInner create(ApplicationCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).toBlocking().single().getBody();
    }

    /**
     * Create a new application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param parameters Parameters to create an application.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<ApplicationInner> createAsync(ApplicationCreateParametersInner parameters, final ServiceCallback<ApplicationInner> serviceCallback) {
        return ServiceCall.create(createWithServiceResponseAsync(parameters), serviceCallback);
    }

    /**
     * Create a new application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param parameters Parameters to create an application.
     * @return the observable to the ApplicationInner object
     */
    public Observable<ApplicationInner> createAsync(ApplicationCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).map(new Func1<ServiceResponse<ApplicationInner>, ApplicationInner>() {
            @Override
            public ApplicationInner call(ServiceResponse<ApplicationInner> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Create a new application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param parameters Parameters to create an application.
     * @return the observable to the ApplicationInner object
     */
    public Observable<ServiceResponse<ApplicationInner>> createWithServiceResponseAsync(ApplicationCreateParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.create(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<ApplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ApplicationInner> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ApplicationInner> createDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<ApplicationInner, GraphErrorException>(this.client.mapperAdapter())
                .register(201, new TypeToken<ApplicationInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Lists applications by filter parameters. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @return the List&lt;ApplicationInner&gt; object if successful.
     */
    public List<ApplicationInner> list() {
        return listWithServiceResponseAsync().toBlocking().single().getBody();
    }

    /**
     * Lists applications by filter parameters. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ApplicationInner>> listAsync(final ServiceCallback<List<ApplicationInner>> serviceCallback) {
        return ServiceCall.create(listWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Lists applications by filter parameters. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @return the observable to the List&lt;ApplicationInner&gt; object
     */
    public Observable<List<ApplicationInner>> listAsync() {
        return listWithServiceResponseAsync().map(new Func1<ServiceResponse<List<ApplicationInner>>, List<ApplicationInner>>() {
            @Override
            public List<ApplicationInner> call(ServiceResponse<List<ApplicationInner>> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Lists applications by filter parameters. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @return the observable to the List&lt;ApplicationInner&gt; object
     */
    public Observable<ServiceResponse<List<ApplicationInner>>> listWithServiceResponseAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<ApplicationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationInner>> result = listDelegate(response);
                        ServiceResponse<List<ApplicationInner>> clientResponse = new ServiceResponse<List<ApplicationInner>>(result.getBody().getItems(), result.getResponse());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists applications by filter parameters. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param filter The filters to apply on the operation
     * @return the List&lt;ApplicationInner&gt; object if successful.
     */
    public List<ApplicationInner> list(String filter) {
        return listWithServiceResponseAsync(filter).toBlocking().single().getBody();
    }

    /**
     * Lists applications by filter parameters. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param filter The filters to apply on the operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ApplicationInner>> listAsync(String filter, final ServiceCallback<List<ApplicationInner>> serviceCallback) {
        return ServiceCall.create(listWithServiceResponseAsync(filter), serviceCallback);
    }

    /**
     * Lists applications by filter parameters. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param filter The filters to apply on the operation
     * @return the observable to the List&lt;ApplicationInner&gt; object
     */
    public Observable<List<ApplicationInner>> listAsync(String filter) {
        return listWithServiceResponseAsync(filter).map(new Func1<ServiceResponse<List<ApplicationInner>>, List<ApplicationInner>>() {
            @Override
            public List<ApplicationInner> call(ServiceResponse<List<ApplicationInner>> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Lists applications by filter parameters. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param filter The filters to apply on the operation
     * @return the observable to the List&lt;ApplicationInner&gt; object
     */
    public Observable<ServiceResponse<List<ApplicationInner>>> listWithServiceResponseAsync(String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<ApplicationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationInner>> result = listDelegate(response);
                        ServiceResponse<List<ApplicationInner>> clientResponse = new ServiceResponse<List<ApplicationInner>>(result.getBody().getItems(), result.getResponse());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ApplicationInner>> listDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl<ApplicationInner>, GraphErrorException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl<ApplicationInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Delete an application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     */
    public void delete(String applicationObjectId) {
        deleteWithServiceResponseAsync(applicationObjectId).toBlocking().single().getBody();
    }

    /**
     * Delete an application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> deleteAsync(String applicationObjectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(deleteWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    /**
     * Delete an application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String applicationObjectId) {
        return deleteWithServiceResponseAsync(applicationObjectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Delete an application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<Void, GraphErrorException>(this.client.mapperAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Get an application by object Id. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @return the ApplicationInner object if successful.
     */
    public ApplicationInner get(String applicationObjectId) {
        return getWithServiceResponseAsync(applicationObjectId).toBlocking().single().getBody();
    }

    /**
     * Get an application by object Id. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<ApplicationInner> getAsync(String applicationObjectId, final ServiceCallback<ApplicationInner> serviceCallback) {
        return ServiceCall.create(getWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    /**
     * Get an application by object Id. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @return the observable to the ApplicationInner object
     */
    public Observable<ApplicationInner> getAsync(String applicationObjectId) {
        return getWithServiceResponseAsync(applicationObjectId).map(new Func1<ServiceResponse<ApplicationInner>, ApplicationInner>() {
            @Override
            public ApplicationInner call(ServiceResponse<ApplicationInner> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Get an application by object Id. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @return the observable to the ApplicationInner object
     */
    public Observable<ServiceResponse<ApplicationInner>> getWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<ApplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ApplicationInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ApplicationInner> getDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<ApplicationInner, GraphErrorException>(this.client.mapperAdapter())
                .register(200, new TypeToken<ApplicationInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Update existing application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @param parameters Parameters to update an existing application.
     */
    public void patch(String applicationObjectId, ApplicationUpdateParametersInner parameters) {
        patchWithServiceResponseAsync(applicationObjectId, parameters).toBlocking().single().getBody();
    }

    /**
     * Update existing application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @param parameters Parameters to update an existing application.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> patchAsync(String applicationObjectId, ApplicationUpdateParametersInner parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(patchWithServiceResponseAsync(applicationObjectId, parameters), serviceCallback);
    }

    /**
     * Update existing application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @param parameters Parameters to update an existing application.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> patchAsync(String applicationObjectId, ApplicationUpdateParametersInner parameters) {
        return patchWithServiceResponseAsync(applicationObjectId, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Update existing application. Reference: http://msdn.microsoft.com/en-us/library/azure/hh974476.aspx.
     *
     * @param applicationObjectId Application object id
     * @param parameters Parameters to update an existing application.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> patchWithServiceResponseAsync(String applicationObjectId, ApplicationUpdateParametersInner parameters) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.patch(applicationObjectId, this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = patchDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> patchDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<Void, GraphErrorException>(this.client.mapperAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Get keyCredentials associated with the application by object Id. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @return the List&lt;KeyCredentialInner&gt; object if successful.
     */
    public List<KeyCredentialInner> listKeyCredentials(String applicationObjectId) {
        return listKeyCredentialsWithServiceResponseAsync(applicationObjectId).toBlocking().single().getBody();
    }

    /**
     * Get keyCredentials associated with the application by object Id. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<KeyCredentialInner>> listKeyCredentialsAsync(String applicationObjectId, final ServiceCallback<List<KeyCredentialInner>> serviceCallback) {
        return ServiceCall.create(listKeyCredentialsWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    /**
     * Get keyCredentials associated with the application by object Id. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @return the observable to the List&lt;KeyCredentialInner&gt; object
     */
    public Observable<List<KeyCredentialInner>> listKeyCredentialsAsync(String applicationObjectId) {
        return listKeyCredentialsWithServiceResponseAsync(applicationObjectId).map(new Func1<ServiceResponse<List<KeyCredentialInner>>, List<KeyCredentialInner>>() {
            @Override
            public List<KeyCredentialInner> call(ServiceResponse<List<KeyCredentialInner>> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Get keyCredentials associated with the application by object Id. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @return the observable to the List&lt;KeyCredentialInner&gt; object
     */
    public Observable<ServiceResponse<List<KeyCredentialInner>>> listKeyCredentialsWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listKeyCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<KeyCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<KeyCredentialInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<KeyCredentialInner>> result = listKeyCredentialsDelegate(response);
                        ServiceResponse<List<KeyCredentialInner>> clientResponse = new ServiceResponse<List<KeyCredentialInner>>(result.getBody().getItems(), result.getResponse());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<KeyCredentialInner>> listKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl<KeyCredentialInner>, GraphErrorException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl<KeyCredentialInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Update keyCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     */
    public void updateKeyCredentials(String applicationObjectId) {
        updateKeyCredentialsWithServiceResponseAsync(applicationObjectId).toBlocking().single().getBody();
    }

    /**
     * Update keyCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updateKeyCredentialsAsync(String applicationObjectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(updateKeyCredentialsWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    /**
     * Update keyCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updateKeyCredentialsAsync(String applicationObjectId) {
        return updateKeyCredentialsWithServiceResponseAsync(applicationObjectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Update keyCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updateKeyCredentialsWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final List<KeyCredentialInner> value = null;
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(null);
        return service.updateKeyCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updateKeyCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Update keyCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @param value KeyCredential list.
     */
    public void updateKeyCredentials(String applicationObjectId, List<KeyCredentialInner> value) {
        updateKeyCredentialsWithServiceResponseAsync(applicationObjectId, value).toBlocking().single().getBody();
    }

    /**
     * Update keyCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @param value KeyCredential list.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updateKeyCredentialsAsync(String applicationObjectId, List<KeyCredentialInner> value, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(updateKeyCredentialsWithServiceResponseAsync(applicationObjectId, value), serviceCallback);
    }

    /**
     * Update keyCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @param value KeyCredential list.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updateKeyCredentialsAsync(String applicationObjectId, List<KeyCredentialInner> value) {
        return updateKeyCredentialsWithServiceResponseAsync(applicationObjectId, value).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Update keyCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param applicationObjectId Application object id
     * @param value KeyCredential list.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updateKeyCredentialsWithServiceResponseAsync(String applicationObjectId, List<KeyCredentialInner> value) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(value);
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        return service.updateKeyCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updateKeyCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updateKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<Void, GraphErrorException>(this.client.mapperAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @return the List&lt;PasswordCredentialInner&gt; object if successful.
     */
    public List<PasswordCredentialInner> listPasswordCredentials(String applicationObjectId) {
        return listPasswordCredentialsWithServiceResponseAsync(applicationObjectId).toBlocking().single().getBody();
    }

    /**
     * Gets passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String applicationObjectId, final ServiceCallback<List<PasswordCredentialInner>> serviceCallback) {
        return ServiceCall.create(listPasswordCredentialsWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    /**
     * Gets passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @return the observable to the List&lt;PasswordCredentialInner&gt; object
     */
    public Observable<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String applicationObjectId) {
        return listPasswordCredentialsWithServiceResponseAsync(applicationObjectId).map(new Func1<ServiceResponse<List<PasswordCredentialInner>>, List<PasswordCredentialInner>>() {
            @Override
            public List<PasswordCredentialInner> call(ServiceResponse<List<PasswordCredentialInner>> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Gets passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @return the observable to the List&lt;PasswordCredentialInner&gt; object
     */
    public Observable<ServiceResponse<List<PasswordCredentialInner>>> listPasswordCredentialsWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listPasswordCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<PasswordCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<PasswordCredentialInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PasswordCredentialInner>> result = listPasswordCredentialsDelegate(response);
                        ServiceResponse<List<PasswordCredentialInner>> clientResponse = new ServiceResponse<List<PasswordCredentialInner>>(result.getBody().getItems(), result.getResponse());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PasswordCredentialInner>> listPasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl<PasswordCredentialInner>, GraphErrorException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl<PasswordCredentialInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Updates passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     */
    public void updatePasswordCredentials(String applicationObjectId) {
        updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId).toBlocking().single().getBody();
    }

    /**
     * Updates passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updatePasswordCredentialsAsync(String applicationObjectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    /**
     * Updates passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updatePasswordCredentialsAsync(String applicationObjectId) {
        return updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Updates passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updatePasswordCredentialsWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final List<PasswordCredentialInner> value = null;
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(null);
        return service.updatePasswordCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updatePasswordCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @param value PasswordCredential list.
     */
    public void updatePasswordCredentials(String applicationObjectId, List<PasswordCredentialInner> value) {
        updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId, value).toBlocking().single().getBody();
    }

    /**
     * Updates passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @param value PasswordCredential list.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updatePasswordCredentialsAsync(String applicationObjectId, List<PasswordCredentialInner> value, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId, value), serviceCallback);
    }

    /**
     * Updates passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @param value PasswordCredential list.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updatePasswordCredentialsAsync(String applicationObjectId, List<PasswordCredentialInner> value) {
        return updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId, value).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Updates passwordCredentials associated with an existing application. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param applicationObjectId Application object id
     * @param value PasswordCredential list.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updatePasswordCredentialsWithServiceResponseAsync(String applicationObjectId, List<PasswordCredentialInner> value) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(value);
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        return service.updatePasswordCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updatePasswordCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updatePasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<Void, GraphErrorException>(this.client.mapperAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

}
