/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.KeyCredentialsUpdateParameters;
import com.microsoft.azure.management.graphrbac.PasswordCredentialsUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ServicePrincipals.
 */
public final class ServicePrincipalsInner {
    /** The Retrofit service to perform REST calls. */
    private ServicePrincipalsService service;
    /** The service client containing this operation class. */
    private GraphRbacManagementClientImpl client;

    /**
     * Initializes an instance of ServicePrincipalsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ServicePrincipalsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = retrofit.create(ServicePrincipalsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ServicePrincipals to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ServicePrincipalsService {
        @Headers("Content-Type: application/json; charset=utf-8")
        @POST("{tenantID}/servicePrincipals")
        Observable<Response<ResponseBody>> create(@Path("tenantID") String tenantID, @Body ServicePrincipalCreateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{tenantID}/servicePrincipals")
        Observable<Response<ResponseBody>> list(@Path("tenantID") String tenantID, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @HTTP(path = "{tenantID}/servicePrincipals/{objectId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{tenantID}/servicePrincipals/{objectId}")
        Observable<Response<ResponseBody>> get(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{tenantID}/servicePrincipals/{objectId}/keyCredentials")
        Observable<Response<ResponseBody>> listKeyCredentials(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @PATCH("{tenantID}/servicePrincipals/{objectId}/keyCredentials")
        Observable<Response<ResponseBody>> updateKeyCredentials(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body KeyCredentialsUpdateParameters parameters, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{tenantID}/servicePrincipals/{objectId}/passwordCredentials")
        Observable<Response<ResponseBody>> listPasswordCredentials(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @PATCH("{tenantID}/servicePrincipals/{objectId}/passwordCredentials")
        Observable<Response<ResponseBody>> updatePasswordCredentials(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body PasswordCredentialsUpdateParameters parameters, @Header("User-Agent") String userAgent);

        @Headers("Content-Type: application/json; charset=utf-8")
        @GET("{tenantID}/{nextLink}")
        Observable<Response<ResponseBody>> listNext(@Path(value = "nextLink", encoded = true) String nextLink, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates a service principal in the  directory.
     *
     * @param parameters Parameters to create a service principal.
     * @return the ServicePrincipalInner object if successful.
     */
    public ServicePrincipalInner create(ServicePrincipalCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).toBlocking().single().getBody();
    }

    /**
     * Creates a service principal in the  directory.
     *
     * @param parameters Parameters to create a service principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<ServicePrincipalInner> createAsync(ServicePrincipalCreateParametersInner parameters, final ServiceCallback<ServicePrincipalInner> serviceCallback) {
        return ServiceCall.create(createWithServiceResponseAsync(parameters), serviceCallback);
    }

    /**
     * Creates a service principal in the  directory.
     *
     * @param parameters Parameters to create a service principal.
     * @return the observable to the ServicePrincipalInner object
     */
    public Observable<ServicePrincipalInner> createAsync(ServicePrincipalCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).map(new Func1<ServiceResponse<ServicePrincipalInner>, ServicePrincipalInner>() {
            @Override
            public ServicePrincipalInner call(ServiceResponse<ServicePrincipalInner> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Creates a service principal in the  directory.
     *
     * @param parameters Parameters to create a service principal.
     * @return the observable to the ServicePrincipalInner object
     */
    public Observable<ServiceResponse<ServicePrincipalInner>> createWithServiceResponseAsync(ServicePrincipalCreateParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.create(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServicePrincipalInner>>>() {
                @Override
                public Observable<ServiceResponse<ServicePrincipalInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServicePrincipalInner> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServicePrincipalInner> createDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<ServicePrincipalInner, GraphErrorException>(this.client.mapperAdapter())
                .register(201, new TypeToken<ServicePrincipalInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @return the PagedList&lt;ServicePrincipalInner&gt; object if successful.
     */
    public PagedList<ServicePrincipalInner> list() {
        ServiceResponse<Page<ServicePrincipalInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<ServicePrincipalInner>(response.getBody()) {
            @Override
            public Page<ServicePrincipalInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().getBody();
            }
        };
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ServicePrincipalInner>> listAsync(final ListOperationCallback<ServicePrincipalInner> serviceCallback) {
        return AzureServiceCall.create(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<Page<ServicePrincipalInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Page<ServicePrincipalInner>>() {
                @Override
                public Page<ServicePrincipalInner> call(ServiceResponse<Page<ServicePrincipalInner>> response) {
                    return response.getBody();
                }
            });
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(ServiceResponse<Page<ServicePrincipalInner>> page) {
                    String nextLink = page.getBody().getNextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @return the PagedList&lt;ServicePrincipalInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listSinglePageAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ServicePrincipalInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServicePrincipalInner>>(result.getBody(), result.getResponse()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @param filter The filter to apply on the operation.
     * @return the PagedList&lt;ServicePrincipalInner&gt; object if successful.
     */
    public PagedList<ServicePrincipalInner> list(final String filter) {
        ServiceResponse<Page<ServicePrincipalInner>> response = listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<ServicePrincipalInner>(response.getBody()) {
            @Override
            public Page<ServicePrincipalInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().getBody();
            }
        };
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @param filter The filter to apply on the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ServicePrincipalInner>> listAsync(final String filter, final ListOperationCallback<ServicePrincipalInner> serviceCallback) {
        return AzureServiceCall.create(
            listSinglePageAsync(filter),
            new Func1<String, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @param filter The filter to apply on the operation.
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<Page<ServicePrincipalInner>> listAsync(final String filter) {
        return listWithServiceResponseAsync(filter)
            .map(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Page<ServicePrincipalInner>>() {
                @Override
                public Page<ServicePrincipalInner> call(ServiceResponse<Page<ServicePrincipalInner>> response) {
                    return response.getBody();
                }
            });
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @param filter The filter to apply on the operation.
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listWithServiceResponseAsync(final String filter) {
        return listSinglePageAsync(filter)
            .concatMap(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(ServiceResponse<Page<ServicePrincipalInner>> page) {
                    String nextLink = page.getBody().getNextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets list of service principals from the current tenant.
     *
    ServiceResponse<PageImpl1<ServicePrincipalInner>> * @param filter The filter to apply on the operation.
     * @return the PagedList&lt;ServicePrincipalInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listSinglePageAsync(final String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ServicePrincipalInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServicePrincipalInner>>(result.getBody(), result.getResponse()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ServicePrincipalInner>> listDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl1<ServicePrincipalInner>, GraphErrorException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl1<ServicePrincipalInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Deletes service principal from the directory.
     *
     * @param objectId Object id to delete service principal information.
     */
    public void delete(String objectId) {
        deleteWithServiceResponseAsync(objectId).toBlocking().single().getBody();
    }

    /**
     * Deletes service principal from the directory.
     *
     * @param objectId Object id to delete service principal information.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> deleteAsync(String objectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(deleteWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Deletes service principal from the directory.
     *
     * @param objectId Object id to delete service principal information.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String objectId) {
        return deleteWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Deletes service principal from the directory.
     *
     * @param objectId Object id to delete service principal information.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<Void, GraphErrorException>(this.client.mapperAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets service principal information from the directory.
     *
     * @param objectId Object id to get service principal information.
     * @return the ServicePrincipalInner object if successful.
     */
    public ServicePrincipalInner get(String objectId) {
        return getWithServiceResponseAsync(objectId).toBlocking().single().getBody();
    }

    /**
     * Gets service principal information from the directory.
     *
     * @param objectId Object id to get service principal information.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<ServicePrincipalInner> getAsync(String objectId, final ServiceCallback<ServicePrincipalInner> serviceCallback) {
        return ServiceCall.create(getWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Gets service principal information from the directory.
     *
     * @param objectId Object id to get service principal information.
     * @return the observable to the ServicePrincipalInner object
     */
    public Observable<ServicePrincipalInner> getAsync(String objectId) {
        return getWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<ServicePrincipalInner>, ServicePrincipalInner>() {
            @Override
            public ServicePrincipalInner call(ServiceResponse<ServicePrincipalInner> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Gets service principal information from the directory.
     *
     * @param objectId Object id to get service principal information.
     * @return the observable to the ServicePrincipalInner object
     */
    public Observable<ServiceResponse<ServicePrincipalInner>> getWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServicePrincipalInner>>>() {
                @Override
                public Observable<ServiceResponse<ServicePrincipalInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServicePrincipalInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServicePrincipalInner> getDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<ServicePrincipalInner, GraphErrorException>(this.client.mapperAdapter())
                .register(200, new TypeToken<ServicePrincipalInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Get keyCredentials associated with the service principal by object Id. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @return the List&lt;KeyCredentialInner&gt; object if successful.
     */
    public List<KeyCredentialInner> listKeyCredentials(String objectId) {
        return listKeyCredentialsWithServiceResponseAsync(objectId).toBlocking().single().getBody();
    }

    /**
     * Get keyCredentials associated with the service principal by object Id. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<KeyCredentialInner>> listKeyCredentialsAsync(String objectId, final ServiceCallback<List<KeyCredentialInner>> serviceCallback) {
        return ServiceCall.create(listKeyCredentialsWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Get keyCredentials associated with the service principal by object Id. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @return the observable to the List&lt;KeyCredentialInner&gt; object
     */
    public Observable<List<KeyCredentialInner>> listKeyCredentialsAsync(String objectId) {
        return listKeyCredentialsWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<List<KeyCredentialInner>>, List<KeyCredentialInner>>() {
            @Override
            public List<KeyCredentialInner> call(ServiceResponse<List<KeyCredentialInner>> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Get keyCredentials associated with the service principal by object Id. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @return the observable to the List&lt;KeyCredentialInner&gt; object
     */
    public Observable<ServiceResponse<List<KeyCredentialInner>>> listKeyCredentialsWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listKeyCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<KeyCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<KeyCredentialInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<KeyCredentialInner>> result = listKeyCredentialsDelegate(response);
                        ServiceResponse<List<KeyCredentialInner>> clientResponse = new ServiceResponse<List<KeyCredentialInner>>(result.getBody().getItems(), result.getResponse());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<KeyCredentialInner>> listKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl<KeyCredentialInner>, GraphErrorException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl<KeyCredentialInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Update keyCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     */
    public void updateKeyCredentials(String objectId) {
        updateKeyCredentialsWithServiceResponseAsync(objectId).toBlocking().single().getBody();
    }

    /**
     * Update keyCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updateKeyCredentialsAsync(String objectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(updateKeyCredentialsWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Update keyCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updateKeyCredentialsAsync(String objectId) {
        return updateKeyCredentialsWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Update keyCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updateKeyCredentialsWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final List<KeyCredentialInner> value = null;
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(null);
        return service.updateKeyCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updateKeyCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Update keyCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param value KeyCredential list.
     */
    public void updateKeyCredentials(String objectId, List<KeyCredentialInner> value) {
        updateKeyCredentialsWithServiceResponseAsync(objectId, value).toBlocking().single().getBody();
    }

    /**
     * Update keyCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param value KeyCredential list.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updateKeyCredentialsAsync(String objectId, List<KeyCredentialInner> value, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(updateKeyCredentialsWithServiceResponseAsync(objectId, value), serviceCallback);
    }

    /**
     * Update keyCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param value KeyCredential list.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updateKeyCredentialsAsync(String objectId, List<KeyCredentialInner> value) {
        return updateKeyCredentialsWithServiceResponseAsync(objectId, value).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Update keyCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#keycredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param value KeyCredential list.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updateKeyCredentialsWithServiceResponseAsync(String objectId, List<KeyCredentialInner> value) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(value);
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        return service.updateKeyCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updateKeyCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updateKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<Void, GraphErrorException>(this.client.mapperAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @return the List&lt;PasswordCredentialInner&gt; object if successful.
     */
    public List<PasswordCredentialInner> listPasswordCredentials(String objectId) {
        return listPasswordCredentialsWithServiceResponseAsync(objectId).toBlocking().single().getBody();
    }

    /**
     * Gets passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String objectId, final ServiceCallback<List<PasswordCredentialInner>> serviceCallback) {
        return ServiceCall.create(listPasswordCredentialsWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Gets passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @return the observable to the List&lt;PasswordCredentialInner&gt; object
     */
    public Observable<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String objectId) {
        return listPasswordCredentialsWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<List<PasswordCredentialInner>>, List<PasswordCredentialInner>>() {
            @Override
            public List<PasswordCredentialInner> call(ServiceResponse<List<PasswordCredentialInner>> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Gets passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @return the observable to the List&lt;PasswordCredentialInner&gt; object
     */
    public Observable<ServiceResponse<List<PasswordCredentialInner>>> listPasswordCredentialsWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listPasswordCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<PasswordCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<PasswordCredentialInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PasswordCredentialInner>> result = listPasswordCredentialsDelegate(response);
                        ServiceResponse<List<PasswordCredentialInner>> clientResponse = new ServiceResponse<List<PasswordCredentialInner>>(result.getBody().getItems(), result.getResponse());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PasswordCredentialInner>> listPasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl<PasswordCredentialInner>, GraphErrorException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl<PasswordCredentialInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Updates passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     */
    public void updatePasswordCredentials(String objectId) {
        updatePasswordCredentialsWithServiceResponseAsync(objectId).toBlocking().single().getBody();
    }

    /**
     * Updates passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updatePasswordCredentialsAsync(String objectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(updatePasswordCredentialsWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Updates passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updatePasswordCredentialsAsync(String objectId) {
        return updatePasswordCredentialsWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Updates passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updatePasswordCredentialsWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final List<PasswordCredentialInner> value = null;
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(null);
        return service.updatePasswordCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updatePasswordCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param value PasswordCredential list.
     */
    public void updatePasswordCredentials(String objectId, List<PasswordCredentialInner> value) {
        updatePasswordCredentialsWithServiceResponseAsync(objectId, value).toBlocking().single().getBody();
    }

    /**
     * Updates passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param value PasswordCredential list.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updatePasswordCredentialsAsync(String objectId, List<PasswordCredentialInner> value, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(updatePasswordCredentialsWithServiceResponseAsync(objectId, value), serviceCallback);
    }

    /**
     * Updates passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param value PasswordCredential list.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updatePasswordCredentialsAsync(String objectId, List<PasswordCredentialInner> value) {
        return updatePasswordCredentialsWithServiceResponseAsync(objectId, value).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.getBody();
            }
        });
    }

    /**
     * Updates passwordCredentials associated with an existing service principal. Reference: https://msdn.microsoft.com/en-us/library/azure/ad/graph/api/entity-and-complex-type-reference#passwordcredential-type.
     *
     * @param objectId Object id to get service principal information.
     * @param value PasswordCredential list.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updatePasswordCredentialsWithServiceResponseAsync(String objectId, List<PasswordCredentialInner> value) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(value);
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        return service.updatePasswordCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updatePasswordCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updatePasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<Void, GraphErrorException>(this.client.mapperAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @param nextLink Next link for list operation.
     * @return the PagedList&lt;ServicePrincipalInner&gt; object if successful.
     */
    public PagedList<ServicePrincipalInner> listNext(final String nextLink) {
        ServiceResponse<Page<ServicePrincipalInner>> response = listNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<ServicePrincipalInner>(response.getBody()) {
            @Override
            public Page<ServicePrincipalInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().getBody();
            }
        };
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @param nextLink Next link for list operation.
     * @param serviceCall the ServiceCall object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ServicePrincipalInner>> listNextAsync(final String nextLink, final ServiceCall<List<ServicePrincipalInner>> serviceCall, final ListOperationCallback<ServicePrincipalInner> serviceCallback) {
        return AzureServiceCall.create(
            listNextSinglePageAsync(nextLink),
            new Func1<String, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @param nextLink Next link for list operation.
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<Page<ServicePrincipalInner>> listNextAsync(final String nextLink) {
        return listNextWithServiceResponseAsync(nextLink)
            .map(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Page<ServicePrincipalInner>>() {
                @Override
                public Page<ServicePrincipalInner> call(ServiceResponse<Page<ServicePrincipalInner>> response) {
                    return response.getBody();
                }
            });
    }

    /**
     * Gets list of service principals from the current tenant.
     *
     * @param nextLink Next link for list operation.
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listNextWithServiceResponseAsync(final String nextLink) {
        return listNextSinglePageAsync(nextLink)
            .concatMap(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(ServiceResponse<Page<ServicePrincipalInner>> page) {
                    String nextLink = page.getBody().getNextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets list of service principals from the current tenant.
     *
    ServiceResponse<PageImpl1<ServicePrincipalInner>> * @param nextLink Next link for list operation.
     * @return the PagedList&lt;ServicePrincipalInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listNextSinglePageAsync(final String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listNext(nextLink, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ServicePrincipalInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServicePrincipalInner>>(result.getBody(), result.getResponse()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ServicePrincipalInner>> listNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder<PageImpl1<ServicePrincipalInner>, GraphErrorException>(this.client.mapperAdapter())
                .register(200, new TypeToken<PageImpl1<ServicePrincipalInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

}
