/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.KeyCredentialsUpdateParameters;
import com.microsoft.azure.management.graphrbac.PasswordCredentialsUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Applications.
 */
public final class ApplicationsInner {
    /** The Retrofit service to perform REST calls. */
    private ApplicationsService service;
    /** The service client containing this operation class. */
    private GraphRbacManagementClientImpl client;

    /**
     * Initializes an instance of ApplicationsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ApplicationsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = retrofit.create(ApplicationsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Applications to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ApplicationsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications create" })
        @POST("{tenantID}/applications")
        Observable<Response<ResponseBody>> create(@Path("tenantID") String tenantID, @Body ApplicationCreateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications list" })
        @GET("{tenantID}/applications")
        Observable<Response<ResponseBody>> list(@Path("tenantID") String tenantID, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications delete" })
        @HTTP(path = "{tenantID}/applications/{applicationObjectId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications get" })
        @GET("{tenantID}/applications/{applicationObjectId}")
        Observable<Response<ResponseBody>> get(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications patch" })
        @PATCH("{tenantID}/applications/{applicationObjectId}")
        Observable<Response<ResponseBody>> patch(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Body ApplicationUpdateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications listKeyCredentials" })
        @GET("{tenantID}/applications/{applicationObjectId}/keyCredentials")
        Observable<Response<ResponseBody>> listKeyCredentials(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications updateKeyCredentials" })
        @PATCH("{tenantID}/applications/{applicationObjectId}/keyCredentials")
        Observable<Response<ResponseBody>> updateKeyCredentials(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body KeyCredentialsUpdateParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications listPasswordCredentials" })
        @GET("{tenantID}/applications/{applicationObjectId}/passwordCredentials")
        Observable<Response<ResponseBody>> listPasswordCredentials(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications updatePasswordCredentials" })
        @PATCH("{tenantID}/applications/{applicationObjectId}/passwordCredentials")
        Observable<Response<ResponseBody>> updatePasswordCredentials(@Path(value = "applicationObjectId", encoded = true) String applicationObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body PasswordCredentialsUpdateParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Applications listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create a new application.
     *
     * @param parameters The parameters for creating an application.
     * @return the ApplicationInner object if successful.
     */
    public ApplicationInner create(ApplicationCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).toBlocking().single().body();
    }

    /**
     * Create a new application.
     *
     * @param parameters The parameters for creating an application.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<ApplicationInner> createAsync(ApplicationCreateParametersInner parameters, final ServiceCallback<ApplicationInner> serviceCallback) {
        return ServiceCall.fromResponse(createWithServiceResponseAsync(parameters), serviceCallback);
    }

    /**
     * Create a new application.
     *
     * @param parameters The parameters for creating an application.
     * @return the observable to the ApplicationInner object
     */
    public Observable<ApplicationInner> createAsync(ApplicationCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).map(new Func1<ServiceResponse<ApplicationInner>, ApplicationInner>() {
            @Override
            public ApplicationInner call(ServiceResponse<ApplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create a new application.
     *
     * @param parameters The parameters for creating an application.
     * @return the observable to the ApplicationInner object
     */
    public Observable<ServiceResponse<ApplicationInner>> createWithServiceResponseAsync(ApplicationCreateParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.create(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<ApplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ApplicationInner> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ApplicationInner> createDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ApplicationInner, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<ApplicationInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Lists applications by filter parameters.
     *
     * @return the PagedList&lt;ApplicationInner&gt; object if successful.
     */
    public PagedList<ApplicationInner> list() {
        ServiceResponse<Page<ApplicationInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationInner>(response.body()) {
            @Override
            public Page<ApplicationInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists applications by filter parameters.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ApplicationInner>> listAsync(final ListOperationCallback<ApplicationInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists applications by filter parameters.
     *
     * @return the observable to the PagedList&lt;ApplicationInner&gt; object
     */
    public Observable<Page<ApplicationInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ApplicationInner>>, Page<ApplicationInner>>() {
                @Override
                public Page<ApplicationInner> call(ServiceResponse<Page<ApplicationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists applications by filter parameters.
     *
     * @return the observable to the PagedList&lt;ApplicationInner&gt; object
     */
    public Observable<ServiceResponse<Page<ApplicationInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ApplicationInner>>, Observable<ServiceResponse<Page<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationInner>>> call(ServiceResponse<Page<ApplicationInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Lists applications by filter parameters.
     *
     * @return the PagedList&lt;ApplicationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ApplicationInner>>> listSinglePageAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ApplicationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists applications by filter parameters.
     *
     * @param filter The filters to apply to the operation.
     * @return the PagedList&lt;ApplicationInner&gt; object if successful.
     */
    public PagedList<ApplicationInner> list(final String filter) {
        ServiceResponse<Page<ApplicationInner>> response = listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<ApplicationInner>(response.body()) {
            @Override
            public Page<ApplicationInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists applications by filter parameters.
     *
     * @param filter The filters to apply to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ApplicationInner>> listAsync(final String filter, final ListOperationCallback<ApplicationInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listSinglePageAsync(filter),
            new Func1<String, Observable<ServiceResponse<Page<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists applications by filter parameters.
     *
     * @param filter The filters to apply to the operation.
     * @return the observable to the PagedList&lt;ApplicationInner&gt; object
     */
    public Observable<Page<ApplicationInner>> listAsync(final String filter) {
        return listWithServiceResponseAsync(filter)
            .map(new Func1<ServiceResponse<Page<ApplicationInner>>, Page<ApplicationInner>>() {
                @Override
                public Page<ApplicationInner> call(ServiceResponse<Page<ApplicationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists applications by filter parameters.
     *
     * @param filter The filters to apply to the operation.
     * @return the observable to the PagedList&lt;ApplicationInner&gt; object
     */
    public Observable<ServiceResponse<Page<ApplicationInner>>> listWithServiceResponseAsync(final String filter) {
        return listSinglePageAsync(filter)
            .concatMap(new Func1<ServiceResponse<Page<ApplicationInner>>, Observable<ServiceResponse<Page<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationInner>>> call(ServiceResponse<Page<ApplicationInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Lists applications by filter parameters.
     *
    ServiceResponse<PageImpl<ApplicationInner>> * @param filter The filters to apply to the operation.
     * @return the PagedList&lt;ApplicationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ApplicationInner>>> listSinglePageAsync(final String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ApplicationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ApplicationInner>> listDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ApplicationInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ApplicationInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Delete an application.
     *
     * @param applicationObjectId Application object ID.
     */
    public void delete(String applicationObjectId) {
        deleteWithServiceResponseAsync(applicationObjectId).toBlocking().single().body();
    }

    /**
     * Delete an application.
     *
     * @param applicationObjectId Application object ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> deleteAsync(String applicationObjectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(deleteWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    /**
     * Delete an application.
     *
     * @param applicationObjectId Application object ID.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String applicationObjectId) {
        return deleteWithServiceResponseAsync(applicationObjectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete an application.
     *
     * @param applicationObjectId Application object ID.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Get an application by object ID.
     *
     * @param applicationObjectId Application object ID.
     * @return the ApplicationInner object if successful.
     */
    public ApplicationInner get(String applicationObjectId) {
        return getWithServiceResponseAsync(applicationObjectId).toBlocking().single().body();
    }

    /**
     * Get an application by object ID.
     *
     * @param applicationObjectId Application object ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<ApplicationInner> getAsync(String applicationObjectId, final ServiceCallback<ApplicationInner> serviceCallback) {
        return ServiceCall.fromResponse(getWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    /**
     * Get an application by object ID.
     *
     * @param applicationObjectId Application object ID.
     * @return the observable to the ApplicationInner object
     */
    public Observable<ApplicationInner> getAsync(String applicationObjectId) {
        return getWithServiceResponseAsync(applicationObjectId).map(new Func1<ServiceResponse<ApplicationInner>, ApplicationInner>() {
            @Override
            public ApplicationInner call(ServiceResponse<ApplicationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get an application by object ID.
     *
     * @param applicationObjectId Application object ID.
     * @return the observable to the ApplicationInner object
     */
    public Observable<ServiceResponse<ApplicationInner>> getWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInner>>>() {
                @Override
                public Observable<ServiceResponse<ApplicationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ApplicationInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ApplicationInner> getDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ApplicationInner, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ApplicationInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Update an existing application.
     *
     * @param applicationObjectId Application object ID.
     * @param parameters Parameters to update an existing application.
     */
    public void patch(String applicationObjectId, ApplicationUpdateParametersInner parameters) {
        patchWithServiceResponseAsync(applicationObjectId, parameters).toBlocking().single().body();
    }

    /**
     * Update an existing application.
     *
     * @param applicationObjectId Application object ID.
     * @param parameters Parameters to update an existing application.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> patchAsync(String applicationObjectId, ApplicationUpdateParametersInner parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(patchWithServiceResponseAsync(applicationObjectId, parameters), serviceCallback);
    }

    /**
     * Update an existing application.
     *
     * @param applicationObjectId Application object ID.
     * @param parameters Parameters to update an existing application.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> patchAsync(String applicationObjectId, ApplicationUpdateParametersInner parameters) {
        return patchWithServiceResponseAsync(applicationObjectId, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Update an existing application.
     *
     * @param applicationObjectId Application object ID.
     * @param parameters Parameters to update an existing application.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> patchWithServiceResponseAsync(String applicationObjectId, ApplicationUpdateParametersInner parameters) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.patch(applicationObjectId, this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = patchDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> patchDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Get the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @return the List&lt;KeyCredentialInner&gt; object if successful.
     */
    public List<KeyCredentialInner> listKeyCredentials(String applicationObjectId) {
        return listKeyCredentialsWithServiceResponseAsync(applicationObjectId).toBlocking().single().body();
    }

    /**
     * Get the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<KeyCredentialInner>> listKeyCredentialsAsync(String applicationObjectId, final ServiceCallback<List<KeyCredentialInner>> serviceCallback) {
        return ServiceCall.fromResponse(listKeyCredentialsWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    /**
     * Get the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @return the observable to the List&lt;KeyCredentialInner&gt; object
     */
    public Observable<List<KeyCredentialInner>> listKeyCredentialsAsync(String applicationObjectId) {
        return listKeyCredentialsWithServiceResponseAsync(applicationObjectId).map(new Func1<ServiceResponse<List<KeyCredentialInner>>, List<KeyCredentialInner>>() {
            @Override
            public List<KeyCredentialInner> call(ServiceResponse<List<KeyCredentialInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @return the observable to the List&lt;KeyCredentialInner&gt; object
     */
    public Observable<ServiceResponse<List<KeyCredentialInner>>> listKeyCredentialsWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listKeyCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<KeyCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<KeyCredentialInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<KeyCredentialInner>> result = listKeyCredentialsDelegate(response);
                        ServiceResponse<List<KeyCredentialInner>> clientResponse = new ServiceResponse<List<KeyCredentialInner>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<KeyCredentialInner>> listKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<KeyCredentialInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<KeyCredentialInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Update the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of KeyCredentials.
     */
    public void updateKeyCredentials(String applicationObjectId, List<KeyCredentialInner> value) {
        updateKeyCredentialsWithServiceResponseAsync(applicationObjectId, value).toBlocking().single().body();
    }

    /**
     * Update the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of KeyCredentials.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updateKeyCredentialsAsync(String applicationObjectId, List<KeyCredentialInner> value, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(updateKeyCredentialsWithServiceResponseAsync(applicationObjectId, value), serviceCallback);
    }

    /**
     * Update the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of KeyCredentials.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updateKeyCredentialsAsync(String applicationObjectId, List<KeyCredentialInner> value) {
        return updateKeyCredentialsWithServiceResponseAsync(applicationObjectId, value).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Update the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of KeyCredentials.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updateKeyCredentialsWithServiceResponseAsync(String applicationObjectId, List<KeyCredentialInner> value) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(value);
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        return service.updateKeyCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updateKeyCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updateKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Get the passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @return the List&lt;PasswordCredentialInner&gt; object if successful.
     */
    public List<PasswordCredentialInner> listPasswordCredentials(String applicationObjectId) {
        return listPasswordCredentialsWithServiceResponseAsync(applicationObjectId).toBlocking().single().body();
    }

    /**
     * Get the passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String applicationObjectId, final ServiceCallback<List<PasswordCredentialInner>> serviceCallback) {
        return ServiceCall.fromResponse(listPasswordCredentialsWithServiceResponseAsync(applicationObjectId), serviceCallback);
    }

    /**
     * Get the passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @return the observable to the List&lt;PasswordCredentialInner&gt; object
     */
    public Observable<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String applicationObjectId) {
        return listPasswordCredentialsWithServiceResponseAsync(applicationObjectId).map(new Func1<ServiceResponse<List<PasswordCredentialInner>>, List<PasswordCredentialInner>>() {
            @Override
            public List<PasswordCredentialInner> call(ServiceResponse<List<PasswordCredentialInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @return the observable to the List&lt;PasswordCredentialInner&gt; object
     */
    public Observable<ServiceResponse<List<PasswordCredentialInner>>> listPasswordCredentialsWithServiceResponseAsync(String applicationObjectId) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listPasswordCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<PasswordCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<PasswordCredentialInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<PasswordCredentialInner>> result = listPasswordCredentialsDelegate(response);
                        ServiceResponse<List<PasswordCredentialInner>> clientResponse = new ServiceResponse<List<PasswordCredentialInner>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<PasswordCredentialInner>> listPasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<PasswordCredentialInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<PasswordCredentialInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Update passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of PasswordCredentials.
     */
    public void updatePasswordCredentials(String applicationObjectId, List<PasswordCredentialInner> value) {
        updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId, value).toBlocking().single().body();
    }

    /**
     * Update passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of PasswordCredentials.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updatePasswordCredentialsAsync(String applicationObjectId, List<PasswordCredentialInner> value, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId, value), serviceCallback);
    }

    /**
     * Update passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of PasswordCredentials.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updatePasswordCredentialsAsync(String applicationObjectId, List<PasswordCredentialInner> value) {
        return updatePasswordCredentialsWithServiceResponseAsync(applicationObjectId, value).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Update passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of PasswordCredentials.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updatePasswordCredentialsWithServiceResponseAsync(String applicationObjectId, List<PasswordCredentialInner> value) {
        if (applicationObjectId == null) {
            throw new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(value);
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        return service.updatePasswordCredentials(applicationObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updatePasswordCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updatePasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets a list of applications from the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the PagedList&lt;ApplicationInner&gt; object if successful.
     */
    public PagedList<ApplicationInner> listNext(final String nextLink) {
        ServiceResponse<Page<ApplicationInner>> response = listNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<ApplicationInner>(response.body()) {
            @Override
            public Page<ApplicationInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of applications from the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @param serviceCall the ServiceCall object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ApplicationInner>> listNextAsync(final String nextLink, final ServiceCall<List<ApplicationInner>> serviceCall, final ListOperationCallback<ApplicationInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listNextSinglePageAsync(nextLink),
            new Func1<String, Observable<ServiceResponse<Page<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of applications from the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the observable to the PagedList&lt;ApplicationInner&gt; object
     */
    public Observable<Page<ApplicationInner>> listNextAsync(final String nextLink) {
        return listNextWithServiceResponseAsync(nextLink)
            .map(new Func1<ServiceResponse<Page<ApplicationInner>>, Page<ApplicationInner>>() {
                @Override
                public Page<ApplicationInner> call(ServiceResponse<Page<ApplicationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of applications from the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the observable to the PagedList&lt;ApplicationInner&gt; object
     */
    public Observable<ServiceResponse<Page<ApplicationInner>>> listNextWithServiceResponseAsync(final String nextLink) {
        return listNextSinglePageAsync(nextLink)
            .concatMap(new Func1<ServiceResponse<Page<ApplicationInner>>, Observable<ServiceResponse<Page<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationInner>>> call(ServiceResponse<Page<ApplicationInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets a list of applications from the current tenant.
     *
    ServiceResponse<PageImpl<ApplicationInner>> * @param nextLink Next link for the list operation.
     * @return the PagedList&lt;ApplicationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ApplicationInner>>> listNextSinglePageAsync(final String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return service.listNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ApplicationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ApplicationInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ApplicationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ApplicationInner>> listNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ApplicationInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ApplicationInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

}
