/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.GroupAddMemberParameters;
import com.microsoft.azure.management.graphrbac.GroupGetMemberGroupsParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Groups.
 */
public final class GroupsInner {
    /** The Retrofit service to perform REST calls. */
    private GroupsService service;
    /** The service client containing this operation class. */
    private GraphRbacManagementClientImpl client;

    /**
     * Initializes an instance of GroupsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public GroupsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = retrofit.create(GroupsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Groups to be
     * used by Retrofit to perform actually REST calls.
     */
    interface GroupsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups isMemberOf" })
        @POST("{tenantID}/isMemberOf")
        Observable<Response<ResponseBody>> isMemberOf(@Path("tenantID") String tenantID, @Body CheckGroupMembershipParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups removeMember" })
        @HTTP(path = "{tenantID}/groups/{groupObjectId}/$links/members/{memberObjectId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> removeMember(@Path(value = "groupObjectId", encoded = true) String groupObjectId, @Path(value = "memberObjectId", encoded = true) String memberObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups addMember" })
        @POST("{tenantID}/groups/{groupObjectId}/$links/members")
        Observable<Response<ResponseBody>> addMember(@Path(value = "groupObjectId", encoded = true) String groupObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body GroupAddMemberParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups delete" })
        @HTTP(path = "{tenantID}/groups/{groupObjectId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path(value = "groupObjectId", encoded = true) String groupObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups create" })
        @POST("{tenantID}/groups")
        Observable<Response<ResponseBody>> create(@Path("tenantID") String tenantID, @Body GroupCreateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups list" })
        @GET("{tenantID}/groups")
        Observable<Response<ResponseBody>> list(@Path("tenantID") String tenantID, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups getGroupMembers" })
        @GET("{tenantID}/groups/{objectId}/members")
        Observable<Response<ResponseBody>> getGroupMembers(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups get" })
        @GET("{tenantID}/groups/{objectId}")
        Observable<Response<ResponseBody>> get(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups getMemberGroups" })
        @POST("{tenantID}/groups/{objectId}/getMemberGroups")
        Observable<Response<ResponseBody>> getMemberGroups(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body GroupGetMemberGroupsParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups getGroupMembersNext" })
        @GET
        Observable<Response<ResponseBody>> getGroupMembersNext(@Url String nextUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Checks whether the specified user, group, contact, or service principal is a direct or transitive member of the specified group.
     *
     * @param parameters The check group membership parameters.
     * @return the CheckGroupMembershipResultInner object if successful.
     */
    public CheckGroupMembershipResultInner isMemberOf(CheckGroupMembershipParametersInner parameters) {
        return isMemberOfWithServiceResponseAsync(parameters).toBlocking().single().body();
    }

    /**
     * Checks whether the specified user, group, contact, or service principal is a direct or transitive member of the specified group.
     *
     * @param parameters The check group membership parameters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<CheckGroupMembershipResultInner> isMemberOfAsync(CheckGroupMembershipParametersInner parameters, final ServiceCallback<CheckGroupMembershipResultInner> serviceCallback) {
        return ServiceCall.fromResponse(isMemberOfWithServiceResponseAsync(parameters), serviceCallback);
    }

    /**
     * Checks whether the specified user, group, contact, or service principal is a direct or transitive member of the specified group.
     *
     * @param parameters The check group membership parameters.
     * @return the observable to the CheckGroupMembershipResultInner object
     */
    public Observable<CheckGroupMembershipResultInner> isMemberOfAsync(CheckGroupMembershipParametersInner parameters) {
        return isMemberOfWithServiceResponseAsync(parameters).map(new Func1<ServiceResponse<CheckGroupMembershipResultInner>, CheckGroupMembershipResultInner>() {
            @Override
            public CheckGroupMembershipResultInner call(ServiceResponse<CheckGroupMembershipResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Checks whether the specified user, group, contact, or service principal is a direct or transitive member of the specified group.
     *
     * @param parameters The check group membership parameters.
     * @return the observable to the CheckGroupMembershipResultInner object
     */
    public Observable<ServiceResponse<CheckGroupMembershipResultInner>> isMemberOfWithServiceResponseAsync(CheckGroupMembershipParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.isMemberOf(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckGroupMembershipResultInner>>>() {
                @Override
                public Observable<ServiceResponse<CheckGroupMembershipResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CheckGroupMembershipResultInner> clientResponse = isMemberOfDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CheckGroupMembershipResultInner> isMemberOfDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CheckGroupMembershipResultInner, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CheckGroupMembershipResultInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Remove a member from a group.
     *
     * @param groupObjectId The object ID of the group from which to remove the member.
     * @param memberObjectId Member object id
     */
    public void removeMember(String groupObjectId, String memberObjectId) {
        removeMemberWithServiceResponseAsync(groupObjectId, memberObjectId).toBlocking().single().body();
    }

    /**
     * Remove a member from a group.
     *
     * @param groupObjectId The object ID of the group from which to remove the member.
     * @param memberObjectId Member object id
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> removeMemberAsync(String groupObjectId, String memberObjectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(removeMemberWithServiceResponseAsync(groupObjectId, memberObjectId), serviceCallback);
    }

    /**
     * Remove a member from a group.
     *
     * @param groupObjectId The object ID of the group from which to remove the member.
     * @param memberObjectId Member object id
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> removeMemberAsync(String groupObjectId, String memberObjectId) {
        return removeMemberWithServiceResponseAsync(groupObjectId, memberObjectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Remove a member from a group.
     *
     * @param groupObjectId The object ID of the group from which to remove the member.
     * @param memberObjectId Member object id
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> removeMemberWithServiceResponseAsync(String groupObjectId, String memberObjectId) {
        if (groupObjectId == null) {
            throw new IllegalArgumentException("Parameter groupObjectId is required and cannot be null.");
        }
        if (memberObjectId == null) {
            throw new IllegalArgumentException("Parameter memberObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.removeMember(groupObjectId, memberObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = removeMemberDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> removeMemberDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Add a member to a group.
     *
     * @param groupObjectId The object ID of the group to which to add the member.
     * @param url A member object URL, such as "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects/f260bbc4-c254-447b-94cf-293b5ec434dd", where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is the objectId of the member (user, application, servicePrincipal, group) to be added.
     */
    public void addMember(String groupObjectId, String url) {
        addMemberWithServiceResponseAsync(groupObjectId, url).toBlocking().single().body();
    }

    /**
     * Add a member to a group.
     *
     * @param groupObjectId The object ID of the group to which to add the member.
     * @param url A member object URL, such as "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects/f260bbc4-c254-447b-94cf-293b5ec434dd", where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is the objectId of the member (user, application, servicePrincipal, group) to be added.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> addMemberAsync(String groupObjectId, String url, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(addMemberWithServiceResponseAsync(groupObjectId, url), serviceCallback);
    }

    /**
     * Add a member to a group.
     *
     * @param groupObjectId The object ID of the group to which to add the member.
     * @param url A member object URL, such as "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects/f260bbc4-c254-447b-94cf-293b5ec434dd", where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is the objectId of the member (user, application, servicePrincipal, group) to be added.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> addMemberAsync(String groupObjectId, String url) {
        return addMemberWithServiceResponseAsync(groupObjectId, url).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Add a member to a group.
     *
     * @param groupObjectId The object ID of the group to which to add the member.
     * @param url A member object URL, such as "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects/f260bbc4-c254-447b-94cf-293b5ec434dd", where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is the objectId of the member (user, application, servicePrincipal, group) to be added.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> addMemberWithServiceResponseAsync(String groupObjectId, String url) {
        if (groupObjectId == null) {
            throw new IllegalArgumentException("Parameter groupObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (url == null) {
            throw new IllegalArgumentException("Parameter url is required and cannot be null.");
        }
        GroupAddMemberParameters parameters = new GroupAddMemberParameters();
        parameters.withUrl(url);
        return service.addMember(groupObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = addMemberDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> addMemberDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Delete a group from the directory.
     *
     * @param groupObjectId The object ID of the group to delete.
     */
    public void delete(String groupObjectId) {
        deleteWithServiceResponseAsync(groupObjectId).toBlocking().single().body();
    }

    /**
     * Delete a group from the directory.
     *
     * @param groupObjectId The object ID of the group to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> deleteAsync(String groupObjectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(deleteWithServiceResponseAsync(groupObjectId), serviceCallback);
    }

    /**
     * Delete a group from the directory.
     *
     * @param groupObjectId The object ID of the group to delete.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String groupObjectId) {
        return deleteWithServiceResponseAsync(groupObjectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a group from the directory.
     *
     * @param groupObjectId The object ID of the group to delete.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String groupObjectId) {
        if (groupObjectId == null) {
            throw new IllegalArgumentException("Parameter groupObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(groupObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Create a group in the directory.
     *
     * @param parameters The parameters for the group to create.
     * @return the ADGroupInner object if successful.
     */
    public ADGroupInner create(GroupCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).toBlocking().single().body();
    }

    /**
     * Create a group in the directory.
     *
     * @param parameters The parameters for the group to create.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<ADGroupInner> createAsync(GroupCreateParametersInner parameters, final ServiceCallback<ADGroupInner> serviceCallback) {
        return ServiceCall.fromResponse(createWithServiceResponseAsync(parameters), serviceCallback);
    }

    /**
     * Create a group in the directory.
     *
     * @param parameters The parameters for the group to create.
     * @return the observable to the ADGroupInner object
     */
    public Observable<ADGroupInner> createAsync(GroupCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).map(new Func1<ServiceResponse<ADGroupInner>, ADGroupInner>() {
            @Override
            public ADGroupInner call(ServiceResponse<ADGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create a group in the directory.
     *
     * @param parameters The parameters for the group to create.
     * @return the observable to the ADGroupInner object
     */
    public Observable<ServiceResponse<ADGroupInner>> createWithServiceResponseAsync(GroupCreateParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.create(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ADGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<ADGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ADGroupInner> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ADGroupInner> createDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ADGroupInner, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<ADGroupInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets list of groups for the current tenant.
     *
     * @return the PagedList&lt;ADGroupInner&gt; object if successful.
     */
    public PagedList<ADGroupInner> list() {
        ServiceResponse<Page<ADGroupInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<ADGroupInner>(response.body()) {
            @Override
            public Page<ADGroupInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets list of groups for the current tenant.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ADGroupInner>> listAsync(final ListOperationCallback<ADGroupInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ADGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ADGroupInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets list of groups for the current tenant.
     *
     * @return the observable to the PagedList&lt;ADGroupInner&gt; object
     */
    public Observable<Page<ADGroupInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ADGroupInner>>, Page<ADGroupInner>>() {
                @Override
                public Page<ADGroupInner> call(ServiceResponse<Page<ADGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets list of groups for the current tenant.
     *
     * @return the observable to the PagedList&lt;ADGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<ADGroupInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ADGroupInner>>, Observable<ServiceResponse<Page<ADGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ADGroupInner>>> call(ServiceResponse<Page<ADGroupInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets list of groups for the current tenant.
     *
     * @return the PagedList&lt;ADGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ADGroupInner>>> listSinglePageAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ADGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ADGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ADGroupInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ADGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets list of groups for the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @return the PagedList&lt;ADGroupInner&gt; object if successful.
     */
    public PagedList<ADGroupInner> list(final String filter) {
        ServiceResponse<Page<ADGroupInner>> response = listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<ADGroupInner>(response.body()) {
            @Override
            public Page<ADGroupInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets list of groups for the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ADGroupInner>> listAsync(final String filter, final ListOperationCallback<ADGroupInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listSinglePageAsync(filter),
            new Func1<String, Observable<ServiceResponse<Page<ADGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ADGroupInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets list of groups for the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @return the observable to the PagedList&lt;ADGroupInner&gt; object
     */
    public Observable<Page<ADGroupInner>> listAsync(final String filter) {
        return listWithServiceResponseAsync(filter)
            .map(new Func1<ServiceResponse<Page<ADGroupInner>>, Page<ADGroupInner>>() {
                @Override
                public Page<ADGroupInner> call(ServiceResponse<Page<ADGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets list of groups for the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @return the observable to the PagedList&lt;ADGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<ADGroupInner>>> listWithServiceResponseAsync(final String filter) {
        return listSinglePageAsync(filter)
            .concatMap(new Func1<ServiceResponse<Page<ADGroupInner>>, Observable<ServiceResponse<Page<ADGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ADGroupInner>>> call(ServiceResponse<Page<ADGroupInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets list of groups for the current tenant.
     *
    ServiceResponse<PageImpl<ADGroupInner>> * @param filter The filter to apply to the operation.
     * @return the PagedList&lt;ADGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ADGroupInner>>> listSinglePageAsync(final String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ADGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ADGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ADGroupInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ADGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ADGroupInner>> listDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ADGroupInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ADGroupInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets the members of a group.
     *
     * @param objectId The object ID of the group whose members should be retrieved.
     * @return the PagedList&lt;AADObjectInner&gt; object if successful.
     */
    public PagedList<AADObjectInner> getGroupMembers(final String objectId) {
        ServiceResponse<Page<AADObjectInner>> response = getGroupMembersSinglePageAsync(objectId).toBlocking().single();
        return new PagedList<AADObjectInner>(response.body()) {
            @Override
            public Page<AADObjectInner> nextPage(String nextLink) {
                return getGroupMembersNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the members of a group.
     *
     * @param objectId The object ID of the group whose members should be retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<AADObjectInner>> getGroupMembersAsync(final String objectId, final ListOperationCallback<AADObjectInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            getGroupMembersSinglePageAsync(objectId),
            new Func1<String, Observable<ServiceResponse<Page<AADObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AADObjectInner>>> call(String nextLink) {
                    return getGroupMembersNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the members of a group.
     *
     * @param objectId The object ID of the group whose members should be retrieved.
     * @return the observable to the PagedList&lt;AADObjectInner&gt; object
     */
    public Observable<Page<AADObjectInner>> getGroupMembersAsync(final String objectId) {
        return getGroupMembersWithServiceResponseAsync(objectId)
            .map(new Func1<ServiceResponse<Page<AADObjectInner>>, Page<AADObjectInner>>() {
                @Override
                public Page<AADObjectInner> call(ServiceResponse<Page<AADObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the members of a group.
     *
     * @param objectId The object ID of the group whose members should be retrieved.
     * @return the observable to the PagedList&lt;AADObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<AADObjectInner>>> getGroupMembersWithServiceResponseAsync(final String objectId) {
        return getGroupMembersSinglePageAsync(objectId)
            .concatMap(new Func1<ServiceResponse<Page<AADObjectInner>>, Observable<ServiceResponse<Page<AADObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AADObjectInner>>> call(ServiceResponse<Page<AADObjectInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(getGroupMembersNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets the members of a group.
     *
    ServiceResponse<PageImpl<AADObjectInner>> * @param objectId The object ID of the group whose members should be retrieved.
     * @return the PagedList&lt;AADObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AADObjectInner>>> getGroupMembersSinglePageAsync(final String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getGroupMembers(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AADObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AADObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AADObjectInner>> result = getGroupMembersDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AADObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AADObjectInner>> getGroupMembersDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AADObjectInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AADObjectInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets group information from the directory.
     *
     * @param objectId The object ID of the user for which to get group information.
     * @return the ADGroupInner object if successful.
     */
    public ADGroupInner get(String objectId) {
        return getWithServiceResponseAsync(objectId).toBlocking().single().body();
    }

    /**
     * Gets group information from the directory.
     *
     * @param objectId The object ID of the user for which to get group information.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<ADGroupInner> getAsync(String objectId, final ServiceCallback<ADGroupInner> serviceCallback) {
        return ServiceCall.fromResponse(getWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Gets group information from the directory.
     *
     * @param objectId The object ID of the user for which to get group information.
     * @return the observable to the ADGroupInner object
     */
    public Observable<ADGroupInner> getAsync(String objectId) {
        return getWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<ADGroupInner>, ADGroupInner>() {
            @Override
            public ADGroupInner call(ServiceResponse<ADGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets group information from the directory.
     *
     * @param objectId The object ID of the user for which to get group information.
     * @return the observable to the ADGroupInner object
     */
    public Observable<ServiceResponse<ADGroupInner>> getWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ADGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<ADGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ADGroupInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ADGroupInner> getDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ADGroupInner, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ADGroupInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets a collection of object IDs of groups of which the specified group is a member.
     *
     * @param objectId The object ID of the group for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
     * @return the List&lt;String&gt; object if successful.
     */
    public List<String> getMemberGroups(String objectId, boolean securityEnabledOnly) {
        return getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly).toBlocking().single().body();
    }

    /**
     * Gets a collection of object IDs of groups of which the specified group is a member.
     *
     * @param objectId The object ID of the group for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<String>> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly, final ServiceCallback<List<String>> serviceCallback) {
        return ServiceCall.fromResponse(getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly), serviceCallback);
    }

    /**
     * Gets a collection of object IDs of groups of which the specified group is a member.
     *
     * @param objectId The object ID of the group for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
     * @return the observable to the List&lt;String&gt; object
     */
    public Observable<List<String>> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly) {
        return getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly).map(new Func1<ServiceResponse<List<String>>, List<String>>() {
            @Override
            public List<String> call(ServiceResponse<List<String>> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a collection of object IDs of groups of which the specified group is a member.
     *
     * @param objectId The object ID of the group for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
     * @return the observable to the List&lt;String&gt; object
     */
    public Observable<ServiceResponse<List<String>>> getMemberGroupsWithServiceResponseAsync(String objectId, boolean securityEnabledOnly) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        GroupGetMemberGroupsParameters parameters = new GroupGetMemberGroupsParameters();
        parameters.withSecurityEnabledOnly(securityEnabledOnly);
        return service.getMemberGroups(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<String>>>>() {
                @Override
                public Observable<ServiceResponse<List<String>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<String>> result = getMemberGroupsDelegate(response);
                        ServiceResponse<List<String>> clientResponse = new ServiceResponse<List<String>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<String>> getMemberGroupsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<String>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<String>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets a list of groups for the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the PagedList&lt;ADGroupInner&gt; object if successful.
     */
    public PagedList<ADGroupInner> listNext(final String nextLink) {
        ServiceResponse<Page<ADGroupInner>> response = listNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<ADGroupInner>(response.body()) {
            @Override
            public Page<ADGroupInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of groups for the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @param serviceCall the ServiceCall object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ADGroupInner>> listNextAsync(final String nextLink, final ServiceCall<List<ADGroupInner>> serviceCall, final ListOperationCallback<ADGroupInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listNextSinglePageAsync(nextLink),
            new Func1<String, Observable<ServiceResponse<Page<ADGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ADGroupInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of groups for the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the observable to the PagedList&lt;ADGroupInner&gt; object
     */
    public Observable<Page<ADGroupInner>> listNextAsync(final String nextLink) {
        return listNextWithServiceResponseAsync(nextLink)
            .map(new Func1<ServiceResponse<Page<ADGroupInner>>, Page<ADGroupInner>>() {
                @Override
                public Page<ADGroupInner> call(ServiceResponse<Page<ADGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of groups for the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the observable to the PagedList&lt;ADGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<ADGroupInner>>> listNextWithServiceResponseAsync(final String nextLink) {
        return listNextSinglePageAsync(nextLink)
            .concatMap(new Func1<ServiceResponse<Page<ADGroupInner>>, Observable<ServiceResponse<Page<ADGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ADGroupInner>>> call(ServiceResponse<Page<ADGroupInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets a list of groups for the current tenant.
     *
    ServiceResponse<PageImpl<ADGroupInner>> * @param nextLink Next link for the list operation.
     * @return the PagedList&lt;ADGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ADGroupInner>>> listNextSinglePageAsync(final String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return service.listNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ADGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ADGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ADGroupInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ADGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ADGroupInner>> listNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ADGroupInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ADGroupInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets the members of a group.
     *
     * @param nextLink Next link for the list operation.
     * @return the PagedList&lt;AADObjectInner&gt; object if successful.
     */
    public PagedList<AADObjectInner> getGroupMembersNext(final String nextLink) {
        ServiceResponse<Page<AADObjectInner>> response = getGroupMembersNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<AADObjectInner>(response.body()) {
            @Override
            public Page<AADObjectInner> nextPage(String nextLink) {
                return getGroupMembersNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the members of a group.
     *
     * @param nextLink Next link for the list operation.
     * @param serviceCall the ServiceCall object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<AADObjectInner>> getGroupMembersNextAsync(final String nextLink, final ServiceCall<List<AADObjectInner>> serviceCall, final ListOperationCallback<AADObjectInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            getGroupMembersNextSinglePageAsync(nextLink),
            new Func1<String, Observable<ServiceResponse<Page<AADObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AADObjectInner>>> call(String nextLink) {
                    return getGroupMembersNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the members of a group.
     *
     * @param nextLink Next link for the list operation.
     * @return the observable to the PagedList&lt;AADObjectInner&gt; object
     */
    public Observable<Page<AADObjectInner>> getGroupMembersNextAsync(final String nextLink) {
        return getGroupMembersNextWithServiceResponseAsync(nextLink)
            .map(new Func1<ServiceResponse<Page<AADObjectInner>>, Page<AADObjectInner>>() {
                @Override
                public Page<AADObjectInner> call(ServiceResponse<Page<AADObjectInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the members of a group.
     *
     * @param nextLink Next link for the list operation.
     * @return the observable to the PagedList&lt;AADObjectInner&gt; object
     */
    public Observable<ServiceResponse<Page<AADObjectInner>>> getGroupMembersNextWithServiceResponseAsync(final String nextLink) {
        return getGroupMembersNextSinglePageAsync(nextLink)
            .concatMap(new Func1<ServiceResponse<Page<AADObjectInner>>, Observable<ServiceResponse<Page<AADObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AADObjectInner>>> call(ServiceResponse<Page<AADObjectInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(getGroupMembersNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets the members of a group.
     *
    ServiceResponse<PageImpl<AADObjectInner>> * @param nextLink Next link for the list operation.
     * @return the PagedList&lt;AADObjectInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AADObjectInner>>> getGroupMembersNextSinglePageAsync(final String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return service.getGroupMembersNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AADObjectInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AADObjectInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AADObjectInner>> result = getGroupMembersNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AADObjectInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AADObjectInner>> getGroupMembersNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AADObjectInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AADObjectInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

}
