/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.KeyCredentialsUpdateParameters;
import com.microsoft.azure.management.graphrbac.PasswordCredentialsUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ServicePrincipals.
 */
public final class ServicePrincipalsInner {
    /** The Retrofit service to perform REST calls. */
    private ServicePrincipalsService service;
    /** The service client containing this operation class. */
    private GraphRbacManagementClientImpl client;

    /**
     * Initializes an instance of ServicePrincipalsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ServicePrincipalsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = retrofit.create(ServicePrincipalsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ServicePrincipals to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ServicePrincipalsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals create" })
        @POST("{tenantID}/servicePrincipals")
        Observable<Response<ResponseBody>> create(@Path("tenantID") String tenantID, @Body ServicePrincipalCreateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals list" })
        @GET("{tenantID}/servicePrincipals")
        Observable<Response<ResponseBody>> list(@Path("tenantID") String tenantID, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals delete" })
        @HTTP(path = "{tenantID}/servicePrincipals/{objectId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals get" })
        @GET("{tenantID}/servicePrincipals/{objectId}")
        Observable<Response<ResponseBody>> get(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals listKeyCredentials" })
        @GET("{tenantID}/servicePrincipals/{objectId}/keyCredentials")
        Observable<Response<ResponseBody>> listKeyCredentials(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals updateKeyCredentials" })
        @PATCH("{tenantID}/servicePrincipals/{objectId}/keyCredentials")
        Observable<Response<ResponseBody>> updateKeyCredentials(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body KeyCredentialsUpdateParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals listPasswordCredentials" })
        @GET("{tenantID}/servicePrincipals/{objectId}/passwordCredentials")
        Observable<Response<ResponseBody>> listPasswordCredentials(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals updatePasswordCredentials" })
        @PATCH("{tenantID}/servicePrincipals/{objectId}/passwordCredentials")
        Observable<Response<ResponseBody>> updatePasswordCredentials(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body PasswordCredentialsUpdateParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Parameters to create a service principal.
     * @return the ServicePrincipalInner object if successful.
     */
    public ServicePrincipalInner create(ServicePrincipalCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).toBlocking().single().body();
    }

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Parameters to create a service principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<ServicePrincipalInner> createAsync(ServicePrincipalCreateParametersInner parameters, final ServiceCallback<ServicePrincipalInner> serviceCallback) {
        return ServiceCall.fromResponse(createWithServiceResponseAsync(parameters), serviceCallback);
    }

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Parameters to create a service principal.
     * @return the observable to the ServicePrincipalInner object
     */
    public Observable<ServicePrincipalInner> createAsync(ServicePrincipalCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).map(new Func1<ServiceResponse<ServicePrincipalInner>, ServicePrincipalInner>() {
            @Override
            public ServicePrincipalInner call(ServiceResponse<ServicePrincipalInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Parameters to create a service principal.
     * @return the observable to the ServicePrincipalInner object
     */
    public Observable<ServiceResponse<ServicePrincipalInner>> createWithServiceResponseAsync(ServicePrincipalCreateParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.create(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServicePrincipalInner>>>() {
                @Override
                public Observable<ServiceResponse<ServicePrincipalInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServicePrincipalInner> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServicePrincipalInner> createDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServicePrincipalInner, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<ServicePrincipalInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @return the PagedList&lt;ServicePrincipalInner&gt; object if successful.
     */
    public PagedList<ServicePrincipalInner> list() {
        ServiceResponse<Page<ServicePrincipalInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<ServicePrincipalInner>(response.body()) {
            @Override
            public Page<ServicePrincipalInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ServicePrincipalInner>> listAsync(final ListOperationCallback<ServicePrincipalInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<Page<ServicePrincipalInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Page<ServicePrincipalInner>>() {
                @Override
                public Page<ServicePrincipalInner> call(ServiceResponse<Page<ServicePrincipalInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(ServiceResponse<Page<ServicePrincipalInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @return the PagedList&lt;ServicePrincipalInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listSinglePageAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ServicePrincipalInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServicePrincipalInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @return the PagedList&lt;ServicePrincipalInner&gt; object if successful.
     */
    public PagedList<ServicePrincipalInner> list(final String filter) {
        ServiceResponse<Page<ServicePrincipalInner>> response = listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<ServicePrincipalInner>(response.body()) {
            @Override
            public Page<ServicePrincipalInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ServicePrincipalInner>> listAsync(final String filter, final ListOperationCallback<ServicePrincipalInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listSinglePageAsync(filter),
            new Func1<String, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<Page<ServicePrincipalInner>> listAsync(final String filter) {
        return listWithServiceResponseAsync(filter)
            .map(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Page<ServicePrincipalInner>>() {
                @Override
                public Page<ServicePrincipalInner> call(ServiceResponse<Page<ServicePrincipalInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listWithServiceResponseAsync(final String filter) {
        return listSinglePageAsync(filter)
            .concatMap(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(ServiceResponse<Page<ServicePrincipalInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
    ServiceResponse<PageImpl<ServicePrincipalInner>> * @param filter The filter to apply to the operation.
     * @return the PagedList&lt;ServicePrincipalInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listSinglePageAsync(final String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ServicePrincipalInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServicePrincipalInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ServicePrincipalInner>> listDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ServicePrincipalInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ServicePrincipalInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     */
    public void delete(String objectId) {
        deleteWithServiceResponseAsync(objectId).toBlocking().single().body();
    }

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> deleteAsync(String objectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(deleteWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String objectId) {
        return deleteWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets service principal information from the directory.
     *
     * @param objectId The object ID of the service principal to get.
     * @return the ServicePrincipalInner object if successful.
     */
    public ServicePrincipalInner get(String objectId) {
        return getWithServiceResponseAsync(objectId).toBlocking().single().body();
    }

    /**
     * Gets service principal information from the directory.
     *
     * @param objectId The object ID of the service principal to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<ServicePrincipalInner> getAsync(String objectId, final ServiceCallback<ServicePrincipalInner> serviceCallback) {
        return ServiceCall.fromResponse(getWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Gets service principal information from the directory.
     *
     * @param objectId The object ID of the service principal to get.
     * @return the observable to the ServicePrincipalInner object
     */
    public Observable<ServicePrincipalInner> getAsync(String objectId) {
        return getWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<ServicePrincipalInner>, ServicePrincipalInner>() {
            @Override
            public ServicePrincipalInner call(ServiceResponse<ServicePrincipalInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets service principal information from the directory.
     *
     * @param objectId The object ID of the service principal to get.
     * @return the observable to the ServicePrincipalInner object
     */
    public Observable<ServiceResponse<ServicePrincipalInner>> getWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServicePrincipalInner>>>() {
                @Override
                public Observable<ServiceResponse<ServicePrincipalInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServicePrincipalInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServicePrincipalInner> getDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServicePrincipalInner, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServicePrincipalInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @return the List&lt;KeyCredentialInner&gt; object if successful.
     */
    public List<KeyCredentialInner> listKeyCredentials(String objectId) {
        return listKeyCredentialsWithServiceResponseAsync(objectId).toBlocking().single().body();
    }

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<KeyCredentialInner>> listKeyCredentialsAsync(String objectId, final ServiceCallback<List<KeyCredentialInner>> serviceCallback) {
        return ServiceCall.fromResponse(listKeyCredentialsWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @return the observable to the List&lt;KeyCredentialInner&gt; object
     */
    public Observable<List<KeyCredentialInner>> listKeyCredentialsAsync(String objectId) {
        return listKeyCredentialsWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<List<KeyCredentialInner>>, List<KeyCredentialInner>>() {
            @Override
            public List<KeyCredentialInner> call(ServiceResponse<List<KeyCredentialInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @return the observable to the List&lt;KeyCredentialInner&gt; object
     */
    public Observable<ServiceResponse<List<KeyCredentialInner>>> listKeyCredentialsWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listKeyCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<KeyCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<KeyCredentialInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<KeyCredentialInner>> result = listKeyCredentialsDelegate(response);
                        ServiceResponse<List<KeyCredentialInner>> clientResponse = new ServiceResponse<List<KeyCredentialInner>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<KeyCredentialInner>> listKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<KeyCredentialInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<KeyCredentialInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     */
    public void updateKeyCredentials(String objectId, List<KeyCredentialInner> value) {
        updateKeyCredentialsWithServiceResponseAsync(objectId, value).toBlocking().single().body();
    }

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updateKeyCredentialsAsync(String objectId, List<KeyCredentialInner> value, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(updateKeyCredentialsWithServiceResponseAsync(objectId, value), serviceCallback);
    }

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updateKeyCredentialsAsync(String objectId, List<KeyCredentialInner> value) {
        return updateKeyCredentialsWithServiceResponseAsync(objectId, value).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updateKeyCredentialsWithServiceResponseAsync(String objectId, List<KeyCredentialInner> value) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(value);
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        return service.updateKeyCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updateKeyCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updateKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @return the List&lt;PasswordCredentialInner&gt; object if successful.
     */
    public List<PasswordCredentialInner> listPasswordCredentials(String objectId) {
        return listPasswordCredentialsWithServiceResponseAsync(objectId).toBlocking().single().body();
    }

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String objectId, final ServiceCallback<List<PasswordCredentialInner>> serviceCallback) {
        return ServiceCall.fromResponse(listPasswordCredentialsWithServiceResponseAsync(objectId), serviceCallback);
    }

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @return the observable to the List&lt;PasswordCredentialInner&gt; object
     */
    public Observable<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String objectId) {
        return listPasswordCredentialsWithServiceResponseAsync(objectId).map(new Func1<ServiceResponse<List<PasswordCredentialInner>>, List<PasswordCredentialInner>>() {
            @Override
            public List<PasswordCredentialInner> call(ServiceResponse<List<PasswordCredentialInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @return the observable to the List&lt;PasswordCredentialInner&gt; object
     */
    public Observable<ServiceResponse<List<PasswordCredentialInner>>> listPasswordCredentialsWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listPasswordCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<PasswordCredentialInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<PasswordCredentialInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<PasswordCredentialInner>> result = listPasswordCredentialsDelegate(response);
                        ServiceResponse<List<PasswordCredentialInner>> clientResponse = new ServiceResponse<List<PasswordCredentialInner>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<PasswordCredentialInner>> listPasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<PasswordCredentialInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<PasswordCredentialInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     */
    public void updatePasswordCredentials(String objectId, List<PasswordCredentialInner> value) {
        updatePasswordCredentialsWithServiceResponseAsync(objectId, value).toBlocking().single().body();
    }

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updatePasswordCredentialsAsync(String objectId, List<PasswordCredentialInner> value, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(updatePasswordCredentialsWithServiceResponseAsync(objectId, value), serviceCallback);
    }

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updatePasswordCredentialsAsync(String objectId, List<PasswordCredentialInner> value) {
        return updatePasswordCredentialsWithServiceResponseAsync(objectId, value).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updatePasswordCredentialsWithServiceResponseAsync(String objectId, List<PasswordCredentialInner> value) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(value);
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        return service.updatePasswordCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updatePasswordCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updatePasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the PagedList&lt;ServicePrincipalInner&gt; object if successful.
     */
    public PagedList<ServicePrincipalInner> listNext(final String nextLink) {
        ServiceResponse<Page<ServicePrincipalInner>> response = listNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<ServicePrincipalInner>(response.body()) {
            @Override
            public Page<ServicePrincipalInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @param serviceCall the ServiceCall object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<ServicePrincipalInner>> listNextAsync(final String nextLink, final ServiceCall<List<ServicePrincipalInner>> serviceCall, final ListOperationCallback<ServicePrincipalInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listNextSinglePageAsync(nextLink),
            new Func1<String, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<Page<ServicePrincipalInner>> listNextAsync(final String nextLink) {
        return listNextWithServiceResponseAsync(nextLink)
            .map(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Page<ServicePrincipalInner>>() {
                @Override
                public Page<ServicePrincipalInner> call(ServiceResponse<Page<ServicePrincipalInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the observable to the PagedList&lt;ServicePrincipalInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listNextWithServiceResponseAsync(final String nextLink) {
        return listNextSinglePageAsync(nextLink)
            .concatMap(new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(ServiceResponse<Page<ServicePrincipalInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
    ServiceResponse<PageImpl<ServicePrincipalInner>> * @param nextLink Next link for the list operation.
     * @return the PagedList&lt;ServicePrincipalInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listNextSinglePageAsync(final String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return service.listNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ServicePrincipalInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServicePrincipalInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ServicePrincipalInner>> listNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ServicePrincipalInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ServicePrincipalInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

}
