/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.UserGetMemberGroupsParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Users.
 */
public final class UsersInner {
    /** The Retrofit service to perform REST calls. */
    private UsersService service;
    /** The service client containing this operation class. */
    private GraphRbacManagementClientImpl client;

    /**
     * Initializes an instance of UsersInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public UsersInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = retrofit.create(UsersService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Users to be
     * used by Retrofit to perform actually REST calls.
     */
    interface UsersService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users create" })
        @POST("{tenantID}/users")
        Observable<Response<ResponseBody>> create(@Path("tenantID") String tenantID, @Body UserCreateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users list" })
        @GET("{tenantID}/users")
        Observable<Response<ResponseBody>> list(@Path("tenantID") String tenantID, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users get" })
        @GET("{tenantID}/users/{upnOrObjectId}")
        Observable<Response<ResponseBody>> get(@Path(value = "upnOrObjectId", encoded = true) String upnOrObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users update" })
        @PATCH("{tenantID}/users/{upnOrObjectId}")
        Observable<Response<ResponseBody>> update(@Path(value = "upnOrObjectId", encoded = true) String upnOrObjectId, @Path("tenantID") String tenantID, @Body UserUpdateParametersInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users delete" })
        @HTTP(path = "{tenantID}/users/{upnOrObjectId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path(value = "upnOrObjectId", encoded = true) String upnOrObjectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users getMemberGroups" })
        @POST("{tenantID}/users/{objectId}/getMemberGroups")
        Observable<Response<ResponseBody>> getMemberGroups(@Path(value = "objectId", encoded = true) String objectId, @Path("tenantID") String tenantID, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body UserGetMemberGroupsParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Users listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Create a new user.
     *
     * @param parameters Parameters to create a user.
     * @return the UserInner object if successful.
     */
    public UserInner create(UserCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).toBlocking().single().body();
    }

    /**
     * Create a new user.
     *
     * @param parameters Parameters to create a user.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<UserInner> createAsync(UserCreateParametersInner parameters, final ServiceCallback<UserInner> serviceCallback) {
        return ServiceCall.fromResponse(createWithServiceResponseAsync(parameters), serviceCallback);
    }

    /**
     * Create a new user.
     *
     * @param parameters Parameters to create a user.
     * @return the observable to the UserInner object
     */
    public Observable<UserInner> createAsync(UserCreateParametersInner parameters) {
        return createWithServiceResponseAsync(parameters).map(new Func1<ServiceResponse<UserInner>, UserInner>() {
            @Override
            public UserInner call(ServiceResponse<UserInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create a new user.
     *
     * @param parameters Parameters to create a user.
     * @return the observable to the UserInner object
     */
    public Observable<ServiceResponse<UserInner>> createWithServiceResponseAsync(UserCreateParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.create(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserInner>>>() {
                @Override
                public Observable<ServiceResponse<UserInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<UserInner> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<UserInner> createDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<UserInner, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<UserInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets list of users for the current tenant.
     *
     * @return the PagedList&lt;UserInner&gt; object if successful.
     */
    public PagedList<UserInner> list() {
        ServiceResponse<Page<UserInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<UserInner>(response.body()) {
            @Override
            public Page<UserInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets list of users for the current tenant.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<UserInner>> listAsync(final ListOperationCallback<UserInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<UserInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UserInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets list of users for the current tenant.
     *
     * @return the observable to the PagedList&lt;UserInner&gt; object
     */
    public Observable<Page<UserInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<UserInner>>, Page<UserInner>>() {
                @Override
                public Page<UserInner> call(ServiceResponse<Page<UserInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets list of users for the current tenant.
     *
     * @return the observable to the PagedList&lt;UserInner&gt; object
     */
    public Observable<ServiceResponse<Page<UserInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<UserInner>>, Observable<ServiceResponse<Page<UserInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UserInner>>> call(ServiceResponse<Page<UserInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets list of users for the current tenant.
     *
     * @return the PagedList&lt;UserInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<UserInner>>> listSinglePageAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UserInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UserInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UserInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<UserInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets list of users for the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @return the PagedList&lt;UserInner&gt; object if successful.
     */
    public PagedList<UserInner> list(final String filter) {
        ServiceResponse<Page<UserInner>> response = listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<UserInner>(response.body()) {
            @Override
            public Page<UserInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets list of users for the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<UserInner>> listAsync(final String filter, final ListOperationCallback<UserInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listSinglePageAsync(filter),
            new Func1<String, Observable<ServiceResponse<Page<UserInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UserInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets list of users for the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @return the observable to the PagedList&lt;UserInner&gt; object
     */
    public Observable<Page<UserInner>> listAsync(final String filter) {
        return listWithServiceResponseAsync(filter)
            .map(new Func1<ServiceResponse<Page<UserInner>>, Page<UserInner>>() {
                @Override
                public Page<UserInner> call(ServiceResponse<Page<UserInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets list of users for the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @return the observable to the PagedList&lt;UserInner&gt; object
     */
    public Observable<ServiceResponse<Page<UserInner>>> listWithServiceResponseAsync(final String filter) {
        return listSinglePageAsync(filter)
            .concatMap(new Func1<ServiceResponse<Page<UserInner>>, Observable<ServiceResponse<Page<UserInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UserInner>>> call(ServiceResponse<Page<UserInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets list of users for the current tenant.
     *
    ServiceResponse<PageImpl<UserInner>> * @param filter The filter to apply to the operation.
     * @return the PagedList&lt;UserInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<UserInner>>> listSinglePageAsync(final String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UserInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UserInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UserInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<UserInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<UserInner>> listDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<UserInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<UserInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets user information from the directory.
     *
     * @param upnOrObjectId The object ID or principal name of the user for which to get information.
     * @return the UserInner object if successful.
     */
    public UserInner get(String upnOrObjectId) {
        return getWithServiceResponseAsync(upnOrObjectId).toBlocking().single().body();
    }

    /**
     * Gets user information from the directory.
     *
     * @param upnOrObjectId The object ID or principal name of the user for which to get information.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<UserInner> getAsync(String upnOrObjectId, final ServiceCallback<UserInner> serviceCallback) {
        return ServiceCall.fromResponse(getWithServiceResponseAsync(upnOrObjectId), serviceCallback);
    }

    /**
     * Gets user information from the directory.
     *
     * @param upnOrObjectId The object ID or principal name of the user for which to get information.
     * @return the observable to the UserInner object
     */
    public Observable<UserInner> getAsync(String upnOrObjectId) {
        return getWithServiceResponseAsync(upnOrObjectId).map(new Func1<ServiceResponse<UserInner>, UserInner>() {
            @Override
            public UserInner call(ServiceResponse<UserInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets user information from the directory.
     *
     * @param upnOrObjectId The object ID or principal name of the user for which to get information.
     * @return the observable to the UserInner object
     */
    public Observable<ServiceResponse<UserInner>> getWithServiceResponseAsync(String upnOrObjectId) {
        if (upnOrObjectId == null) {
            throw new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(upnOrObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserInner>>>() {
                @Override
                public Observable<ServiceResponse<UserInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<UserInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<UserInner> getDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<UserInner, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<UserInner>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Updates a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to update.
     * @param parameters Parameters to update an existing user.
     */
    public void update(String upnOrObjectId, UserUpdateParametersInner parameters) {
        updateWithServiceResponseAsync(upnOrObjectId, parameters).toBlocking().single().body();
    }

    /**
     * Updates a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to update.
     * @param parameters Parameters to update an existing user.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> updateAsync(String upnOrObjectId, UserUpdateParametersInner parameters, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(updateWithServiceResponseAsync(upnOrObjectId, parameters), serviceCallback);
    }

    /**
     * Updates a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to update.
     * @param parameters Parameters to update an existing user.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> updateAsync(String upnOrObjectId, UserUpdateParametersInner parameters) {
        return updateWithServiceResponseAsync(upnOrObjectId, parameters).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to update.
     * @param parameters Parameters to update an existing user.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> updateWithServiceResponseAsync(String upnOrObjectId, UserUpdateParametersInner parameters) {
        if (upnOrObjectId == null) {
            throw new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.update(upnOrObjectId, this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> updateDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Delete a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to delete.
     */
    public void delete(String upnOrObjectId) {
        deleteWithServiceResponseAsync(upnOrObjectId).toBlocking().single().body();
    }

    /**
     * Delete a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<Void> deleteAsync(String upnOrObjectId, final ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(deleteWithServiceResponseAsync(upnOrObjectId), serviceCallback);
    }

    /**
     * Delete a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to delete.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String upnOrObjectId) {
        return deleteWithServiceResponseAsync(upnOrObjectId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to delete.
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String upnOrObjectId) {
        if (upnOrObjectId == null) {
            throw new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(upnOrObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets a collection that contains the object IDs of the groups of which the user is a member.
     *
     * @param objectId The object ID of the user for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
     * @return the List&lt;String&gt; object if successful.
     */
    public List<String> getMemberGroups(String objectId, boolean securityEnabledOnly) {
        return getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly).toBlocking().single().body();
    }

    /**
     * Gets a collection that contains the object IDs of the groups of which the user is a member.
     *
     * @param objectId The object ID of the user for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<String>> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly, final ServiceCallback<List<String>> serviceCallback) {
        return ServiceCall.fromResponse(getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly), serviceCallback);
    }

    /**
     * Gets a collection that contains the object IDs of the groups of which the user is a member.
     *
     * @param objectId The object ID of the user for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
     * @return the observable to the List&lt;String&gt; object
     */
    public Observable<List<String>> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly) {
        return getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly).map(new Func1<ServiceResponse<List<String>>, List<String>>() {
            @Override
            public List<String> call(ServiceResponse<List<String>> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a collection that contains the object IDs of the groups of which the user is a member.
     *
     * @param objectId The object ID of the user for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
     * @return the observable to the List&lt;String&gt; object
     */
    public Observable<ServiceResponse<List<String>>> getMemberGroupsWithServiceResponseAsync(String objectId, boolean securityEnabledOnly) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UserGetMemberGroupsParameters parameters = new UserGetMemberGroupsParameters();
        parameters.withSecurityEnabledOnly(securityEnabledOnly);
        return service.getMemberGroups(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<String>>>>() {
                @Override
                public Observable<ServiceResponse<List<String>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<String>> result = getMemberGroupsDelegate(response);
                        ServiceResponse<List<String>> clientResponse = new ServiceResponse<List<String>>(result.body().items(), result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<String>> getMemberGroupsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<String>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<String>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

    /**
     * Gets a list of users for the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the PagedList&lt;UserInner&gt; object if successful.
     */
    public PagedList<UserInner> listNext(final String nextLink) {
        ServiceResponse<Page<UserInner>> response = listNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<UserInner>(response.body()) {
            @Override
            public Page<UserInner> nextPage(String nextLink) {
                return listNextSinglePageAsync(nextLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of users for the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @param serviceCall the ServiceCall object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @return the {@link ServiceCall} object
     */
    public ServiceCall<List<UserInner>> listNextAsync(final String nextLink, final ServiceCall<List<UserInner>> serviceCall, final ListOperationCallback<UserInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(
            listNextSinglePageAsync(nextLink),
            new Func1<String, Observable<ServiceResponse<Page<UserInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UserInner>>> call(String nextLink) {
                    return listNextSinglePageAsync(nextLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of users for the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the observable to the PagedList&lt;UserInner&gt; object
     */
    public Observable<Page<UserInner>> listNextAsync(final String nextLink) {
        return listNextWithServiceResponseAsync(nextLink)
            .map(new Func1<ServiceResponse<Page<UserInner>>, Page<UserInner>>() {
                @Override
                public Page<UserInner> call(ServiceResponse<Page<UserInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of users for the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @return the observable to the PagedList&lt;UserInner&gt; object
     */
    public Observable<ServiceResponse<Page<UserInner>>> listNextWithServiceResponseAsync(final String nextLink) {
        return listNextSinglePageAsync(nextLink)
            .concatMap(new Func1<ServiceResponse<Page<UserInner>>, Observable<ServiceResponse<Page<UserInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UserInner>>> call(ServiceResponse<Page<UserInner>> page) {
                    String nextLink = page.body().nextPageLink();
                    if (nextLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextLink));
                }
            });
    }

    /**
     * Gets a list of users for the current tenant.
     *
    ServiceResponse<PageImpl<UserInner>> * @param nextLink Next link for the list operation.
     * @return the PagedList&lt;UserInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<UserInner>>> listNextSinglePageAsync(final String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return service.listNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UserInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UserInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UserInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<UserInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<UserInner>> listNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<UserInner>, GraphErrorException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<UserInner>>() { }.getType())
                .registerError(GraphErrorException.class)
                .build(response);
    }

}
