/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.GroupAddMemberParameters;
import com.microsoft.azure.management.graphrbac.GroupGetMemberGroupsParameters;
import com.microsoft.azure.management.graphrbac.implementation.AADObjectInner;
import com.microsoft.azure.management.graphrbac.implementation.ADGroupInner;
import com.microsoft.azure.management.graphrbac.implementation.CheckGroupMembershipParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.CheckGroupMembershipResultInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.GroupCreateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl1;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public final class GroupsInner {
    private GroupsService service;
    private GraphRbacManagementClientImpl client;

    public GroupsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = (GroupsService)retrofit.create(GroupsService.class);
        this.client = client;
    }

    public CheckGroupMembershipResultInner isMemberOf(CheckGroupMembershipParametersInner parameters) {
        return (CheckGroupMembershipResultInner)((ServiceResponse)this.isMemberOfWithServiceResponseAsync(parameters).toBlocking().single()).body();
    }

    public ServiceCall<CheckGroupMembershipResultInner> isMemberOfAsync(CheckGroupMembershipParametersInner parameters, ServiceCallback<CheckGroupMembershipResultInner> serviceCallback) {
        return ServiceCall.fromResponse(this.isMemberOfWithServiceResponseAsync(parameters), serviceCallback);
    }

    public Observable<CheckGroupMembershipResultInner> isMemberOfAsync(CheckGroupMembershipParametersInner parameters) {
        return this.isMemberOfWithServiceResponseAsync(parameters).map((Func1)new Func1<ServiceResponse<CheckGroupMembershipResultInner>, CheckGroupMembershipResultInner>(){

            public CheckGroupMembershipResultInner call(ServiceResponse<CheckGroupMembershipResultInner> response) {
                return (CheckGroupMembershipResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckGroupMembershipResultInner>> isMemberOfWithServiceResponseAsync(CheckGroupMembershipParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.isMemberOf(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckGroupMembershipResultInner>>>(){

            public Observable<ServiceResponse<CheckGroupMembershipResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GroupsInner.this.isMemberOfDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckGroupMembershipResultInner> isMemberOfDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CheckGroupMembershipResultInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void removeMember(String groupObjectId, String memberObjectId) {
        ((ServiceResponse)this.removeMemberWithServiceResponseAsync(groupObjectId, memberObjectId).toBlocking().single()).body();
    }

    public ServiceCall<Void> removeMemberAsync(String groupObjectId, String memberObjectId, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(this.removeMemberWithServiceResponseAsync(groupObjectId, memberObjectId), serviceCallback);
    }

    public Observable<Void> removeMemberAsync(String groupObjectId, String memberObjectId) {
        return this.removeMemberWithServiceResponseAsync(groupObjectId, memberObjectId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> removeMemberWithServiceResponseAsync(String groupObjectId, String memberObjectId) {
        if (groupObjectId == null) {
            throw new IllegalArgumentException("Parameter groupObjectId is required and cannot be null.");
        }
        if (memberObjectId == null) {
            throw new IllegalArgumentException("Parameter memberObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.removeMember(groupObjectId, memberObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GroupsInner.this.removeMemberDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> removeMemberDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void addMember(String groupObjectId, String url) {
        ((ServiceResponse)this.addMemberWithServiceResponseAsync(groupObjectId, url).toBlocking().single()).body();
    }

    public ServiceCall<Void> addMemberAsync(String groupObjectId, String url, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(this.addMemberWithServiceResponseAsync(groupObjectId, url), serviceCallback);
    }

    public Observable<Void> addMemberAsync(String groupObjectId, String url) {
        return this.addMemberWithServiceResponseAsync(groupObjectId, url).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> addMemberWithServiceResponseAsync(String groupObjectId, String url) {
        if (groupObjectId == null) {
            throw new IllegalArgumentException("Parameter groupObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (url == null) {
            throw new IllegalArgumentException("Parameter url is required and cannot be null.");
        }
        GroupAddMemberParameters parameters = new GroupAddMemberParameters();
        parameters.withUrl(url);
        return this.service.addMember(groupObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GroupsInner.this.addMemberDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> addMemberDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void delete(String groupObjectId) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(groupObjectId).toBlocking().single()).body();
    }

    public ServiceCall<Void> deleteAsync(String groupObjectId, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(this.deleteWithServiceResponseAsync(groupObjectId), serviceCallback);
    }

    public Observable<Void> deleteAsync(String groupObjectId) {
        return this.deleteWithServiceResponseAsync(groupObjectId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String groupObjectId) {
        if (groupObjectId == null) {
            throw new IllegalArgumentException("Parameter groupObjectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(groupObjectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GroupsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public ADGroupInner create(GroupCreateParametersInner parameters) {
        return (ADGroupInner)((ServiceResponse)this.createWithServiceResponseAsync(parameters).toBlocking().single()).body();
    }

    public ServiceCall<ADGroupInner> createAsync(GroupCreateParametersInner parameters, ServiceCallback<ADGroupInner> serviceCallback) {
        return ServiceCall.fromResponse(this.createWithServiceResponseAsync(parameters), serviceCallback);
    }

    public Observable<ADGroupInner> createAsync(GroupCreateParametersInner parameters) {
        return this.createWithServiceResponseAsync(parameters).map((Func1)new Func1<ServiceResponse<ADGroupInner>, ADGroupInner>(){

            public ADGroupInner call(ServiceResponse<ADGroupInner> response) {
                return (ADGroupInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ADGroupInner>> createWithServiceResponseAsync(GroupCreateParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.create(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ADGroupInner>>>(){

            public Observable<ServiceResponse<ADGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GroupsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ADGroupInner> createDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<ADGroupInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<ADGroupInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ADGroupInner>((Page)response.body()){

            public Page<ADGroupInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)GroupsInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceCall<List<ADGroupInner>> listAsync(ListOperationCallback<ADGroupInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ADGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ADGroupInner>>> call(String nextLink) {
                return GroupsInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ADGroupInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ADGroupInner>>, Page<ADGroupInner>>(){

            public Page<ADGroupInner> call(ServiceResponse<Page<ADGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ADGroupInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ADGroupInner>>, Observable<ServiceResponse<Page<ADGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ADGroupInner>>> call(ServiceResponse<Page<ADGroupInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GroupsInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ADGroupInner>>> listSinglePageAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ADGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ADGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ADGroupInner> list(String filter) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<ADGroupInner>((Page)response.body()){

            public Page<ADGroupInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)GroupsInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceCall<List<ADGroupInner>> listAsync(String filter, ListOperationCallback<ADGroupInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(this.listSinglePageAsync(filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<ADGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ADGroupInner>>> call(String nextLink) {
                return GroupsInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ADGroupInner>> listAsync(String filter) {
        return this.listWithServiceResponseAsync(filter).map((Func1)new Func1<ServiceResponse<Page<ADGroupInner>>, Page<ADGroupInner>>(){

            public Page<ADGroupInner> call(ServiceResponse<Page<ADGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ADGroupInner>>> listWithServiceResponseAsync(String filter) {
        return this.listSinglePageAsync(filter).concatMap((Func1)new Func1<ServiceResponse<Page<ADGroupInner>>, Observable<ServiceResponse<Page<ADGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ADGroupInner>>> call(ServiceResponse<Page<ADGroupInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GroupsInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ADGroupInner>>> listSinglePageAsync(String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ADGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ADGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ADGroupInner>> listDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ADGroupInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<AADObjectInner> getGroupMembers(String objectId) {
        ServiceResponse response = (ServiceResponse)this.getGroupMembersSinglePageAsync(objectId).toBlocking().single();
        return new PagedList<AADObjectInner>((Page)response.body()){

            public Page<AADObjectInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)GroupsInner.this.getGroupMembersNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceCall<List<AADObjectInner>> getGroupMembersAsync(String objectId, ListOperationCallback<AADObjectInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(this.getGroupMembersSinglePageAsync(objectId), (Func1)new Func1<String, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(String nextLink) {
                return GroupsInner.this.getGroupMembersNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AADObjectInner>> getGroupMembersAsync(String objectId) {
        return this.getGroupMembersWithServiceResponseAsync(objectId).map((Func1)new Func1<ServiceResponse<Page<AADObjectInner>>, Page<AADObjectInner>>(){

            public Page<AADObjectInner> call(ServiceResponse<Page<AADObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AADObjectInner>>> getGroupMembersWithServiceResponseAsync(String objectId) {
        return this.getGroupMembersSinglePageAsync(objectId).concatMap((Func1)new Func1<ServiceResponse<Page<AADObjectInner>>, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(ServiceResponse<Page<AADObjectInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GroupsInner.this.getGroupMembersNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AADObjectInner>>> getGroupMembersSinglePageAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getGroupMembers(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GroupsInner.this.getGroupMembersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AADObjectInner>> getGroupMembersDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AADObjectInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public ADGroupInner get(String objectId) {
        return (ADGroupInner)((ServiceResponse)this.getWithServiceResponseAsync(objectId).toBlocking().single()).body();
    }

    public ServiceCall<ADGroupInner> getAsync(String objectId, ServiceCallback<ADGroupInner> serviceCallback) {
        return ServiceCall.fromResponse(this.getWithServiceResponseAsync(objectId), serviceCallback);
    }

    public Observable<ADGroupInner> getAsync(String objectId) {
        return this.getWithServiceResponseAsync(objectId).map((Func1)new Func1<ServiceResponse<ADGroupInner>, ADGroupInner>(){

            public ADGroupInner call(ServiceResponse<ADGroupInner> response) {
                return (ADGroupInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ADGroupInner>> getWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ADGroupInner>>>(){

            public Observable<ServiceResponse<ADGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ADGroupInner> getDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ADGroupInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public List<String> getMemberGroups(String objectId, boolean securityEnabledOnly) {
        return (List)((ServiceResponse)this.getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly).toBlocking().single()).body();
    }

    public ServiceCall<List<String>> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly, ServiceCallback<List<String>> serviceCallback) {
        return ServiceCall.fromResponse(this.getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly), serviceCallback);
    }

    public Observable<List<String>> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly) {
        return this.getMemberGroupsWithServiceResponseAsync(objectId, securityEnabledOnly).map((Func1)new Func1<ServiceResponse<List<String>>, List<String>>(){

            public List<String> call(ServiceResponse<List<String>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<String>>> getMemberGroupsWithServiceResponseAsync(String objectId, boolean securityEnabledOnly) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        GroupGetMemberGroupsParameters parameters = new GroupGetMemberGroupsParameters();
        parameters.withSecurityEnabledOnly(securityEnabledOnly);
        return this.service.getMemberGroups(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<String>>>>(){

            public Observable<ServiceResponse<List<String>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GroupsInner.this.getMemberGroupsDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<String>> getMemberGroupsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<String>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<ADGroupInner> listNext(String nextLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<ADGroupInner>((Page)response.body()){

            public Page<ADGroupInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)GroupsInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceCall<List<ADGroupInner>> listNextAsync(String nextLink, ServiceCall<List<ADGroupInner>> serviceCall, ListOperationCallback<ADGroupInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(this.listNextSinglePageAsync(nextLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ADGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ADGroupInner>>> call(String nextLink) {
                return GroupsInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ADGroupInner>> listNextAsync(String nextLink) {
        return this.listNextWithServiceResponseAsync(nextLink).map((Func1)new Func1<ServiceResponse<Page<ADGroupInner>>, Page<ADGroupInner>>(){

            public Page<ADGroupInner> call(ServiceResponse<Page<ADGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ADGroupInner>>> listNextWithServiceResponseAsync(String nextLink) {
        return this.listNextSinglePageAsync(nextLink).concatMap((Func1)new Func1<ServiceResponse<Page<ADGroupInner>>, Observable<ServiceResponse<Page<ADGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ADGroupInner>>> call(ServiceResponse<Page<ADGroupInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GroupsInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ADGroupInner>>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return this.service.listNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ADGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ADGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GroupsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ADGroupInner>> listNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ADGroupInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<AADObjectInner> getGroupMembersNext(String nextLink) {
        ServiceResponse response = (ServiceResponse)this.getGroupMembersNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<AADObjectInner>((Page)response.body()){

            public Page<AADObjectInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)GroupsInner.this.getGroupMembersNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceCall<List<AADObjectInner>> getGroupMembersNextAsync(String nextLink, ServiceCall<List<AADObjectInner>> serviceCall, ListOperationCallback<AADObjectInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(this.getGroupMembersNextSinglePageAsync(nextLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(String nextLink) {
                return GroupsInner.this.getGroupMembersNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AADObjectInner>> getGroupMembersNextAsync(String nextLink) {
        return this.getGroupMembersNextWithServiceResponseAsync(nextLink).map((Func1)new Func1<ServiceResponse<Page<AADObjectInner>>, Page<AADObjectInner>>(){

            public Page<AADObjectInner> call(ServiceResponse<Page<AADObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AADObjectInner>>> getGroupMembersNextWithServiceResponseAsync(String nextLink) {
        return this.getGroupMembersNextSinglePageAsync(nextLink).concatMap((Func1)new Func1<ServiceResponse<Page<AADObjectInner>>, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(ServiceResponse<Page<AADObjectInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GroupsInner.this.getGroupMembersNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AADObjectInner>>> getGroupMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return this.service.getGroupMembersNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AADObjectInner>>>>(){

            public Observable<ServiceResponse<Page<AADObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GroupsInner.this.getGroupMembersNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AADObjectInner>> getGroupMembersNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AADObjectInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    static interface GroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups isMemberOf"})
        @POST(value="{tenantID}/isMemberOf")
        public Observable<Response<ResponseBody>> isMemberOf(@Path(value="tenantID") String var1, @Body CheckGroupMembershipParametersInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups removeMember"})
        @HTTP(path="{tenantID}/groups/{groupObjectId}/$links/members/{memberObjectId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> removeMember(@Path(value="groupObjectId", encoded=true) String var1, @Path(value="memberObjectId", encoded=true) String var2, @Path(value="tenantID") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups addMember"})
        @POST(value="{tenantID}/groups/{groupObjectId}/$links/members")
        public Observable<Response<ResponseBody>> addMember(@Path(value="groupObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body GroupAddMemberParameters var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups delete"})
        @HTTP(path="{tenantID}/groups/{groupObjectId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="groupObjectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups create"})
        @POST(value="{tenantID}/groups")
        public Observable<Response<ResponseBody>> create(@Path(value="tenantID") String var1, @Body GroupCreateParametersInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups list"})
        @GET(value="{tenantID}/groups")
        public Observable<Response<ResponseBody>> list(@Path(value="tenantID") String var1, @Query(value="$filter") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups getGroupMembers"})
        @GET(value="{tenantID}/groups/{objectId}/members")
        public Observable<Response<ResponseBody>> getGroupMembers(@Path(value="objectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups get"})
        @GET(value="{tenantID}/groups/{objectId}")
        public Observable<Response<ResponseBody>> get(@Path(value="objectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups getMemberGroups"})
        @POST(value="{tenantID}/groups/{objectId}/getMemberGroups")
        public Observable<Response<ResponseBody>> getMemberGroups(@Path(value="objectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body GroupGetMemberGroupsParameters var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Groups getGroupMembersNext"})
        @GET
        public Observable<Response<ResponseBody>> getGroupMembersNext(@Url String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

