/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.KeyCredentialsUpdateParameters;
import com.microsoft.azure.management.graphrbac.PasswordCredentialsUpdateParameters;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.KeyCredentialInner;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl1;
import com.microsoft.azure.management.graphrbac.implementation.PasswordCredentialInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalCreateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalInner;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public final class ServicePrincipalsInner {
    private ServicePrincipalsService service;
    private GraphRbacManagementClientImpl client;

    public ServicePrincipalsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = (ServicePrincipalsService)retrofit.create(ServicePrincipalsService.class);
        this.client = client;
    }

    public ServicePrincipalInner create(ServicePrincipalCreateParametersInner parameters) {
        return (ServicePrincipalInner)((ServiceResponse)this.createWithServiceResponseAsync(parameters).toBlocking().single()).body();
    }

    public ServiceCall<ServicePrincipalInner> createAsync(ServicePrincipalCreateParametersInner parameters, ServiceCallback<ServicePrincipalInner> serviceCallback) {
        return ServiceCall.fromResponse(this.createWithServiceResponseAsync(parameters), serviceCallback);
    }

    public Observable<ServicePrincipalInner> createAsync(ServicePrincipalCreateParametersInner parameters) {
        return this.createWithServiceResponseAsync(parameters).map((Func1)new Func1<ServiceResponse<ServicePrincipalInner>, ServicePrincipalInner>(){

            public ServicePrincipalInner call(ServiceResponse<ServicePrincipalInner> response) {
                return (ServicePrincipalInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServicePrincipalInner>> createWithServiceResponseAsync(ServicePrincipalCreateParametersInner parameters) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.create(this.client.tenantID(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServicePrincipalInner>>>(){

            public Observable<ServiceResponse<ServicePrincipalInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicePrincipalsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServicePrincipalInner> createDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<ServicePrincipalInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<ServicePrincipalInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ServicePrincipalInner>((Page)response.body()){

            public Page<ServicePrincipalInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)ServicePrincipalsInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceCall<List<ServicePrincipalInner>> listAsync(ListOperationCallback<ServicePrincipalInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>(){

            public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(String nextLink) {
                return ServicePrincipalsInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServicePrincipalInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Page<ServicePrincipalInner>>(){

            public Page<ServicePrincipalInner> call(ServiceResponse<Page<ServicePrincipalInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>(){

            public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(ServiceResponse<Page<ServicePrincipalInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServicePrincipalsInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listSinglePageAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>(){

            public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServicePrincipalsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ServicePrincipalInner> list(String filter) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<ServicePrincipalInner>((Page)response.body()){

            public Page<ServicePrincipalInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)ServicePrincipalsInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceCall<List<ServicePrincipalInner>> listAsync(String filter, ListOperationCallback<ServicePrincipalInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(this.listSinglePageAsync(filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>(){

            public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(String nextLink) {
                return ServicePrincipalsInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServicePrincipalInner>> listAsync(String filter) {
        return this.listWithServiceResponseAsync(filter).map((Func1)new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Page<ServicePrincipalInner>>(){

            public Page<ServicePrincipalInner> call(ServiceResponse<Page<ServicePrincipalInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listWithServiceResponseAsync(String filter) {
        return this.listSinglePageAsync(filter).concatMap((Func1)new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>(){

            public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(ServiceResponse<Page<ServicePrincipalInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServicePrincipalsInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listSinglePageAsync(String filter) {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.tenantID(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>(){

            public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServicePrincipalsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServicePrincipalInner>> listDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServicePrincipalInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void delete(String objectId) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(objectId).toBlocking().single()).body();
    }

    public ServiceCall<Void> deleteAsync(String objectId, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(this.deleteWithServiceResponseAsync(objectId), serviceCallback);
    }

    public Observable<Void> deleteAsync(String objectId) {
        return this.deleteWithServiceResponseAsync(objectId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicePrincipalsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public ServicePrincipalInner get(String objectId) {
        return (ServicePrincipalInner)((ServiceResponse)this.getWithServiceResponseAsync(objectId).toBlocking().single()).body();
    }

    public ServiceCall<ServicePrincipalInner> getAsync(String objectId, ServiceCallback<ServicePrincipalInner> serviceCallback) {
        return ServiceCall.fromResponse(this.getWithServiceResponseAsync(objectId), serviceCallback);
    }

    public Observable<ServicePrincipalInner> getAsync(String objectId) {
        return this.getWithServiceResponseAsync(objectId).map((Func1)new Func1<ServiceResponse<ServicePrincipalInner>, ServicePrincipalInner>(){

            public ServicePrincipalInner call(ServiceResponse<ServicePrincipalInner> response) {
                return (ServicePrincipalInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ServicePrincipalInner>> getWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServicePrincipalInner>>>(){

            public Observable<ServiceResponse<ServicePrincipalInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicePrincipalsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServicePrincipalInner> getDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServicePrincipalInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public List<KeyCredentialInner> listKeyCredentials(String objectId) {
        return (List)((ServiceResponse)this.listKeyCredentialsWithServiceResponseAsync(objectId).toBlocking().single()).body();
    }

    public ServiceCall<List<KeyCredentialInner>> listKeyCredentialsAsync(String objectId, ServiceCallback<List<KeyCredentialInner>> serviceCallback) {
        return ServiceCall.fromResponse(this.listKeyCredentialsWithServiceResponseAsync(objectId), serviceCallback);
    }

    public Observable<List<KeyCredentialInner>> listKeyCredentialsAsync(String objectId) {
        return this.listKeyCredentialsWithServiceResponseAsync(objectId).map((Func1)new Func1<ServiceResponse<List<KeyCredentialInner>>, List<KeyCredentialInner>>(){

            public List<KeyCredentialInner> call(ServiceResponse<List<KeyCredentialInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<KeyCredentialInner>>> listKeyCredentialsWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeyCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<KeyCredentialInner>>>>(){

            public Observable<ServiceResponse<List<KeyCredentialInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServicePrincipalsInner.this.listKeyCredentialsDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<KeyCredentialInner>> listKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<KeyCredentialInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void updateKeyCredentials(String objectId, List<KeyCredentialInner> value) {
        ((ServiceResponse)this.updateKeyCredentialsWithServiceResponseAsync(objectId, value).toBlocking().single()).body();
    }

    public ServiceCall<Void> updateKeyCredentialsAsync(String objectId, List<KeyCredentialInner> value, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(this.updateKeyCredentialsWithServiceResponseAsync(objectId, value), serviceCallback);
    }

    public Observable<Void> updateKeyCredentialsAsync(String objectId, List<KeyCredentialInner> value) {
        return this.updateKeyCredentialsWithServiceResponseAsync(objectId, value).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> updateKeyCredentialsWithServiceResponseAsync(String objectId, List<KeyCredentialInner> value) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(value);
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        return this.service.updateKeyCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicePrincipalsInner.this.updateKeyCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> updateKeyCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public List<PasswordCredentialInner> listPasswordCredentials(String objectId) {
        return (List)((ServiceResponse)this.listPasswordCredentialsWithServiceResponseAsync(objectId).toBlocking().single()).body();
    }

    public ServiceCall<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String objectId, ServiceCallback<List<PasswordCredentialInner>> serviceCallback) {
        return ServiceCall.fromResponse(this.listPasswordCredentialsWithServiceResponseAsync(objectId), serviceCallback);
    }

    public Observable<List<PasswordCredentialInner>> listPasswordCredentialsAsync(String objectId) {
        return this.listPasswordCredentialsWithServiceResponseAsync(objectId).map((Func1)new Func1<ServiceResponse<List<PasswordCredentialInner>>, List<PasswordCredentialInner>>(){

            public List<PasswordCredentialInner> call(ServiceResponse<List<PasswordCredentialInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<PasswordCredentialInner>>> listPasswordCredentialsWithServiceResponseAsync(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listPasswordCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<PasswordCredentialInner>>>>(){

            public Observable<ServiceResponse<List<PasswordCredentialInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServicePrincipalsInner.this.listPasswordCredentialsDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<PasswordCredentialInner>> listPasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<PasswordCredentialInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public void updatePasswordCredentials(String objectId, List<PasswordCredentialInner> value) {
        ((ServiceResponse)this.updatePasswordCredentialsWithServiceResponseAsync(objectId, value).toBlocking().single()).body();
    }

    public ServiceCall<Void> updatePasswordCredentialsAsync(String objectId, List<PasswordCredentialInner> value, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.fromResponse(this.updatePasswordCredentialsWithServiceResponseAsync(objectId, value), serviceCallback);
    }

    public Observable<Void> updatePasswordCredentialsAsync(String objectId, List<PasswordCredentialInner> value) {
        return this.updatePasswordCredentialsWithServiceResponseAsync(objectId, value).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> updatePasswordCredentialsWithServiceResponseAsync(String objectId, List<PasswordCredentialInner> value) {
        if (objectId == null) {
            throw new IllegalArgumentException("Parameter objectId is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(value);
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        return this.service.updatePasswordCredentials(objectId, this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicePrincipalsInner.this.updatePasswordCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> updatePasswordCredentialsDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    public PagedList<ServicePrincipalInner> listNext(String nextLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextLink).toBlocking().single();
        return new PagedList<ServicePrincipalInner>((Page)response.body()){

            public Page<ServicePrincipalInner> nextPage(String nextLink) {
                return (Page)((ServiceResponse)ServicePrincipalsInner.this.listNextSinglePageAsync(nextLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceCall<List<ServicePrincipalInner>> listNextAsync(String nextLink, ServiceCall<List<ServicePrincipalInner>> serviceCall, ListOperationCallback<ServicePrincipalInner> serviceCallback) {
        return AzureServiceCall.fromPageResponse(this.listNextSinglePageAsync(nextLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>(){

            public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(String nextLink) {
                return ServicePrincipalsInner.this.listNextSinglePageAsync(nextLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServicePrincipalInner>> listNextAsync(String nextLink) {
        return this.listNextWithServiceResponseAsync(nextLink).map((Func1)new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Page<ServicePrincipalInner>>(){

            public Page<ServicePrincipalInner> call(ServiceResponse<Page<ServicePrincipalInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listNextWithServiceResponseAsync(String nextLink) {
        return this.listNextSinglePageAsync(nextLink).concatMap((Func1)new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>(){

            public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(ServiceResponse<Page<ServicePrincipalInner>> page) {
                String nextLink = ((Page)page.body()).nextPageLink();
                if (nextLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServicePrincipalsInner.this.listNextWithServiceResponseAsync(nextLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServicePrincipalInner>>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            throw new IllegalArgumentException("Parameter nextLink is required and cannot be null.");
        }
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String nextUrl = String.format("%s/%s", this.client.tenantID(), nextLink);
        return this.service.listNext(nextUrl, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServicePrincipalInner>>>>(){

            public Observable<ServiceResponse<Page<ServicePrincipalInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServicePrincipalsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServicePrincipalInner>> listNextDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServicePrincipalInner>>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    static interface ServicePrincipalsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals create"})
        @POST(value="{tenantID}/servicePrincipals")
        public Observable<Response<ResponseBody>> create(@Path(value="tenantID") String var1, @Body ServicePrincipalCreateParametersInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals list"})
        @GET(value="{tenantID}/servicePrincipals")
        public Observable<Response<ResponseBody>> list(@Path(value="tenantID") String var1, @Query(value="$filter") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals delete"})
        @HTTP(path="{tenantID}/servicePrincipals/{objectId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="objectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals get"})
        @GET(value="{tenantID}/servicePrincipals/{objectId}")
        public Observable<Response<ResponseBody>> get(@Path(value="objectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals listKeyCredentials"})
        @GET(value="{tenantID}/servicePrincipals/{objectId}/keyCredentials")
        public Observable<Response<ResponseBody>> listKeyCredentials(@Path(value="objectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals updateKeyCredentials"})
        @PATCH(value="{tenantID}/servicePrincipals/{objectId}/keyCredentials")
        public Observable<Response<ResponseBody>> updateKeyCredentials(@Path(value="objectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyCredentialsUpdateParameters var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals listPasswordCredentials"})
        @GET(value="{tenantID}/servicePrincipals/{objectId}/passwordCredentials")
        public Observable<Response<ResponseBody>> listPasswordCredentials(@Path(value="objectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals updatePasswordCredentials"})
        @PATCH(value="{tenantID}/servicePrincipals/{objectId}/passwordCredentials")
        public Observable<Response<ResponseBody>> updatePasswordCredentials(@Path(value="objectId", encoded=true) String var1, @Path(value="tenantID") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body PasswordCredentialsUpdateParameters var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ServicePrincipals listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

