/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.graphrbac.GraphErrorException;
import com.microsoft.azure.management.graphrbac.implementation.AADObjectInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ObjectsInner {
    private ObjectsService service;
    private GraphRbacManagementClientImpl client;

    public ObjectsInner(Retrofit retrofit, GraphRbacManagementClientImpl client) {
        this.service = (ObjectsService)retrofit.create(ObjectsService.class);
        this.client = client;
    }

    public AADObjectInner getCurrentUser() {
        return (AADObjectInner)((ServiceResponse)this.getCurrentUserWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<AADObjectInner> getCurrentUserAsync(ServiceCallback<AADObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCurrentUserWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<AADObjectInner> getCurrentUserAsync() {
        return this.getCurrentUserWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<AADObjectInner>, AADObjectInner>(){

            public AADObjectInner call(ServiceResponse<AADObjectInner> response) {
                return (AADObjectInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AADObjectInner>> getCurrentUserWithServiceResponseAsync() {
        if (this.client.tenantID() == null) {
            throw new IllegalArgumentException("Parameter this.client.tenantID() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getCurrentUser(this.client.tenantID(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AADObjectInner>>>(){

            public Observable<ServiceResponse<AADObjectInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ObjectsInner.this.getCurrentUserDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AADObjectInner> getCurrentUserDelegate(Response<ResponseBody> response) throws GraphErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AADObjectInner>(){}.getType()).registerError(GraphErrorException.class).build(response);
    }

    static interface ObjectsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.Objects getCurrentUser"})
        @GET(value="{tenantID}/me")
        public Observable<Response<ResponseBody>> getCurrentUser(@Path(value="tenantID") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

