/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.PasswordProfile;
import com.microsoft.azure.management.graphrbac.User;
import com.microsoft.azure.management.graphrbac.implementation.UserCreateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.UserInner;
import com.microsoft.azure.management.graphrbac.implementation.UsersInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import rx.Observable;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Fluent.Graph.RBAC")
class UserImpl
extends CreatableUpdatableImpl<User, UserInner, UserImpl>
implements User,
User.Definition,
User.Update {
    private UsersInner client;
    private UserCreateParametersInner createParameters;

    UserImpl(String userPrincipalName, UsersInner client) {
        super(userPrincipalName, (Object)new UserInner());
        this.client = client;
        this.createParameters = new UserCreateParametersInner().withUserPrincipalName(userPrincipalName);
    }

    UserImpl(UserInner innerObject, UsersInner client) {
        super(innerObject.userPrincipalName(), (Object)innerObject);
        this.client = client;
        this.createParameters = new UserCreateParametersInner();
    }

    @Override
    public String objectId() {
        return ((UserInner)this.inner()).objectId();
    }

    @Override
    public String objectType() {
        return ((UserInner)this.inner()).objectType();
    }

    @Override
    public String userPrincipalName() {
        return ((UserInner)this.inner()).userPrincipalName();
    }

    @Override
    public String displayName() {
        return ((UserInner)this.inner()).displayName();
    }

    @Override
    public String signInName() {
        return ((UserInner)this.inner()).signInName();
    }

    @Override
    public String mail() {
        return ((UserInner)this.inner()).mail();
    }

    @Override
    public String mailNickname() {
        return ((UserInner)this.inner()).mailNickname();
    }

    @Override
    public UserImpl withAccountEnabled(boolean enabled) {
        this.createParameters.withAccountEnabled(enabled);
        return this;
    }

    @Override
    public UserImpl withDisplayName(String displayName) {
        this.createParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public UserImpl withMailNickname(String mailNickname) {
        this.createParameters.withMailNickname(mailNickname);
        return this;
    }

    @Override
    public UserImpl withPassword(String password) {
        this.createParameters.withPasswordProfile(new PasswordProfile().withPassword(password));
        return this;
    }

    @Override
    public UserImpl withPassword(String password, boolean forceChangePasswordNextLogin) {
        this.createParameters.withPasswordProfile(new PasswordProfile().withPassword(password).withForceChangePasswordNextLogin(forceChangePasswordNextLogin));
        return this;
    }

    protected Observable<UserInner> getInnerAsync() {
        return this.client.getAsync(this.name());
    }

    public Observable<User> createResourceAsync() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean isInCreateMode() {
        return false;
    }
}

