/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryUser;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryUsers;
import com.microsoft.azure.management.graphrbac.implementation.ActiveDirectoryUserImpl;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.UserInner;
import com.microsoft.azure.management.graphrbac.implementation.UsersInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class ActiveDirectoryUsersImpl
extends ReadableWrappersImpl<ActiveDirectoryUser, ActiveDirectoryUserImpl, UserInner>
implements ActiveDirectoryUsers,
HasInner<UsersInner> {
    private final GraphRbacManager manager;

    ActiveDirectoryUsersImpl(GraphRbacManager manager) {
        this.manager = manager;
    }

    public PagedList<ActiveDirectoryUser> list() {
        return this.wrapList(this.manager().inner().users().list());
    }

    protected ActiveDirectoryUserImpl wrapModel(UserInner userInner) {
        if (userInner == null) {
            return null;
        }
        return new ActiveDirectoryUserImpl(userInner, this.manager());
    }

    public ActiveDirectoryUserImpl getById(String objectId) {
        return (ActiveDirectoryUserImpl)this.getByIdAsync(objectId).toBlocking().single();
    }

    public Observable<ActiveDirectoryUser> getByIdAsync(String id) {
        return this.manager().inner().users().getAsync(id).map((Func1)new Func1<UserInner, ActiveDirectoryUser>(){

            public ActiveDirectoryUser call(UserInner userInner) {
                if (userInner == null) {
                    return null;
                }
                return new ActiveDirectoryUserImpl(userInner, ActiveDirectoryUsersImpl.this.manager());
            }
        });
    }

    public ServiceFuture<ActiveDirectoryUser> getByIdAsync(String id, ServiceCallback<ActiveDirectoryUser> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    public ActiveDirectoryUserImpl getByName(String upn) {
        return (ActiveDirectoryUserImpl)this.getByNameAsync(upn).toBlocking().single();
    }

    public Observable<ActiveDirectoryUser> getByNameAsync(final String name) {
        return this.manager().inner().users().getAsync(name).flatMap((Func1)new Func1<UserInner, Observable<UserInner>>(){

            public Observable<UserInner> call(UserInner userInner) {
                if (userInner != null) {
                    return Observable.just((Object)userInner);
                }
                if (name.contains("@")) {
                    return ActiveDirectoryUsersImpl.this.manager().inner().users().listAsync(String.format("mail eq '%s' or mailNickName eq '%s#EXT#'", name, name.replace("@", "_"))).map((Func1)new Func1<Page<UserInner>, UserInner>(){

                        public UserInner call(Page<UserInner> userInnerPage) {
                            if (userInnerPage.items() == null || userInnerPage.items().isEmpty()) {
                                return null;
                            }
                            return (UserInner)userInnerPage.items().get(0);
                        }
                    });
                }
                return ActiveDirectoryUsersImpl.this.manager().inner().users().listAsync(String.format("displayName eq '%s'", name)).map((Func1)new Func1<Page<UserInner>, UserInner>(){

                    public UserInner call(Page<UserInner> userInnerPage) {
                        if (userInnerPage.items() == null || userInnerPage.items().isEmpty()) {
                            return null;
                        }
                        return (UserInner)userInnerPage.items().get(0);
                    }
                });
            }
        }).map((Func1)new Func1<UserInner, ActiveDirectoryUser>(){

            public ActiveDirectoryUser call(UserInner userInnerServiceResponse) {
                if (userInnerServiceResponse == null) {
                    return null;
                }
                return new ActiveDirectoryUserImpl(userInnerServiceResponse, ActiveDirectoryUsersImpl.this.manager());
            }
        });
    }

    public UsersInner inner() {
        return this.manager().inner().users();
    }

    public Observable<ActiveDirectoryUser> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync());
    }

    public GraphRbacManager manager() {
        return this.manager;
    }
}

