/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.graphrbac.CertificateCredential;
import com.microsoft.azure.management.graphrbac.PasswordCredential;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasName;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Fluent(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
@Beta(value=Beta.SinceVersion.V1_1_0)
public interface ActiveDirectoryApplication
extends Indexable,
HasInner<ApplicationInner>,
HasId,
HasName,
HasManager<GraphRbacManager>,
Updatable<Update> {
    public String applicationId();

    public List<String> applicationPermissions();

    public boolean availableToOtherTenants();

    public Set<String> identifierUris();

    public Set<String> replyUrls();

    public URL signOnUrl();

    public Map<String, PasswordCredential> passwordCredentials();

    public Map<String, CertificateCredential> certificateCredentials();

    public static interface Update
    extends Appliable<ActiveDirectoryApplication>,
    UpdateStages.WithSignOnUrl,
    UpdateStages.WithIdentifierUrl,
    UpdateStages.WithReplyUrl,
    UpdateStages.WithCredential,
    UpdateStages.WithMultiTenant {
    }

    public static interface UpdateStages {

        public static interface WithMultiTenant {
            public Update withAvailableToOtherTenants(boolean var1);
        }

        public static interface WithCredential {
            public CertificateCredential.UpdateDefinitionStages.Blank<Update> defineCertificateCredential(String var1);

            public PasswordCredential.UpdateDefinitionStages.Blank<Update> definePasswordCredential(String var1);

            public Update withoutCredential(String var1);
        }

        public static interface WithIdentifierUrl {
            public Update withIdentifierUrl(String var1);

            public Update withoutIdentifierUrl(String var1);
        }

        public static interface WithReplyUrl {
            public Update withReplyUrl(String var1);

            public Update withoutReplyUrl(String var1);
        }

        public static interface WithSignOnUrl {
            public Update withSignOnUrl(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ActiveDirectoryApplication>,
        WithIdentifierUrl,
        WithReplyUrl,
        WithCredential,
        WithMultiTenant {
        }

        public static interface WithMultiTenant {
            public WithCreate withAvailableToOtherTenants(boolean var1);
        }

        public static interface WithCredential {
            public CertificateCredential.DefinitionStages.Blank<WithCreate> defineCertificateCredential(String var1);

            public PasswordCredential.DefinitionStages.Blank<WithCreate> definePasswordCredential(String var1);
        }

        public static interface WithIdentifierUrl {
            public WithCreate withIdentifierUrl(String var1);
        }

        public static interface WithReplyUrl {
            public WithCreate withReplyUrl(String var1);
        }

        public static interface WithSignOnUrl {
            public WithCreate withSignOnUrl(String var1);
        }

        public static interface Blank
        extends WithSignOnUrl {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate {
    }
}

