/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.graphrbac.RoleAssignmentCreateParameters;
import com.microsoft.azure.management.graphrbac.implementation.AuthorizationManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentInner;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentPropertiesInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RoleAssignmentsInner
implements InnerSupportsDelete<RoleAssignmentInner>,
InnerSupportsListing<RoleAssignmentInner> {
    private RoleAssignmentsService service;
    private AuthorizationManagementClientImpl client;

    public RoleAssignmentsInner(Retrofit retrofit, AuthorizationManagementClientImpl client) {
        this.service = (RoleAssignmentsService)retrofit.create(RoleAssignmentsService.class);
        this.client = client;
    }

    public PagedList<RoleAssignmentInner> listForResource(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        ServiceResponse response = (ServiceResponse)this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        return this.listForResourceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        return this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listForResourceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceSinglePageAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.listForResource(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listForResourceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RoleAssignmentInner> listForResource(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        ServiceResponse response = (ServiceResponse)this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listForResourceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        return this.listForResourceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        return this.listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listForResourceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceSinglePageAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listForResource(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listForResourceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForResourceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RoleAssignmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RoleAssignmentInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RoleAssignmentInner> listByResourceGroup(String resourceGroupName, String filter) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listByResourceGroupAsync(String resourceGroupName, String filter, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listByResourceGroupAsync(String resourceGroupName, String filter) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String filter) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, filter).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RoleAssignmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RoleAssignmentInner delete(String scope, String roleAssignmentName) {
        return (RoleAssignmentInner)((ServiceResponse)this.deleteWithServiceResponseAsync(scope, roleAssignmentName).toBlocking().single()).body();
    }

    public ServiceFuture<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName, ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(scope, roleAssignmentName), serviceCallback);
    }

    public Observable<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName) {
        return this.deleteWithServiceResponseAsync(scope, roleAssignmentName).map((Func1)new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>(){

            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return (RoleAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleAssignmentInner>> deleteWithServiceResponseAsync(String scope, String roleAssignmentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(scope, roleAssignmentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>(){

            public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleAssignmentsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RoleAssignmentInner> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RoleAssignmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RoleAssignmentInner create(String scope, String roleAssignmentName) {
        return (RoleAssignmentInner)((ServiceResponse)this.createWithServiceResponseAsync(scope, roleAssignmentName).toBlocking().single()).body();
    }

    public ServiceFuture<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName, ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(scope, roleAssignmentName), serviceCallback);
    }

    public Observable<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName) {
        return this.createWithServiceResponseAsync(scope, roleAssignmentName).map((Func1)new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>(){

            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return (RoleAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleAssignmentInner>> createWithServiceResponseAsync(String scope, String roleAssignmentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object properties = null;
        RoleAssignmentCreateParameters parameters = new RoleAssignmentCreateParameters();
        parameters.withProperties(null);
        return this.service.create(scope, roleAssignmentName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>(){

            public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleAssignmentsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public RoleAssignmentInner create(String scope, String roleAssignmentName, RoleAssignmentPropertiesInner properties) {
        return (RoleAssignmentInner)((ServiceResponse)this.createWithServiceResponseAsync(scope, roleAssignmentName, properties).toBlocking().single()).body();
    }

    public ServiceFuture<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName, RoleAssignmentPropertiesInner properties, ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(scope, roleAssignmentName, properties), serviceCallback);
    }

    public Observable<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName, RoleAssignmentPropertiesInner properties) {
        return this.createWithServiceResponseAsync(scope, roleAssignmentName, properties).map((Func1)new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>(){

            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return (RoleAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleAssignmentInner>> createWithServiceResponseAsync(String scope, String roleAssignmentName, RoleAssignmentPropertiesInner properties) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)properties);
        RoleAssignmentCreateParameters parameters = new RoleAssignmentCreateParameters();
        parameters.withProperties(properties);
        return this.service.create(scope, roleAssignmentName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>(){

            public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleAssignmentsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RoleAssignmentInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<RoleAssignmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RoleAssignmentInner get(String scope, String roleAssignmentName) {
        return (RoleAssignmentInner)((ServiceResponse)this.getWithServiceResponseAsync(scope, roleAssignmentName).toBlocking().single()).body();
    }

    public ServiceFuture<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName, ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(scope, roleAssignmentName), serviceCallback);
    }

    public Observable<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName) {
        return this.getWithServiceResponseAsync(scope, roleAssignmentName).map((Func1)new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>(){

            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return (RoleAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleAssignmentInner>> getWithServiceResponseAsync(String scope, String roleAssignmentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(scope, roleAssignmentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>(){

            public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleAssignmentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RoleAssignmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RoleAssignmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RoleAssignmentInner deleteById(String roleAssignmentId) {
        return (RoleAssignmentInner)((ServiceResponse)this.deleteByIdWithServiceResponseAsync(roleAssignmentId).toBlocking().single()).body();
    }

    public ServiceFuture<RoleAssignmentInner> deleteByIdAsync(String roleAssignmentId, ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteByIdWithServiceResponseAsync(roleAssignmentId), serviceCallback);
    }

    public Observable<RoleAssignmentInner> deleteByIdAsync(String roleAssignmentId) {
        return this.deleteByIdWithServiceResponseAsync(roleAssignmentId).map((Func1)new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>(){

            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return (RoleAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleAssignmentInner>> deleteByIdWithServiceResponseAsync(String roleAssignmentId) {
        if (roleAssignmentId == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteById(roleAssignmentId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>(){

            public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleAssignmentsInner.this.deleteByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RoleAssignmentInner> deleteByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RoleAssignmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RoleAssignmentInner createById(String roleAssignmentId) {
        return (RoleAssignmentInner)((ServiceResponse)this.createByIdWithServiceResponseAsync(roleAssignmentId).toBlocking().single()).body();
    }

    public ServiceFuture<RoleAssignmentInner> createByIdAsync(String roleAssignmentId, ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createByIdWithServiceResponseAsync(roleAssignmentId), serviceCallback);
    }

    public Observable<RoleAssignmentInner> createByIdAsync(String roleAssignmentId) {
        return this.createByIdWithServiceResponseAsync(roleAssignmentId).map((Func1)new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>(){

            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return (RoleAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleAssignmentInner>> createByIdWithServiceResponseAsync(String roleAssignmentId) {
        if (roleAssignmentId == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object properties = null;
        RoleAssignmentCreateParameters parameters = new RoleAssignmentCreateParameters();
        parameters.withProperties(null);
        return this.service.createById(roleAssignmentId, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>(){

            public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleAssignmentsInner.this.createByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public RoleAssignmentInner createById(String roleAssignmentId, RoleAssignmentPropertiesInner properties) {
        return (RoleAssignmentInner)((ServiceResponse)this.createByIdWithServiceResponseAsync(roleAssignmentId, properties).toBlocking().single()).body();
    }

    public ServiceFuture<RoleAssignmentInner> createByIdAsync(String roleAssignmentId, RoleAssignmentPropertiesInner properties, ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createByIdWithServiceResponseAsync(roleAssignmentId, properties), serviceCallback);
    }

    public Observable<RoleAssignmentInner> createByIdAsync(String roleAssignmentId, RoleAssignmentPropertiesInner properties) {
        return this.createByIdWithServiceResponseAsync(roleAssignmentId, properties).map((Func1)new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>(){

            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return (RoleAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleAssignmentInner>> createByIdWithServiceResponseAsync(String roleAssignmentId, RoleAssignmentPropertiesInner properties) {
        if (roleAssignmentId == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)properties);
        RoleAssignmentCreateParameters parameters = new RoleAssignmentCreateParameters();
        parameters.withProperties(properties);
        return this.service.createById(roleAssignmentId, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>(){

            public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleAssignmentsInner.this.createByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RoleAssignmentInner> createByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<RoleAssignmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RoleAssignmentInner getById(String roleAssignmentId) {
        return (RoleAssignmentInner)((ServiceResponse)this.getByIdWithServiceResponseAsync(roleAssignmentId).toBlocking().single()).body();
    }

    public ServiceFuture<RoleAssignmentInner> getByIdAsync(String roleAssignmentId, ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByIdWithServiceResponseAsync(roleAssignmentId), serviceCallback);
    }

    public Observable<RoleAssignmentInner> getByIdAsync(String roleAssignmentId) {
        return this.getByIdWithServiceResponseAsync(roleAssignmentId).map((Func1)new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>(){

            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return (RoleAssignmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RoleAssignmentInner>> getByIdWithServiceResponseAsync(String roleAssignmentId) {
        if (roleAssignmentId == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getById(roleAssignmentId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>(){

            public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RoleAssignmentsInner.this.getByIdDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RoleAssignmentInner> getByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RoleAssignmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RoleAssignmentInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listAsync(ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.list(this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RoleAssignmentInner> list(String filter) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listAsync(String filter, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listAsync(String filter) {
        return this.listWithServiceResponseAsync(filter).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listWithServiceResponseAsync(String filter) {
        return this.listSinglePageAsync(filter).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listSinglePageAsync(String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RoleAssignmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RoleAssignmentInner> listForScope(String scope) {
        ServiceResponse response = (ServiceResponse)this.listForScopeSinglePageAsync(scope).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listForScopeAsync(String scope, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listForScopeSinglePageAsync(scope), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listForScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listForScopeAsync(String scope) {
        return this.listForScopeWithServiceResponseAsync(scope).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeWithServiceResponseAsync(String scope) {
        return this.listForScopeSinglePageAsync(scope).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listForScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeSinglePageAsync(String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.listForScope(scope, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listForScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RoleAssignmentInner> listForScope(String scope, String filter) {
        ServiceResponse response = (ServiceResponse)this.listForScopeSinglePageAsync(scope, filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listForScopeAsync(String scope, String filter, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listForScopeSinglePageAsync(scope, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listForScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listForScopeAsync(String scope, String filter) {
        return this.listForScopeWithServiceResponseAsync(scope, filter).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeWithServiceResponseAsync(String scope, String filter) {
        return this.listForScopeSinglePageAsync(scope, filter).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listForScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeSinglePageAsync(String scope, String filter) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listForScope(scope, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listForScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RoleAssignmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RoleAssignmentInner> listForResourceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listForResourceNextAsync(String nextPageLink, ServiceFuture<List<RoleAssignmentInner>> serviceFuture, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listForResourceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listForResourceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listForResourceNextAsync(String nextPageLink) {
        return this.listForResourceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listForResourceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listForResourceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listForResourceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listForResourceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForResourceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RoleAssignmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RoleAssignmentInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<RoleAssignmentInner>> serviceFuture, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RoleAssignmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RoleAssignmentInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RoleAssignmentInner>> serviceFuture, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RoleAssignmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RoleAssignmentInner> listForScopeNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>((Page)response.body()){

            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RoleAssignmentsInner.this.listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RoleAssignmentInner>> listForScopeNextAsync(String nextPageLink, ServiceFuture<List<RoleAssignmentInner>> serviceFuture, ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listForScopeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                return RoleAssignmentsInner.this.listForScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RoleAssignmentInner>> listForScopeNextAsync(String nextPageLink) {
        return this.listForScopeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>(){

            public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listForScopeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RoleAssignmentsInner.this.listForScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listForScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>(){

            public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RoleAssignmentsInner.this.listForScopeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RoleAssignmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RoleAssignmentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForResource"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/roleAssignments")
        public Observable<Response<ResponseBody>> listForResource(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="$filter") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/roleAssignments")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="$filter") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments delete"})
        @HTTP(path="{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="scope", encoded=true) String var1, @Path(value="roleAssignmentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments create"})
        @PUT(value="{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        public Observable<Response<ResponseBody>> create(@Path(value="scope", encoded=true) String var1, @Path(value="roleAssignmentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body RoleAssignmentCreateParameters var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments get"})
        @GET(value="{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="scope", encoded=true) String var1, @Path(value="roleAssignmentName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments deleteById"})
        @HTTP(path="{roleAssignmentId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteById(@Path(value="roleAssignmentId", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments createById"})
        @PUT(value="{roleAssignmentId}")
        public Observable<Response<ResponseBody>> createById(@Path(value="roleAssignmentId", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body RoleAssignmentCreateParameters var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments getById"})
        @GET(value="{roleAssignmentId}")
        public Observable<Response<ResponseBody>> getById(@Path(value="roleAssignmentId", encoded=true) String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/roleAssignments")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$filter") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForScope"})
        @GET(value="{scope}/providers/Microsoft.Authorization/roleAssignments")
        public Observable<Response<ResponseBody>> listForScope(@Path(value="scope", encoded=true) String var1, @Query(value="$filter") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForResourceNext"})
        @GET
        public Observable<Response<ResponseBody>> listForResourceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForScopeNext"})
        @GET
        public Observable<Response<ResponseBody>> listForScopeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

