/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryApplication;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.CertificateCredential;
import com.microsoft.azure.management.graphrbac.PasswordCredential;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.implementation.CertificateCredentialImpl;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.HasCredential;
import com.microsoft.azure.management.graphrbac.implementation.KeyCredentialInner;
import com.microsoft.azure.management.graphrbac.implementation.PasswordCredentialImpl;
import com.microsoft.azure.management.graphrbac.implementation.PasswordCredentialInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalCreateParametersInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalInner;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.functions.Func2;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class ServicePrincipalImpl
extends CreatableUpdatableImpl<ServicePrincipal, ServicePrincipalInner, ServicePrincipalImpl>
implements ServicePrincipal,
ServicePrincipal.Definition,
HasCredential<ServicePrincipalImpl> {
    private GraphRbacManager manager;
    private ServicePrincipalCreateParametersInner createParameters;
    private Map<String, PasswordCredential> cachedPasswordCredentials;
    private Map<String, CertificateCredential> cachedCertificateCredentials;
    private Creatable<ActiveDirectoryApplication> applicationCreatable;
    private Map<String, BuiltInRole> roles;
    String assignedSubscription;
    private List<CertificateCredentialImpl<?>> certificateCredentials;
    private List<PasswordCredentialImpl<?>> passwordCredentials;

    ServicePrincipalImpl(ServicePrincipalInner innerObject, GraphRbacManager manager) {
        super(innerObject.displayName(), (Object)innerObject);
        this.manager = manager;
        this.createParameters = new ServicePrincipalCreateParametersInner().withAccountEnabled(true);
        this.roles = new HashMap<String, BuiltInRole>();
        this.certificateCredentials = new ArrayList();
        this.passwordCredentials = new ArrayList();
    }

    public String id() {
        return ((ServicePrincipalInner)this.inner()).objectId();
    }

    @Override
    public String applicationId() {
        return ((ServicePrincipalInner)this.inner()).appId();
    }

    @Override
    public List<String> servicePrincipalNames() {
        return ((ServicePrincipalInner)this.inner()).servicePrincipalNames();
    }

    @Override
    public Map<String, PasswordCredential> passwordCredentials() {
        if (this.cachedPasswordCredentials == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.cachedPasswordCredentials);
    }

    @Override
    public Map<String, CertificateCredential> certificateCredentials() {
        if (this.cachedCertificateCredentials == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.cachedCertificateCredentials);
    }

    protected Observable<ServicePrincipalInner> getInnerAsync() {
        return this.manager.inner().servicePrincipals().getAsync(this.id());
    }

    public Observable<ServicePrincipal> createResourceAsync() {
        if (this.applicationCreatable != null) {
            ActiveDirectoryApplication application = (ActiveDirectoryApplication)super.createdModel(this.applicationCreatable.key());
            this.createParameters.withAppId(application.applicationId());
        }
        Observable sp = this.manager.inner().servicePrincipals().createAsync(this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap((Func1)new Func1<ServicePrincipal, Observable<ServicePrincipal>>(){

            public Observable<ServicePrincipal> call(ServicePrincipal servicePrincipal) {
                return ServicePrincipalImpl.this.refreshCredentialsAsync();
            }
        });
        if (this.roles == null || this.roles.isEmpty()) {
            return sp;
        }
        return sp.flatMap((Func1)new Func1<ServicePrincipal, Observable<ServicePrincipal>>(){

            public Observable<ServicePrincipal> call(final ServicePrincipal servicePrincipal) {
                return Observable.from(ServicePrincipalImpl.this.roles.entrySet()).flatMap(new Func1<Map.Entry<String, BuiltInRole>, Observable<?>>(){

                    public Observable<?> call(Map.Entry<String, BuiltInRole> role) {
                        return ((RoleAssignment.DefinitionStages.Blank)ServicePrincipalImpl.this.manager().roleAssignments().define(SdkContext.randomUuid())).forServicePrincipal(servicePrincipal).withBuiltInRole(role.getValue()).withScope(role.getKey()).createAsync().retryWhen(new Func1<Observable<? extends Throwable>, Observable<?>>(){

                            public Observable<?> call(Observable<? extends Throwable> observable) {
                                return observable.zipWith(Observable.range((int)1, (int)30), (Func2)new Func2<Throwable, Integer, Integer>(){

                                    public Integer call(Throwable throwable, Integer integer) {
                                        if (throwable instanceof CloudException && ((CloudException)throwable).body().code().equalsIgnoreCase("PrincipalNotFound")) {
                                            return integer;
                                        }
                                        throw Exceptions.propagate((Throwable)throwable);
                                    }
                                }).flatMap(new Func1<Integer, Observable<?>>(){

                                    public Observable<?> call(Integer i) {
                                        return Observable.timer((long)i.intValue(), (TimeUnit)TimeUnit.SECONDS);
                                    }
                                });
                            }
                        });
                    }
                }).last().map((Func1)new Func1<Object, ServicePrincipal>(){

                    public ServicePrincipal call(Object o) {
                        return servicePrincipal;
                    }
                });
            }
        }).map((Func1)new Func1<ServicePrincipal, ServicePrincipal>(){

            public ServicePrincipal call(ServicePrincipal servicePrincipal) {
                for (PasswordCredentialImpl passwordCredential : ServicePrincipalImpl.this.passwordCredentials) {
                    passwordCredential.exportAuthFile((ServicePrincipalImpl)servicePrincipal);
                }
                for (CertificateCredentialImpl certificateCredential : ServicePrincipalImpl.this.certificateCredentials) {
                    certificateCredential.exportAuthFile((ServicePrincipalImpl)servicePrincipal);
                }
                return servicePrincipal;
            }
        });
    }

    public boolean isInCreateMode() {
        return true;
    }

    Observable<ServicePrincipal> refreshCredentialsAsync() {
        Observable keyCredentials = this.manager.inner().servicePrincipals().listKeyCredentialsAsync(this.id()).map((Func1)new Func1<List<KeyCredentialInner>, Map<String, CertificateCredential>>(){

            public Map<String, CertificateCredential> call(List<KeyCredentialInner> keyCredentialInners) {
                if (keyCredentialInners == null || keyCredentialInners.isEmpty()) {
                    return null;
                }
                HashMap<String, CertificateCredential> certificateCredentialMap = new HashMap<String, CertificateCredential>();
                for (KeyCredentialInner inner : keyCredentialInners) {
                    CertificateCredentialImpl credential = new CertificateCredentialImpl(inner);
                    certificateCredentialMap.put(credential.name(), credential);
                }
                return certificateCredentialMap;
            }
        }).map((Func1)new Func1<Map<String, CertificateCredential>, ServicePrincipal>(){

            public ServicePrincipal call(Map<String, CertificateCredential> stringCertificateCredentialMap) {
                ServicePrincipalImpl.this.cachedCertificateCredentials = stringCertificateCredentialMap;
                return ServicePrincipalImpl.this;
            }
        });
        Observable passwordCredentials = this.manager.inner().servicePrincipals().listPasswordCredentialsAsync(this.id()).map((Func1)new Func1<List<PasswordCredentialInner>, Map<String, PasswordCredential>>(){

            public Map<String, PasswordCredential> call(List<PasswordCredentialInner> passwordCredentialInners) {
                if (passwordCredentialInners == null || passwordCredentialInners.isEmpty()) {
                    return null;
                }
                HashMap<String, PasswordCredential> passwordCredentialMap = new HashMap<String, PasswordCredential>();
                for (PasswordCredentialInner inner : passwordCredentialInners) {
                    PasswordCredentialImpl credential = new PasswordCredentialImpl(inner);
                    passwordCredentialMap.put(credential.name(), credential);
                }
                return passwordCredentialMap;
            }
        }).map((Func1)new Func1<Map<String, PasswordCredential>, ServicePrincipal>(){

            public ServicePrincipal call(Map<String, PasswordCredential> stringPasswordCredentialMap) {
                ServicePrincipalImpl.this.cachedPasswordCredentials = stringPasswordCredentialMap;
                return ServicePrincipalImpl.this;
            }
        });
        return keyCredentials.mergeWith(passwordCredentials).last();
    }

    public Observable<ServicePrincipal> refreshAsync() {
        return this.getInnerAsync().map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap((Func1)new Func1<ServicePrincipal, Observable<ServicePrincipal>>(){

            public Observable<ServicePrincipal> call(ServicePrincipal application) {
                return ServicePrincipalImpl.this.refreshCredentialsAsync();
            }
        });
    }

    public CertificateCredentialImpl<ServicePrincipal.DefinitionStages.WithCreate> defineCertificateCredential(String name) {
        return new CertificateCredentialImpl<ServicePrincipal.DefinitionStages.WithCreate>(name, this);
    }

    public PasswordCredentialImpl<ServicePrincipal.DefinitionStages.WithCreate> definePasswordCredential(String name) {
        return new PasswordCredentialImpl<ServicePrincipal.DefinitionStages.WithCreate>(name, this);
    }

    @Override
    public ServicePrincipalImpl withCertificateCredential(CertificateCredentialImpl<?> credential) {
        if (this.createParameters.keyCredentials() == null) {
            this.createParameters.withKeyCredentials(new ArrayList<KeyCredentialInner>());
        }
        this.createParameters.keyCredentials().add((KeyCredentialInner)credential.inner());
        this.certificateCredentials.add(credential);
        return this;
    }

    @Override
    public ServicePrincipalImpl withPasswordCredential(PasswordCredentialImpl<?> credential) {
        if (this.createParameters.passwordCredentials() == null) {
            this.createParameters.withPasswordCredentials(new ArrayList<PasswordCredentialInner>());
        }
        this.createParameters.passwordCredentials().add((PasswordCredentialInner)credential.inner());
        this.passwordCredentials.add(credential);
        return this;
    }

    @Override
    public ServicePrincipalImpl withExistingApplication(String id) {
        this.createParameters.withAppId(id);
        return this;
    }

    @Override
    public ServicePrincipalImpl withExistingApplication(ActiveDirectoryApplication application) {
        this.createParameters.withAppId(application.applicationId());
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewApplication(Creatable<ActiveDirectoryApplication> applicationCreatable) {
        this.addCreatableDependency(applicationCreatable);
        this.applicationCreatable = applicationCreatable;
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewApplication(String signOnUrl) {
        return this.withNewApplication(((ActiveDirectoryApplication.DefinitionStages.Blank)this.manager.applications().define(signOnUrl)).withSignOnUrl(signOnUrl).withIdentifierUrl(signOnUrl));
    }

    public GraphRbacManager manager() {
        return this.manager;
    }

    @Override
    public ServicePrincipalImpl withNewRole(BuiltInRole role, String scope) {
        this.roles.put(scope, role);
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewRoleInSubscription(BuiltInRole role, String subscriptionId) {
        this.assignedSubscription = subscriptionId;
        return this.withNewRole(role, "subscriptions/" + subscriptionId);
    }

    @Override
    public ServicePrincipalImpl withNewRoleInResourceGroup(BuiltInRole role, ResourceGroup resourceGroup) {
        return this.withNewRole(role, resourceGroup.id());
    }
}

