/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryGroup;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryGroups;
import com.microsoft.azure.management.graphrbac.implementation.ADGroupInner;
import com.microsoft.azure.management.graphrbac.implementation.ActiveDirectoryGroupImpl;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.GroupsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class ActiveDirectoryGroupsImpl
extends ReadableWrappersImpl<ActiveDirectoryGroup, ActiveDirectoryGroupImpl, ADGroupInner>
implements ActiveDirectoryGroups {
    private final GraphRbacManager manager;

    ActiveDirectoryGroupsImpl(GraphRbacManager manager) {
        this.manager = manager;
    }

    public PagedList<ActiveDirectoryGroup> list() {
        return this.wrapList(this.manager.inner().groups().list());
    }

    protected ActiveDirectoryGroupImpl wrapModel(ADGroupInner groupInner) {
        if (groupInner == null) {
            return null;
        }
        return new ActiveDirectoryGroupImpl(groupInner, this.manager());
    }

    public ActiveDirectoryGroupImpl getById(String objectId) {
        return (ActiveDirectoryGroupImpl)this.getByIdAsync(objectId).toBlocking().single();
    }

    public Observable<ActiveDirectoryGroup> getByIdAsync(String id) {
        return this.manager.inner().groups().getAsync(id).map((Func1)new Func1<ADGroupInner, ActiveDirectoryGroup>(){

            public ActiveDirectoryGroup call(ADGroupInner groupInner) {
                if (groupInner == null) {
                    return null;
                }
                return new ActiveDirectoryGroupImpl(groupInner, ActiveDirectoryGroupsImpl.this.manager());
            }
        });
    }

    public ServiceFuture<ActiveDirectoryGroup> getByIdAsync(String id, ServiceCallback<ActiveDirectoryGroup> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    public Observable<ActiveDirectoryGroup> listAsync() {
        return this.wrapPageAsync(this.manager().inner().groups().listAsync());
    }

    public Observable<ActiveDirectoryGroup> getByNameAsync(String name) {
        return this.manager().inner().groups().listAsync(String.format("displayName eq '%s'", name)).map((Func1)new Func1<Page<ADGroupInner>, ActiveDirectoryGroup>(){

            public ActiveDirectoryGroup call(Page<ADGroupInner> adGroupInnerPage) {
                if (adGroupInnerPage.items() == null || adGroupInnerPage.items().isEmpty()) {
                    return null;
                }
                return new ActiveDirectoryGroupImpl((ADGroupInner)adGroupInnerPage.items().get(0), ActiveDirectoryGroupsImpl.this.manager());
            }
        });
    }

    public ActiveDirectoryGroup getByName(String name) {
        return (ActiveDirectoryGroup)this.getByNameAsync(name).toBlocking().single();
    }

    public GraphRbacManager manager() {
        return this.manager;
    }

    public GroupsInner inner() {
        return this.manager().inner().groups();
    }
}

