/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac;

import java.util.List;
import com.microsoft.azure.management.graphrbac.implementation.PermissionInner;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Role definition properties.
 */
public class RoleDefinitionProperties {
    /**
     * The role name.
     */
    @JsonProperty(value = "roleName")
    private String roleName;

    /**
     * The role definition description.
     */
    @JsonProperty(value = "description")
    private String description;

    /**
     * The role type.
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * Role definition permissions.
     */
    @JsonProperty(value = "permissions")
    private List<PermissionInner> permissions;

    /**
     * Role definition assignable scopes.
     */
    @JsonProperty(value = "assignableScopes")
    private List<String> assignableScopes;

    /**
     * Get the roleName value.
     *
     * @return the roleName value
     */
    public String roleName() {
        return this.roleName;
    }

    /**
     * Set the roleName value.
     *
     * @param roleName the roleName value to set
     * @return the RoleDefinitionProperties object itself.
     */
    public RoleDefinitionProperties withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    /**
     * Get the description value.
     *
     * @return the description value
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description value.
     *
     * @param description the description value to set
     * @return the RoleDefinitionProperties object itself.
     */
    public RoleDefinitionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type value.
     *
     * @param type the type value to set
     * @return the RoleDefinitionProperties object itself.
     */
    public RoleDefinitionProperties withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the permissions value.
     *
     * @return the permissions value
     */
    public List<PermissionInner> permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions value.
     *
     * @param permissions the permissions value to set
     * @return the RoleDefinitionProperties object itself.
     */
    public RoleDefinitionProperties withPermissions(List<PermissionInner> permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Get the assignableScopes value.
     *
     * @return the assignableScopes value
     */
    public List<String> assignableScopes() {
        return this.assignableScopes;
    }

    /**
     * Set the assignableScopes value.
     *
     * @param assignableScopes the assignableScopes value to set
     * @return the RoleDefinitionProperties object itself.
     */
    public RoleDefinitionProperties withAssignableScopes(List<String> assignableScopes) {
        this.assignableScopes = assignableScopes;
        return this;
    }

}
