/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryApplication;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryApplications;
import com.microsoft.azure.management.graphrbac.implementation.ActiveDirectoryApplicationImpl;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationInner;
import com.microsoft.azure.management.graphrbac.implementation.ApplicationsInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class ActiveDirectoryApplicationsImpl
extends CreatableResourcesImpl<ActiveDirectoryApplication, ActiveDirectoryApplicationImpl, ApplicationInner>
implements ActiveDirectoryApplications,
HasManager<GraphRbacManager>,
HasInner<ApplicationsInner> {
    private final PagedListConverter<ApplicationInner, ActiveDirectoryApplication> converter;
    private ApplicationsInner innerCollection;
    private GraphRbacManager manager;

    ActiveDirectoryApplicationsImpl(ApplicationsInner client, GraphRbacManager graphRbacManager) {
        this.innerCollection = client;
        this.manager = graphRbacManager;
        this.converter = new PagedListConverter<ApplicationInner, ActiveDirectoryApplication>(){

            public ActiveDirectoryApplication typeConvert(ApplicationInner applicationsInner) {
                ActiveDirectoryApplicationImpl impl = ActiveDirectoryApplicationsImpl.this.wrapModel(applicationsInner);
                return (ActiveDirectoryApplication)impl.refreshCredentialsAsync().toBlocking().single();
            }
        };
    }

    public PagedList<ActiveDirectoryApplication> list() {
        return this.wrapList(this.innerCollection.list());
    }

    protected PagedList<ActiveDirectoryApplication> wrapList(PagedList<ApplicationInner> pagedList) {
        return this.converter.convert(pagedList);
    }

    public Observable<ActiveDirectoryApplication> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync()).flatMap((Func1)new Func1<ActiveDirectoryApplication, Observable<ActiveDirectoryApplication>>(){

            public Observable<ActiveDirectoryApplication> call(ActiveDirectoryApplication application) {
                return ((ActiveDirectoryApplicationImpl)application).refreshCredentialsAsync();
            }
        });
    }

    protected ActiveDirectoryApplicationImpl wrapModel(ApplicationInner applicationInner) {
        if (applicationInner == null) {
            return null;
        }
        return new ActiveDirectoryApplicationImpl(applicationInner, this.manager());
    }

    public ActiveDirectoryApplicationImpl getById(String id) {
        return (ActiveDirectoryApplicationImpl)this.getByIdAsync(id).toBlocking().single();
    }

    public Observable<ActiveDirectoryApplication> getByIdAsync(String id) {
        return this.innerCollection.getAsync(id).map((Func1)new Func1<ApplicationInner, ActiveDirectoryApplicationImpl>(){

            public ActiveDirectoryApplicationImpl call(ApplicationInner applicationInner) {
                if (applicationInner == null) {
                    return null;
                }
                return new ActiveDirectoryApplicationImpl(applicationInner, ActiveDirectoryApplicationsImpl.this.manager());
            }
        }).flatMap((Func1)new Func1<ActiveDirectoryApplicationImpl, Observable<ActiveDirectoryApplication>>(){

            public Observable<ActiveDirectoryApplication> call(ActiveDirectoryApplicationImpl application) {
                return application.refreshCredentialsAsync();
            }
        });
    }

    public ServiceFuture<ActiveDirectoryApplication> getByIdAsync(String id, ServiceCallback<ActiveDirectoryApplication> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    public ActiveDirectoryApplication getByName(String spn) {
        return (ActiveDirectoryApplication)this.getByNameAsync(spn).toBlocking().single();
    }

    public Observable<ActiveDirectoryApplication> getByNameAsync(final String name) {
        return this.innerCollection.listWithServiceResponseAsync(String.format("displayName eq '%s'", name)).flatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Observable<Page<ApplicationInner>>>(){

            public Observable<Page<ApplicationInner>> call(ServiceResponse<Page<ApplicationInner>> result) {
                if (result == null || ((Page)result.body()).items() == null || ((Page)result.body()).items().isEmpty()) {
                    return ActiveDirectoryApplicationsImpl.this.innerCollection.listAsync(String.format("appId eq '%s'", name));
                }
                return Observable.just((Object)result.body());
            }
        }).map((Func1)new Func1<Page<ApplicationInner>, ActiveDirectoryApplicationImpl>(){

            public ActiveDirectoryApplicationImpl call(Page<ApplicationInner> result) {
                if (result == null || result.items() == null || result.items().isEmpty()) {
                    return null;
                }
                return new ActiveDirectoryApplicationImpl((ApplicationInner)result.items().get(0), ActiveDirectoryApplicationsImpl.this.manager());
            }
        }).flatMap((Func1)new Func1<ActiveDirectoryApplicationImpl, Observable<ActiveDirectoryApplication>>(){

            public Observable<ActiveDirectoryApplication> call(ActiveDirectoryApplicationImpl application) {
                if (application == null) {
                    return null;
                }
                return application.refreshCredentialsAsync();
            }
        });
    }

    public GraphRbacManager manager() {
        return this.manager;
    }

    public ApplicationsInner inner() {
        return this.innerCollection;
    }

    protected ActiveDirectoryApplicationImpl wrapModel(String name) {
        return new ActiveDirectoryApplicationImpl(new ApplicationInner().withDisplayName(name), this.manager());
    }

    public Completable deleteByIdAsync(String id) {
        return this.inner().deleteAsync(id).toCompletable();
    }

    public ActiveDirectoryApplicationImpl define(String name) {
        return this.wrapModel(name);
    }
}

