/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.graphrbac.implementation.AuthorizationManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.ClassicAdministratorInner;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ClassicAdministratorsInner {
    private ClassicAdministratorsService service;
    private AuthorizationManagementClientImpl client;

    public ClassicAdministratorsInner(Retrofit retrofit, AuthorizationManagementClientImpl client) {
        this.service = (ClassicAdministratorsService)retrofit.create(ClassicAdministratorsService.class);
        this.client = client;
    }

    public PagedList<ClassicAdministratorInner> list(String apiVersion) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(apiVersion).toBlocking().single();
        return new PagedList<ClassicAdministratorInner>((Page)response.body()){

            public Page<ClassicAdministratorInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClassicAdministratorsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClassicAdministratorInner>> listAsync(String apiVersion, ListOperationCallback<ClassicAdministratorInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(apiVersion), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClassicAdministratorInner>>>>(){

            public Observable<ServiceResponse<Page<ClassicAdministratorInner>>> call(String nextPageLink) {
                return ClassicAdministratorsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClassicAdministratorInner>> listAsync(String apiVersion) {
        return this.listWithServiceResponseAsync(apiVersion).map((Func1)new Func1<ServiceResponse<Page<ClassicAdministratorInner>>, Page<ClassicAdministratorInner>>(){

            public Page<ClassicAdministratorInner> call(ServiceResponse<Page<ClassicAdministratorInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClassicAdministratorInner>>> listWithServiceResponseAsync(String apiVersion) {
        return this.listSinglePageAsync(apiVersion).concatMap((Func1)new Func1<ServiceResponse<Page<ClassicAdministratorInner>>, Observable<ServiceResponse<Page<ClassicAdministratorInner>>>>(){

            public Observable<ServiceResponse<Page<ClassicAdministratorInner>>> call(ServiceResponse<Page<ClassicAdministratorInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClassicAdministratorsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClassicAdministratorInner>>> listSinglePageAsync(String apiVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClassicAdministratorInner>>>>(){

            public Observable<ServiceResponse<Page<ClassicAdministratorInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClassicAdministratorsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ClassicAdministratorInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ClassicAdministratorInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ClassicAdministratorInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ClassicAdministratorInner>((Page)response.body()){

            public Page<ClassicAdministratorInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClassicAdministratorsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClassicAdministratorInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ClassicAdministratorInner>> serviceFuture, ListOperationCallback<ClassicAdministratorInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClassicAdministratorInner>>>>(){

            public Observable<ServiceResponse<Page<ClassicAdministratorInner>>> call(String nextPageLink) {
                return ClassicAdministratorsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClassicAdministratorInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ClassicAdministratorInner>>, Page<ClassicAdministratorInner>>(){

            public Page<ClassicAdministratorInner> call(ServiceResponse<Page<ClassicAdministratorInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClassicAdministratorInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ClassicAdministratorInner>>, Observable<ServiceResponse<Page<ClassicAdministratorInner>>>>(){

            public Observable<ServiceResponse<Page<ClassicAdministratorInner>>> call(ServiceResponse<Page<ClassicAdministratorInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClassicAdministratorsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClassicAdministratorInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClassicAdministratorInner>>>>(){

            public Observable<ServiceResponse<Page<ClassicAdministratorInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClassicAdministratorsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ClassicAdministratorInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ClassicAdministratorInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ClassicAdministratorsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ClassicAdministrators list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/classicAdministrators")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ClassicAdministrators listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

