/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies an OAuth 2.0 permission scope or an app role that an application
 * requires. The resourceAccess property of the RequiredResourceAccess type is
 * a collection of ResourceAccess.
 */
public class ResourceAccess {
    /**
     * Unmatched properties from the message are deserialized this collection.
     */
    @JsonProperty(value = "")
    private Map<String, Object> additionalProperties;

    /**
     * The unique identifier for one of the OAuth2Permission or AppRole
     * instances that the resource application exposes.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /**
     * Specifies whether the id property references an OAuth2Permission or an
     * AppRole. Possible values are "scope" or "role".
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * Get the additionalProperties value.
     *
     * @return the additionalProperties value
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties value.
     *
     * @param additionalProperties the additionalProperties value to set
     * @return the ResourceAccess object itself.
     */
    public ResourceAccess withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the ResourceAccess object itself.
     */
    public ResourceAccess withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type value.
     *
     * @param type the type value to set
     * @return the ResourceAccess object itself.
     */
    public ResourceAccess withType(String type) {
        this.type = type;
        return this;
    }

}
