/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import java.util.Map;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The properties of an Active Directory object.
 */
public class AADObjectInner {
    /**
     * Unmatched properties from the message are deserialized this collection.
     */
    @JsonProperty(value = "")
    private Map<String, Object> additionalProperties;

    /**
     * The ID of the object.
     */
    @JsonProperty(value = "objectId")
    private String objectId;

    /**
     * The type of AAD object.
     */
    @JsonProperty(value = "objectType")
    private String objectType;

    /**
     * The display name of the object.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /**
     * The principal name of the object.
     */
    @JsonProperty(value = "userPrincipalName")
    private String userPrincipalName;

    /**
     * The primary email address of the object.
     */
    @JsonProperty(value = "mail")
    private String mail;

    /**
     * Whether the AAD object is mail-enabled.
     */
    @JsonProperty(value = "mailEnabled")
    private Boolean mailEnabled;

    /**
     * The mail alias for the user.
     */
    @JsonProperty(value = "mailNickname", access = JsonProperty.Access.WRITE_ONLY)
    private String mailNickname;

    /**
     * Whether the AAD object is security-enabled.
     */
    @JsonProperty(value = "securityEnabled")
    private Boolean securityEnabled;

    /**
     * The sign-in name of the object.
     */
    @JsonProperty(value = "signInName")
    private String signInName;

    /**
     * A collection of service principal names associated with the object.
     */
    @JsonProperty(value = "servicePrincipalNames")
    private List<String> servicePrincipalNames;

    /**
     * The user type of the object.
     */
    @JsonProperty(value = "userType")
    private String userType;

    /**
     * A two letter country code (ISO standard 3166). Required for users that
     * will be assigned licenses due to legal requirement to check for
     * availability of services in countries. Examples include: "US", "JP", and
     * "GB".
     */
    @JsonProperty(value = "usageLocation", access = JsonProperty.Access.WRITE_ONLY)
    private String usageLocation;

    /**
     * The application ID.
     */
    @JsonProperty(value = "appId", access = JsonProperty.Access.WRITE_ONLY)
    private String appId;

    /**
     * The application permissions.
     */
    @JsonProperty(value = "appPermissions", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> appPermissions;

    /**
     * Whether the application is be available to other tenants.
     */
    @JsonProperty(value = "availableToOtherTenants", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean availableToOtherTenants;

    /**
     * A collection of URIs for the application.
     */
    @JsonProperty(value = "identifierUris", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> identifierUris;

    /**
     * A collection of reply URLs for the application.
     */
    @JsonProperty(value = "replyUrls", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> replyUrls;

    /**
     * The home page of the application.
     */
    @JsonProperty(value = "homepage", access = JsonProperty.Access.WRITE_ONLY)
    private String homepage;

    /**
     * Get the additionalProperties value.
     *
     * @return the additionalProperties value
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties value.
     *
     * @param additionalProperties the additionalProperties value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Get the objectId value.
     *
     * @return the objectId value
     */
    public String objectId() {
        return this.objectId;
    }

    /**
     * Set the objectId value.
     *
     * @param objectId the objectId value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    /**
     * Get the objectType value.
     *
     * @return the objectType value
     */
    public String objectType() {
        return this.objectType;
    }

    /**
     * Set the objectType value.
     *
     * @param objectType the objectType value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    /**
     * Get the displayName value.
     *
     * @return the displayName value
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName value.
     *
     * @param displayName the displayName value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the userPrincipalName value.
     *
     * @return the userPrincipalName value
     */
    public String userPrincipalName() {
        return this.userPrincipalName;
    }

    /**
     * Set the userPrincipalName value.
     *
     * @param userPrincipalName the userPrincipalName value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    /**
     * Get the mail value.
     *
     * @return the mail value
     */
    public String mail() {
        return this.mail;
    }

    /**
     * Set the mail value.
     *
     * @param mail the mail value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withMail(String mail) {
        this.mail = mail;
        return this;
    }

    /**
     * Get the mailEnabled value.
     *
     * @return the mailEnabled value
     */
    public Boolean mailEnabled() {
        return this.mailEnabled;
    }

    /**
     * Set the mailEnabled value.
     *
     * @param mailEnabled the mailEnabled value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withMailEnabled(Boolean mailEnabled) {
        this.mailEnabled = mailEnabled;
        return this;
    }

    /**
     * Get the mailNickname value.
     *
     * @return the mailNickname value
     */
    public String mailNickname() {
        return this.mailNickname;
    }

    /**
     * Get the securityEnabled value.
     *
     * @return the securityEnabled value
     */
    public Boolean securityEnabled() {
        return this.securityEnabled;
    }

    /**
     * Set the securityEnabled value.
     *
     * @param securityEnabled the securityEnabled value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withSecurityEnabled(Boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
        return this;
    }

    /**
     * Get the signInName value.
     *
     * @return the signInName value
     */
    public String signInName() {
        return this.signInName;
    }

    /**
     * Set the signInName value.
     *
     * @param signInName the signInName value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withSignInName(String signInName) {
        this.signInName = signInName;
        return this;
    }

    /**
     * Get the servicePrincipalNames value.
     *
     * @return the servicePrincipalNames value
     */
    public List<String> servicePrincipalNames() {
        return this.servicePrincipalNames;
    }

    /**
     * Set the servicePrincipalNames value.
     *
     * @param servicePrincipalNames the servicePrincipalNames value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withServicePrincipalNames(List<String> servicePrincipalNames) {
        this.servicePrincipalNames = servicePrincipalNames;
        return this;
    }

    /**
     * Get the userType value.
     *
     * @return the userType value
     */
    public String userType() {
        return this.userType;
    }

    /**
     * Set the userType value.
     *
     * @param userType the userType value to set
     * @return the AADObjectInner object itself.
     */
    public AADObjectInner withUserType(String userType) {
        this.userType = userType;
        return this;
    }

    /**
     * Get the usageLocation value.
     *
     * @return the usageLocation value
     */
    public String usageLocation() {
        return this.usageLocation;
    }

    /**
     * Get the appId value.
     *
     * @return the appId value
     */
    public String appId() {
        return this.appId;
    }

    /**
     * Get the appPermissions value.
     *
     * @return the appPermissions value
     */
    public List<String> appPermissions() {
        return this.appPermissions;
    }

    /**
     * Get the availableToOtherTenants value.
     *
     * @return the availableToOtherTenants value
     */
    public Boolean availableToOtherTenants() {
        return this.availableToOtherTenants;
    }

    /**
     * Get the identifierUris value.
     *
     * @return the identifierUris value
     */
    public List<String> identifierUris() {
        return this.identifierUris;
    }

    /**
     * Get the replyUrls value.
     *
     * @return the replyUrls value
     */
    public List<String> replyUrls() {
        return this.replyUrls;
    }

    /**
     * Get the homepage value.
     *
     * @return the homepage value
     */
    public String homepage() {
        return this.homepage;
    }

}
