/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import java.util.List;
import com.microsoft.azure.management.graphrbac.ResourceType;
import com.microsoft.azure.management.graphrbac.ProviderOperation;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Provider Operations metadata.
 */
public class ProviderOperationsMetadataInner {
    /**
     * The provider id.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * The provider name.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * The provider type.
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * The provider display name.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /**
     * The provider resource types.
     */
    @JsonProperty(value = "resourceTypes")
    private List<ResourceType> resourceTypes;

    /**
     * The provider operations.
     */
    @JsonProperty(value = "operations")
    private List<ProviderOperation> operations;

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type value.
     *
     * @param type the type value to set
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the displayName value.
     *
     * @return the displayName value
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName value.
     *
     * @param displayName the displayName value to set
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the resourceTypes value.
     *
     * @return the resourceTypes value
     */
    public List<ResourceType> resourceTypes() {
        return this.resourceTypes;
    }

    /**
     * Set the resourceTypes value.
     *
     * @param resourceTypes the resourceTypes value to set
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withResourceTypes(List<ResourceType> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    /**
     * Get the operations value.
     *
     * @return the operations value
     */
    public List<ProviderOperation> operations() {
        return this.operations;
    }

    /**
     * Set the operations value.
     *
     * @param operations the operations value to set
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withOperations(List<ProviderOperation> operations) {
        this.operations = operations;
        return this;
    }

}
