/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.RestClient;

/**
 * Initializes a new instance of the AuthorizationManagementClientImpl class.
 */
public class AuthorizationManagementClientImpl extends AzureServiceClient {
    /** the {@link AzureClient} used for long running operations. */
    private AzureClient azureClient;

    /**
     * Gets the {@link AzureClient} used for long running operations.
     * @return the azure client;
     */
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    /** The ID of the target subscription. */
    private String subscriptionId;

    /**
     * Gets The ID of the target subscription.
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Sets The ID of the target subscription.
     *
     * @param subscriptionId the subscriptionId value.
     * @return the service client itself
     */
    public AuthorizationManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /** Gets or sets the preferred language for the response. */
    private String acceptLanguage;

    /**
     * Gets Gets or sets the preferred language for the response.
     *
     * @return the acceptLanguage value.
     */
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    /**
     * Sets Gets or sets the preferred language for the response.
     *
     * @param acceptLanguage the acceptLanguage value.
     * @return the service client itself
     */
    public AuthorizationManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    /** Gets or sets the retry timeout in seconds for Long Running Operations. Default value is 30. */
    private int longRunningOperationRetryTimeout;

    /**
     * Gets Gets or sets the retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @return the longRunningOperationRetryTimeout value.
     */
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    /**
     * Sets Gets or sets the retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @param longRunningOperationRetryTimeout the longRunningOperationRetryTimeout value.
     * @return the service client itself
     */
    public AuthorizationManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    /** When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true. */
    private boolean generateClientRequestId;

    /**
     * Gets When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @return the generateClientRequestId value.
     */
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    /**
     * Sets When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @param generateClientRequestId the generateClientRequestId value.
     * @return the service client itself
     */
    public AuthorizationManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    /**
     * The ClassicAdministratorsInner object to access its operations.
     */
    private ClassicAdministratorsInner classicAdministrators;

    /**
     * Gets the ClassicAdministratorsInner object to access its operations.
     * @return the ClassicAdministratorsInner object.
     */
    public ClassicAdministratorsInner classicAdministrators() {
        return this.classicAdministrators;
    }

    /**
     * The ProviderOperationsMetadatasInner object to access its operations.
     */
    private ProviderOperationsMetadatasInner providerOperationsMetadatas;

    /**
     * Gets the ProviderOperationsMetadatasInner object to access its operations.
     * @return the ProviderOperationsMetadatasInner object.
     */
    public ProviderOperationsMetadatasInner providerOperationsMetadatas() {
        return this.providerOperationsMetadatas;
    }

    /**
     * The PermissionsInner object to access its operations.
     */
    private PermissionsInner permissions;

    /**
     * Gets the PermissionsInner object to access its operations.
     * @return the PermissionsInner object.
     */
    public PermissionsInner permissions() {
        return this.permissions;
    }

    /**
     * The RoleAssignmentsInner object to access its operations.
     */
    private RoleAssignmentsInner roleAssignments;

    /**
     * Gets the RoleAssignmentsInner object to access its operations.
     * @return the RoleAssignmentsInner object.
     */
    public RoleAssignmentsInner roleAssignments() {
        return this.roleAssignments;
    }

    /**
     * The RoleDefinitionsInner object to access its operations.
     */
    private RoleDefinitionsInner roleDefinitions;

    /**
     * Gets the RoleDefinitionsInner object to access its operations.
     * @return the RoleDefinitionsInner object.
     */
    public RoleDefinitionsInner roleDefinitions() {
        return this.roleDefinitions;
    }

    /**
     * Initializes an instance of AuthorizationManagementClient client.
     *
     * @param credentials the management credentials for Azure
     */
    public AuthorizationManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    /**
     * Initializes an instance of AuthorizationManagementClient client.
     *
     * @param baseUrl the base URL of the host
     * @param credentials the management credentials for Azure
     */
    public AuthorizationManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        initialize();
    }

    /**
     * Initializes an instance of AuthorizationManagementClient client.
     *
     * @param restClient the REST client to connect to Azure.
     */
    public AuthorizationManagementClientImpl(RestClient restClient) {
        super(restClient);
        initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.classicAdministrators = new ClassicAdministratorsInner(restClient().retrofit(), this);
        this.providerOperationsMetadatas = new ProviderOperationsMetadatasInner(restClient().retrofit(), this);
        this.permissions = new PermissionsInner(restClient().retrofit(), this);
        this.roleAssignments = new RoleAssignmentsInner(restClient().retrofit(), this);
        this.roleDefinitions = new RoleDefinitionsInner(restClient().retrofit(), this);
        this.azureClient = new AzureClient(this);
    }

    /**
     * Gets the User-Agent header for the client.
     *
     * @return the user agent string.
     */
    @Override
    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "AuthorizationManagementClient");
    }
}
