/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.graphrbac.ServicePrincipals;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalImpl;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalInner;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class ServicePrincipalsImpl
extends CreatableWrappersImpl<ServicePrincipal, ServicePrincipalImpl, ServicePrincipalInner>
implements ServicePrincipals,
HasManager<GraphRbacManager>,
HasInner<ServicePrincipalsInner> {
    private final PagedListConverter<ServicePrincipalInner, ServicePrincipal> converter;
    private ServicePrincipalsInner innerCollection;
    private GraphRbacManager manager;

    ServicePrincipalsImpl(ServicePrincipalsInner client, GraphRbacManager graphRbacManager) {
        this.innerCollection = client;
        this.manager = graphRbacManager;
        this.converter = new PagedListConverter<ServicePrincipalInner, ServicePrincipal>(){

            public Observable<ServicePrincipal> typeConvertAsync(ServicePrincipalInner servicePrincipalInner) {
                ServicePrincipalImpl impl = ServicePrincipalsImpl.this.wrapModel(servicePrincipalInner);
                return impl.refreshCredentialsAsync();
            }
        };
    }

    public PagedList<ServicePrincipal> list() {
        return this.converter.convert(this.inner().list());
    }

    public Observable<ServicePrincipal> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync()).flatMap((Func1)new Func1<ServicePrincipal, Observable<ServicePrincipal>>(){

            public Observable<ServicePrincipal> call(ServicePrincipal servicePrincipal) {
                return ((ServicePrincipalImpl)servicePrincipal).refreshCredentialsAsync();
            }
        });
    }

    protected ServicePrincipalImpl wrapModel(ServicePrincipalInner servicePrincipalInner) {
        if (servicePrincipalInner == null) {
            return null;
        }
        return new ServicePrincipalImpl(servicePrincipalInner, this.manager());
    }

    public ServicePrincipalImpl getById(String id) {
        return (ServicePrincipalImpl)this.getByIdAsync(id).toBlocking().single();
    }

    public Observable<ServicePrincipal> getByIdAsync(String id) {
        return this.innerCollection.getAsync(id).flatMap((Func1)new Func1<ServicePrincipalInner, Observable<ServicePrincipal>>(){

            public Observable<ServicePrincipal> call(ServicePrincipalInner servicePrincipalInner) {
                if (servicePrincipalInner == null) {
                    return Observable.just(null);
                }
                return new ServicePrincipalImpl(servicePrincipalInner, ServicePrincipalsImpl.this.manager()).refreshCredentialsAsync();
            }
        });
    }

    public ServiceFuture<ServicePrincipal> getByIdAsync(String id, ServiceCallback<ServicePrincipal> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    public ServicePrincipal getByName(String spn) {
        return (ServicePrincipal)this.getByNameAsync(spn).toBlocking().single();
    }

    public Observable<ServicePrincipal> getByNameAsync(final String name) {
        return this.innerCollection.listWithServiceResponseAsync(String.format("servicePrincipalNames/any(c:c eq '%s')", name)).flatMap((Func1)new Func1<ServiceResponse<Page<ServicePrincipalInner>>, Observable<Page<ServicePrincipalInner>>>(){

            public Observable<Page<ServicePrincipalInner>> call(ServiceResponse<Page<ServicePrincipalInner>> result) {
                if (result == null || ((Page)result.body()).items() == null || ((Page)result.body()).items().isEmpty()) {
                    return ServicePrincipalsImpl.this.innerCollection.listAsync(String.format("displayName eq '%s'", name));
                }
                return Observable.just((Object)result.body());
            }
        }).map((Func1)new Func1<Page<ServicePrincipalInner>, ServicePrincipalImpl>(){

            public ServicePrincipalImpl call(Page<ServicePrincipalInner> result) {
                if (result == null || result.items() == null || result.items().isEmpty()) {
                    return null;
                }
                return new ServicePrincipalImpl((ServicePrincipalInner)result.items().get(0), ServicePrincipalsImpl.this.manager());
            }
        }).flatMap((Func1)new Func1<ServicePrincipalImpl, Observable<ServicePrincipal>>(){

            public Observable<ServicePrincipal> call(ServicePrincipalImpl servicePrincipal) {
                if (servicePrincipal == null) {
                    return null;
                }
                return servicePrincipal.refreshCredentialsAsync();
            }
        });
    }

    public GraphRbacManager manager() {
        return this.manager;
    }

    public ServicePrincipalsInner inner() {
        return this.innerCollection;
    }

    public ServicePrincipalImpl define(String name) {
        return new ServicePrincipalImpl(new ServicePrincipalInner().withDisplayName(name), this.manager());
    }

    protected ServicePrincipalImpl wrapModel(String name) {
        return new ServicePrincipalImpl(new ServicePrincipalInner().withDisplayName(name), this.manager());
    }

    public Completable deleteByIdAsync(String id) {
        return this.manager().inner().servicePrincipals().deleteAsync(id).toCompletable();
    }
}

