/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import java.util.Map;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonSubTypes;

/**
 * Represents an Azure Active Directory object.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "objectType")
@JsonTypeName("DirectoryObject")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "Application", value = ApplicationInner.class),
    @JsonSubTypes.Type(name = "Group", value = ADGroupInner.class),
    @JsonSubTypes.Type(name = "ServicePrincipal", value = ServicePrincipalInner.class),
    @JsonSubTypes.Type(name = "User", value = UserInner.class)
})
public class DirectoryObjectInner {
    /**
     * Unmatched properties from the message are deserialized this collection.
     */
    @JsonProperty(value = "")
    private Map<String, Object> additionalProperties;

    /**
     * The object ID.
     */
    @JsonProperty(value = "objectId", access = JsonProperty.Access.WRITE_ONLY)
    private String objectId;

    /**
     * The time at which the directory object was deleted.
     */
    @JsonProperty(value = "deletionTimestamp", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime deletionTimestamp;

    /**
     * Get the additionalProperties value.
     *
     * @return the additionalProperties value
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties value.
     *
     * @param additionalProperties the additionalProperties value to set
     * @return the DirectoryObjectInner object itself.
     */
    public DirectoryObjectInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Get the objectId value.
     *
     * @return the objectId value
     */
    public String objectId() {
        return this.objectId;
    }

    /**
     * Get the deletionTimestamp value.
     *
     * @return the deletionTimestamp value
     */
    public DateTime deletionTimestamp() {
        return this.deletionTimestamp;
    }

}
