/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Request parameters for GetMemberGroups API call.
 */
public class UserGetMemberGroupsParameters {
    /**
     * If true, only membership in security-enabled groups should be checked.
     * Otherwise, membership in all groups should be checked.
     */
    @JsonProperty(value = "securityEnabledOnly", required = true)
    private boolean securityEnabledOnly;

    /**
     * Get the securityEnabledOnly value.
     *
     * @return the securityEnabledOnly value
     */
    public boolean securityEnabledOnly() {
        return this.securityEnabledOnly;
    }

    /**
     * Set the securityEnabledOnly value.
     *
     * @param securityEnabledOnly the securityEnabledOnly value to set
     * @return the UserGetMemberGroupsParameters object itself.
     */
    public UserGetMemberGroupsParameters withSecurityEnabledOnly(boolean securityEnabledOnly) {
        this.securityEnabledOnly = securityEnabledOnly;
        return this;
    }

}
