/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.graphrbac.RoleAssignmentCreateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in RoleAssignments.
 */
public class RoleAssignmentsInner implements InnerSupportsDelete<RoleAssignmentInner> {
    /** The Retrofit service to perform REST calls. */
    private RoleAssignmentsService service;
    /** The service client containing this operation class. */
    private AuthorizationManagementClientImpl client;

    /**
     * Initializes an instance of RoleAssignmentsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RoleAssignmentsInner(Retrofit retrofit, AuthorizationManagementClientImpl client) {
        this.service = retrofit.create(RoleAssignmentsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for RoleAssignments to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RoleAssignmentsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForResource" })
        @GET("subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/roleAssignments")
        Observable<Response<ResponseBody>> listForResource(@Path("resourceGroupName") String resourceGroupName, @Path("resourceProviderNamespace") String resourceProviderNamespace, @Path(value = "parentResourcePath", encoded = true) String parentResourcePath, @Path(value = "resourceType", encoded = true) String resourceType, @Path("resourceName") String resourceName, @Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/roleAssignments")
        Observable<Response<ResponseBody>> listForResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments delete" })
        @HTTP(path = "{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path(value = "scope", encoded = true) String scope, @Path("roleAssignmentName") String roleAssignmentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments create" })
        @PUT("{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        Observable<Response<ResponseBody>> create(@Path(value = "scope", encoded = true) String scope, @Path("roleAssignmentName") String roleAssignmentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body RoleAssignmentCreateParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments get" })
        @GET("{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        Observable<Response<ResponseBody>> get(@Path(value = "scope", encoded = true) String scope, @Path("roleAssignmentName") String roleAssignmentName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments deleteById" })
        @HTTP(path = "{roleAssignmentId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteById(@Path(value = "roleAssignmentId", encoded = true) String roleAssignmentId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments createById" })
        @PUT("{roleAssignmentId}")
        Observable<Response<ResponseBody>> createById(@Path(value = "roleAssignmentId", encoded = true) String roleAssignmentId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body RoleAssignmentCreateParameters parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments getById" })
        @GET("{roleAssignmentId}")
        Observable<Response<ResponseBody>> getById(@Path(value = "roleAssignmentId", encoded = true) String roleAssignmentId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Authorization/roleAssignments")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForScope" })
        @GET("{scope}/providers/Microsoft.Authorization/roleAssignments")
        Observable<Response<ResponseBody>> listForScope(@Path(value = "scope", encoded = true) String scope, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForResourceNext" })
        @GET
        Observable<Response<ResponseBody>> listForResourceNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listForResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.RoleAssignments listForScopeNext" })
        @GET
        Observable<Response<ResponseBody>> listForScopeNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForResource(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForResourceAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForResourceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForResourceAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        return listForResourceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceWithServiceResponseAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        return listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForResourceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceSinglePageAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.listForResource(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForResourceDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForResource(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForResourceAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForResourceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForResourceAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        return listForResourceWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceWithServiceResponseAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        return listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForResourceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param resourceProviderNamespace The namespace of the resource provider.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param parentResourcePath The parent resource identity.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param resourceType The resource type of the resource.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param resourceName The name of the resource to get role assignments for.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceSinglePageAsync(final String resourceGroupName, final String resourceProviderNamespace, final String parentResourcePath, final String resourceType, final String resourceName, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listForResource(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForResourceDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForResourceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForResourceGroupAsync(final String resourceGroupName) {
        return listForResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listForResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.listForResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForResourceGroup(final String resourceGroupName, final String filter) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForResourceGroupSinglePageAsync(resourceGroupName, filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForResourceGroupAsync(final String resourceGroupName, final String filter, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForResourceGroupSinglePageAsync(resourceGroupName, filter),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForResourceGroupAsync(final String resourceGroupName, final String filter) {
        return listForResourceGroupWithServiceResponseAsync(resourceGroupName, filter)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceGroupWithServiceResponseAsync(final String resourceGroupName, final String filter) {
        return listForResourceGroupSinglePageAsync(resourceGroupName, filter)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param resourceGroupName The name of the resource group.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceGroupSinglePageAsync(final String resourceGroupName, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listForResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner delete(String scope, String roleAssignmentName) {
        return deleteWithServiceResponseAsync(scope, roleAssignmentName).toBlocking().single().body();
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(scope, roleAssignmentName), serviceCallback);
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName) {
        return deleteWithServiceResponseAsync(scope, roleAssignmentName).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> deleteWithServiceResponseAsync(String scope, String roleAssignmentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(scope, roleAssignmentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner create(String scope, String roleAssignmentName) {
        return createWithServiceResponseAsync(scope, roleAssignmentName).toBlocking().single().body();
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(scope, roleAssignmentName), serviceCallback);
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName) {
        return createWithServiceResponseAsync(scope, roleAssignmentName).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> createWithServiceResponseAsync(String scope, String roleAssignmentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final RoleAssignmentPropertiesInner properties = null;
        RoleAssignmentCreateParameters parameters = new RoleAssignmentCreateParameters();
        parameters.withProperties(null);
        return service.create(scope, roleAssignmentName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param properties Role assignment properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner create(String scope, String roleAssignmentName, RoleAssignmentPropertiesInner properties) {
        return createWithServiceResponseAsync(scope, roleAssignmentName, properties).toBlocking().single().body();
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param properties Role assignment properties.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName, RoleAssignmentPropertiesInner properties, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(scope, roleAssignmentName, properties), serviceCallback);
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param properties Role assignment properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> createAsync(String scope, String roleAssignmentName, RoleAssignmentPropertiesInner properties) {
        return createWithServiceResponseAsync(scope, roleAssignmentName, properties).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param properties Role assignment properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> createWithServiceResponseAsync(String scope, String roleAssignmentName, RoleAssignmentPropertiesInner properties) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(properties);
        RoleAssignmentCreateParameters parameters = new RoleAssignmentCreateParameters();
        parameters.withProperties(properties);
        return service.create(scope, roleAssignmentName, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner get(String scope, String roleAssignmentName) {
        return getWithServiceResponseAsync(scope, roleAssignmentName).toBlocking().single().body();
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(scope, roleAssignmentName), serviceCallback);
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName) {
        return getWithServiceResponseAsync(scope, roleAssignmentName).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> getWithServiceResponseAsync(String scope, String roleAssignmentName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (roleAssignmentName == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(scope, roleAssignmentName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleAssignmentId The ID of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner deleteById(String roleAssignmentId) {
        return deleteByIdWithServiceResponseAsync(roleAssignmentId).toBlocking().single().body();
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleAssignmentId The ID of the role assignment to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> deleteByIdAsync(String roleAssignmentId, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(deleteByIdWithServiceResponseAsync(roleAssignmentId), serviceCallback);
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleAssignmentId The ID of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> deleteByIdAsync(String roleAssignmentId) {
        return deleteByIdWithServiceResponseAsync(roleAssignmentId).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleAssignmentId The ID of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> deleteByIdWithServiceResponseAsync(String roleAssignmentId) {
        if (roleAssignmentId == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteById(roleAssignmentId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = deleteByIdDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> deleteByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner createById(String roleAssignmentId) {
        return createByIdWithServiceResponseAsync(roleAssignmentId).toBlocking().single().body();
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to create.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> createByIdAsync(String roleAssignmentId, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(createByIdWithServiceResponseAsync(roleAssignmentId), serviceCallback);
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> createByIdAsync(String roleAssignmentId) {
        return createByIdWithServiceResponseAsync(roleAssignmentId).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> createByIdWithServiceResponseAsync(String roleAssignmentId) {
        if (roleAssignmentId == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final RoleAssignmentPropertiesInner properties = null;
        RoleAssignmentCreateParameters parameters = new RoleAssignmentCreateParameters();
        parameters.withProperties(null);
        return service.createById(roleAssignmentId, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = createByIdDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to create.
     * @param properties Role assignment properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner createById(String roleAssignmentId, RoleAssignmentPropertiesInner properties) {
        return createByIdWithServiceResponseAsync(roleAssignmentId, properties).toBlocking().single().body();
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to create.
     * @param properties Role assignment properties.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> createByIdAsync(String roleAssignmentId, RoleAssignmentPropertiesInner properties, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(createByIdWithServiceResponseAsync(roleAssignmentId, properties), serviceCallback);
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to create.
     * @param properties Role assignment properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> createByIdAsync(String roleAssignmentId, RoleAssignmentPropertiesInner properties) {
        return createByIdWithServiceResponseAsync(roleAssignmentId, properties).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to create.
     * @param properties Role assignment properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> createByIdWithServiceResponseAsync(String roleAssignmentId, RoleAssignmentPropertiesInner properties) {
        if (roleAssignmentId == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(properties);
        RoleAssignmentCreateParameters parameters = new RoleAssignmentCreateParameters();
        parameters.withProperties(properties);
        return service.createById(roleAssignmentId, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = createByIdDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> createByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RoleAssignmentInner object if successful.
     */
    public RoleAssignmentInner getById(String roleAssignmentId) {
        return getByIdWithServiceResponseAsync(roleAssignmentId).toBlocking().single().body();
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to get.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RoleAssignmentInner> getByIdAsync(String roleAssignmentId, final ServiceCallback<RoleAssignmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByIdWithServiceResponseAsync(roleAssignmentId), serviceCallback);
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<RoleAssignmentInner> getByIdAsync(String roleAssignmentId) {
        return getByIdWithServiceResponseAsync(roleAssignmentId).map(new Func1<ServiceResponse<RoleAssignmentInner>, RoleAssignmentInner>() {
            @Override
            public RoleAssignmentInner call(ServiceResponse<RoleAssignmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleAssignmentId The ID of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RoleAssignmentInner object
     */
    public Observable<ServiceResponse<RoleAssignmentInner>> getByIdWithServiceResponseAsync(String roleAssignmentId) {
        if (roleAssignmentId == null) {
            throw new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getById(roleAssignmentId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RoleAssignmentInner>>>() {
                @Override
                public Observable<ServiceResponse<RoleAssignmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RoleAssignmentInner> clientResponse = getByIdDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RoleAssignmentInner> getByIdDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RoleAssignmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RoleAssignmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> list() {
        ServiceResponse<Page<RoleAssignmentInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listAsync(final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.list(this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> list(final String filter) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listAsync(final String filter, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(filter),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listAsync(final String filter) {
        return listWithServiceResponseAsync(filter)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listWithServiceResponseAsync(final String filter) {
        return listSinglePageAsync(filter)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listSinglePageAsync(final String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForScope(final String scope) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForScopeSinglePageAsync(scope).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForScopeAsync(final String scope, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForScopeSinglePageAsync(scope),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForScopeAsync(final String scope) {
        return listForScopeWithServiceResponseAsync(scope)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeWithServiceResponseAsync(final String scope) {
        return listForScopeSinglePageAsync(scope)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeSinglePageAsync(final String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.listForScope(scope, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForScopeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForScope(final String scope, final String filter) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForScopeSinglePageAsync(scope, filter).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForScopeAsync(final String scope, final String filter, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForScopeSinglePageAsync(scope, filter),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForScopeAsync(final String scope, final String filter) {
        return listForScopeWithServiceResponseAsync(scope, filter)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeWithServiceResponseAsync(final String scope, final String filter) {
        return listForScopeSinglePageAsync(scope, filter)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param scope The scope of the role assignments.
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeSinglePageAsync(final String scope, final String filter) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listForScope(scope, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForScopeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForResourceNext(final String nextPageLink) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForResourceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForResourceNextAsync(final String nextPageLink, final ServiceFuture<List<RoleAssignmentInner>> serviceFuture, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForResourceNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForResourceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForResourceNextAsync(final String nextPageLink) {
        return listForResourceNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceNextWithServiceResponseAsync(final String nextPageLink) {
        return listForResourceNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForResourceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listForResourceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForResourceNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForResourceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<RoleAssignmentInner>> serviceFuture, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForResourceGroupNextAsync(final String nextPageLink) {
        return listForResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listForResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a resource group.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listForResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<RoleAssignmentInner>> serviceFuture, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all role assignments for the subscription.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RoleAssignmentInner&gt; object if successful.
     */
    public PagedList<RoleAssignmentInner> listForScopeNext(final String nextPageLink) {
        ServiceResponse<Page<RoleAssignmentInner>> response = listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RoleAssignmentInner>(response.body()) {
            @Override
            public Page<RoleAssignmentInner> nextPage(String nextPageLink) {
                return listForScopeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RoleAssignmentInner>> listForScopeNextAsync(final String nextPageLink, final ServiceFuture<List<RoleAssignmentInner>> serviceFuture, final ListOperationCallback<RoleAssignmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listForScopeNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(String nextPageLink) {
                    return listForScopeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<Page<RoleAssignmentInner>> listForScopeNextAsync(final String nextPageLink) {
        return listForScopeNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Page<RoleAssignmentInner>>() {
                @Override
                public Page<RoleAssignmentInner> call(ServiceResponse<Page<RoleAssignmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RoleAssignmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeNextWithServiceResponseAsync(final String nextPageLink) {
        return listForScopeNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RoleAssignmentInner>>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(ServiceResponse<Page<RoleAssignmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listForScopeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets role assignments for a scope.
     *
    ServiceResponse<PageImpl<RoleAssignmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RoleAssignmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RoleAssignmentInner>>> listForScopeNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listForScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RoleAssignmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RoleAssignmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RoleAssignmentInner>> result = listForScopeNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RoleAssignmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RoleAssignmentInner>> listForScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RoleAssignmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RoleAssignmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
