/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.graphrbac.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Active Directory Domain information.
 */
public class DomainInner {
    /**
     * the type of the authentication into the domain.
     */
    @JsonProperty(value = "authenticationType", access = JsonProperty.Access.WRITE_ONLY)
    private String authenticationType;

    /**
     * if this is the default domain in the tenant.
     */
    @JsonProperty(value = "isDefault", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isDefault;

    /**
     * if this domain's ownership is verified.
     */
    @JsonProperty(value = "isVerified", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isVerified;

    /**
     * the domain name.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * Get the authenticationType value.
     *
     * @return the authenticationType value
     */
    public String authenticationType() {
        return this.authenticationType;
    }

    /**
     * Get the isDefault value.
     *
     * @return the isDefault value
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Get the isVerified value.
     *
     * @return the isVerified value
     */
    public Boolean isVerified() {
        return this.isVerified;
    }

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the DomainInner object itself.
     */
    public DomainInner withName(String name) {
        this.name = name;
        return this;
    }

}
